/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.sql.SQLException;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.hibernate.AlarmDaoHibernate;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.transaction.AfterTransaction;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath:/META-INF/opennms/applicationContext-minimal-conf.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class AuthorizationTest
implements InitializingBean {
    @Autowired
    AlarmDao m_alarmDao;
    @Autowired
    CategoryDao m_categoryDao;
    @Autowired
    DatabasePopulator m_populator;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @BeforeTransaction
    public void setUp() {
        this.m_populator.populateDatabase();
    }

    @AfterTransaction
    public void tearDown() {
        this.m_populator.resetDatabase();
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testAuthorizedAlarms() {
        List matching = this.m_alarmDao.findAll();
        Assert.assertNotNull((Object)matching);
        Assert.assertEquals((long)1L, (long)matching.size());
        System.err.println(matching);
        this.enableAuthorizationFilter("NonExistentGroup");
        List matching2 = this.m_alarmDao.findAll();
        Assert.assertNotNull((Object)matching2);
        Assert.assertEquals((long)0L, (long)matching2.size());
        System.err.println(matching2);
        this.disableAuthorizationFilter();
        List matching3 = this.m_alarmDao.findAll();
        Assert.assertNotNull((Object)matching3);
        Assert.assertEquals((long)1L, (long)matching3.size());
        System.err.println(matching3);
    }

    @Test
    @Transactional
    @Ignore(value="What does this even do?  Category 'groups' aren't even exposed in DAOs.")
    @JUnitTemporaryDatabase
    public void testGetCategoriesWithAuthorizedGroups() {
        List categories = this.m_categoryDao.getCategoriesWithAuthorizedGroup("RoutersGroup");
        Assert.assertNotNull((Object)categories);
        Assert.assertEquals((long)1L, (long)categories.size());
        Assert.assertEquals((Object)"Routers", (Object)((OnmsCategory)categories.get(0)).getName());
    }

    public void enableAuthorizationFilter(final String ... groupNames) {
        HibernateCallback<Object> cb = new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.enableFilter("authorizedOnly").setParameterList("userGroups", (Object[])groupNames);
                return null;
            }
        };
        ((AlarmDaoHibernate)this.m_alarmDao).getHibernateTemplate().execute((HibernateCallback)cb);
    }

    public void disableAuthorizationFilter() {
        HibernateCallback<Object> cb = new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.disableFilter("authorizedOnly");
                return null;
            }
        };
        ((AlarmDaoHibernate)this.m_alarmDao).getHibernateTemplate().execute((HibernateCallback)cb);
    }
}

