/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.opennms.netmgt.config.StorageStrategy;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.support.GenericIndexResourceType;
import org.opennms.netmgt.dao.support.NullRrdStrategy;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.rrd.RrdStrategy;
import org.opennms.netmgt.rrd.RrdUtils;
import org.opennms.test.FileAnticipator;
import org.opennms.test.mock.EasyMockUtils;

public class GenericIndexResourceTypeTest
extends TestCase {
    private FileAnticipator m_fileAnticipator;
    private EasyMockUtils m_mocks = new EasyMockUtils();
    private ResourceDao m_resourceDao = (ResourceDao)this.m_mocks.createMock(ResourceDao.class);
    private StorageStrategy m_storageStrategy = (StorageStrategy)this.m_mocks.createMock(StorageStrategy.class);

    protected void setUp() throws Exception {
        super.setUp();
        RrdUtils.setStrategy((RrdStrategy)new NullRrdStrategy());
        this.m_fileAnticipator = new FileAnticipator(false);
    }

    protected void runTest() throws Throwable {
        super.runTest();
        if (this.m_fileAnticipator.isInitialized()) {
            this.m_fileAnticipator.deleteExpected();
        }
    }

    protected void tearDown() throws Exception {
        this.m_fileAnticipator.tearDown();
        super.tearDown();
    }

    public void testGetResourceByNodeAndIndexGetLabelPlain() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "plain", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "1");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"plain", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelIndex() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "${index}", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "1");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"1", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelStringAttribute() throws Exception {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "${stringAttribute}", this.m_storageStrategy);
        this.m_fileAnticipator.initialize();
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)this.m_fileAnticipator.getTempDir());
        File snmpDir = this.m_fileAnticipator.tempDir("snmp");
        File snmpNodeDir = this.m_fileAnticipator.tempDir(snmpDir, "1");
        File fooDir = this.m_fileAnticipator.tempDir(snmpNodeDir, "foo");
        File indexDir = this.m_fileAnticipator.tempDir(fooDir, "1");
        this.m_fileAnticipator.tempFile(indexDir, "strings.properties", "stringAttribute=hello!!!!");
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "1");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"hello!!!!", (String)resource.getLabel());
    }

    public void testGetResourceByNodeSourceAndIndexGetLabelStringAttribute() throws Exception {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "${stringAttribute}", this.m_storageStrategy);
        this.m_fileAnticipator.initialize();
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)this.m_fileAnticipator.getTempDir());
        File snmpDir = this.m_fileAnticipator.tempDir("snmp");
        File forSrcDir = this.m_fileAnticipator.tempDir(snmpDir, "fs");
        File snmpNodeSourceDir = this.m_fileAnticipator.tempDir(forSrcDir, "source1");
        File forIdDir = this.m_fileAnticipator.tempDir(snmpNodeSourceDir, "123");
        File fooDir = this.m_fileAnticipator.tempDir(forIdDir, "foo");
        File indexDir = this.m_fileAnticipator.tempDir(fooDir, "1");
        this.m_fileAnticipator.tempFile(indexDir, "strings.properties", "stringAttribute=hello!!!!");
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeSourceAndIndex("source1:123", "1");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"hello!!!!", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubIndexNumber() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "${subIndex(3, 1)}", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "1.2.3.4");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"4", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubIndexBogusArguments() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "${subIndex(absolutely bogus)}", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "1.2.3.4");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"${subIndex(absolutely bogus)}", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubIndexBogusOffset() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "${subIndex(foo, 1)}", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "1.2.3.4");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"${subIndex(foo, 1)}", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubIndexBadNumber() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "${subIndex(4, 1)}", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "1.2.3.4");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"${subIndex(4, 1)}", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubIndexBeginning() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "${subIndex(1)}", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "1.2.3.4");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"2.3.4", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubIndexEnding() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "${subIndex(0, 3)}", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "1.2.3.4");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"1.2.3", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubIndexNoArguments() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "${subIndex()}", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "1.2.3.4");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"${subIndex()}", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubIndexStartOutOfBounds() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "${subIndex(4)}", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "1.2.3.4");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"${subIndex(4)}", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubIndexEndOutOfBounds() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "${subIndex(0, 5)}", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "1.2.3.4");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"${subIndex(0, 5)}", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelIndexWithHexConversion() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "${hex(index)}", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "1.2.3.4.14.15");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"01:02:03:04:0E:0F", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelIndexWithHexConversionBogusInteger() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "${hex(index)}", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "foo");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"${hex(index)}", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubStringAndHexConversion() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "MAC Address ${hex(subIndex(0, 6))} on interface ${subIndex(6, 1)}", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "0.21.109.80.9.66.4");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"MAC Address 00:15:6D:50:09:42 on interface 4", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubStringOfDynamicLength() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "Easy as ${subIndex(0, n)}", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "5.1.2.3.4.5");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"Easy as 1.2.3.4.5", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelIndexWithThreeSubStringsOfDynamicLength() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "Easy as ${subIndex(0, n)} and ${subIndex(n, n)} and ${subIndex(n, n)}", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "1.1.2.1.2.3.1.2.3");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"Easy as 1 and 1.2 and 1.2.3", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubStringAndDynSubStringAndDynSubStringAndSubStringToEnd() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "Easy as ${subIndex(0, 1)} and ${subIndex(1, n)} and ${subIndex(n, n)} and ${subIndex(n)}", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "3.3.1.2.3.3.4.5.6.0");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"Easy as 3 and 1.2.3 and 4.5.6 and 0", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelIndexWithDisplaySubStringOfDynamicLength() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "Easy as ${string(subIndex(0, n))}", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "3.112.105.101");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"Easy as pie", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelIndexWithSubStringAndTwoDisplaySubStringsOfDynamicLengthAndSubStringToEnd() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "Easy as ${subIndex(0, 1)} piece of ${string(subIndex(1, n))} or just under ${string(subIndex(n, n))} pieces of ${subIndex(n)}", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "1.3.112.105.101.2.80.105.3.1.4.1.5.9");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"Easy as 1 piece of pie or just under Pi pieces of 3.1.4.1.5.9", (String)resource.getLabel());
    }

    public void testGetResourceByNodeAndIndexGetLabelIndexWithBogusUseOfNforStartOfFirstSubIndex() {
        GenericIndexResourceType rt = new GenericIndexResourceType(this.m_resourceDao, "foo", "Foo Resource", "Easy as ${subIndex(n, 3)}", this.m_storageStrategy);
        EasyMock.expect((Object)this.m_resourceDao.getRrdDirectory()).andReturn((Object)new File("/a/bogus/directory"));
        this.m_mocks.replayAll();
        OnmsResource resource = rt.getResourceByNodeAndIndex(1, "3.1.2.3");
        this.m_mocks.verifyAll();
        GenericIndexResourceTypeTest.assertNotNull((String)"resource", (Object)resource);
        GenericIndexResourceTypeTest.assertEquals((String)"resource label", (String)"Easy as ${subIndex(n, 3)}", (String)resource.getLabel());
    }
}

