/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.stats;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.Fetch;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.BeanUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.stats.DefaultAlarmStatisticsService;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class AlarmStatisticsServiceTest
implements InitializingBean {
    @Autowired
    DatabasePopulator m_dbPopulator;
    @Autowired
    private DefaultAlarmStatisticsService m_statisticsService;
    private static boolean m_initialized = false;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        MockLogAppender.setupLogging();
        if (!m_initialized) {
            this.m_dbPopulator.populateDatabase();
        }
        m_initialized = true;
    }

    @Test
    public void testCount() {
        CriteriaBuilder cb = new CriteriaBuilder(OnmsAlarm.class);
        cb.fetch("firstEvent", Fetch.FetchType.EAGER);
        cb.fetch("lastEvent", Fetch.FetchType.EAGER);
        cb.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        cb.alias("node.snmpInterfaces", "snmpInterface", Alias.JoinType.LEFT_JOIN);
        cb.alias("node.ipInterfaces", "ipInterface", Alias.JoinType.LEFT_JOIN);
        cb.distinct();
        int count = this.m_statisticsService.getTotalCount(cb.toCriteria());
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testCountBySeverity() {
        CriteriaBuilder cb = new CriteriaBuilder(OnmsAlarm.class);
        cb.ge("severity", (Object)OnmsSeverity.NORMAL);
        cb.fetch("firstEvent", Fetch.FetchType.EAGER);
        cb.fetch("lastEvent", Fetch.FetchType.EAGER);
        cb.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        cb.alias("node.snmpInterfaces", "snmpInterface", Alias.JoinType.LEFT_JOIN);
        cb.alias("node.ipInterfaces", "ipInterface", Alias.JoinType.LEFT_JOIN);
        cb.distinct();
        int count = this.m_statisticsService.getTotalCount(cb.toCriteria());
        Assert.assertEquals((long)1L, (long)count);
    }
}

