/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.jaxb;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.junit.After;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.utils.LogUtils;
import org.opennms.core.xml.CastorUtils;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.netmgt.xml.event.Events;
import org.opennms.netmgt.xml.event.Log;

public class JaxbUtilsTest {
    private static final String m_xmlWithNamespace = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><event uuid=\"1234\" xmlns=\"http://xmlns.opennms.org/xsd/event\"><dbid>37</dbid><dist-poller>localhost</dist-poller><creation-time>Friday, March 18, 2011 1:34:13 PM GMT</creation-time><master-station>chief</master-station><mask><maskelement><mename>generic</mename><mevalue>6</mevalue></maskelement></mask><uei>uei.opennms.org/test</uei><source>JaxbCastorEquivalenceTest</source><nodeid>1</nodeid><time>Friday, March 18, 2011 1:34:13 PM GMT</time><host>funkytown</host><interface>192.168.0.1</interface><snmphost>192.168.0.1</snmphost><service>ICMP</service><snmp><id>.1.3.6.15</id><idtext>I am a banana!</idtext><version>v2c</version><specific>0</specific><generic>6</generic><community>public</community><time-stamp>1300455253196</time-stamp></snmp><parms><parm><parmName>foo</parmName><value encoding=\"text\" type=\"string\">bar</value></parm></parms><descr>This is a test thingy.</descr><logmsg dest=\"logndisplay\" notify=\"true\">this is a log message</logmsg><severity>Indeterminate</severity><pathoutage>monkeys</pathoutage><correlation path=\"pathOutage\" state=\"on\"><cuei>uei.opennms.org/funky-stuff</cuei><cmin>1</cmin><cmax>17</cmax><ctime>yesterday</ctime></correlation><operinstruct>run away</operinstruct><autoaction state=\"off\">content</autoaction><operaction menutext=\"this is in the menu!\" state=\"on\">totally actiony</operaction><autoacknowledge state=\"off\">content</autoacknowledge><loggroup>foo</loggroup><loggroup>bar</loggroup><tticket state=\"on\">tticket stuff</tticket><forward mechanism=\"snmptcp\" state=\"on\">I like shoes.</forward><script language=\"zombo\">the unattainable is within reach, at zombo.com</script><ifIndex>53</ifIndex><ifAlias>giggetE</ifAlias><mouseovertext>click here to buy now!!!!1!1!</mouseovertext><alarm-data x733-probable-cause=\"27\" x733-alarm-type=\"TimeDomainViolation\" auto-clean=\"true\" clear-key=\"car\" alarm-type=\"19\" reduction-key=\"bus\"/></event>";
    private static final String m_logXml = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><log xmlns=\"http://xmlns.opennms.org/xsd/event\"><events><event><creation-time>Monday, March 21, 2011 8:34:21 PM GMT</creation-time><uei>uei.opennms.org/test</uei><source>JaxbUtilsTest</source><time>Monday, March 21, 2011 8:34:21 PM GMT</time><descr>test</descr></event><event><creation-time>Monday, March 21, 2011 8:34:21 PM GMT</creation-time><uei>uei.opennms.org/test</uei><source>JaxbUtilsTest</source><time>Monday, March 21, 2011 8:34:21 PM GMT</time><descr>test 2</descr></event></events></log>";
    private static final String m_logXmlWithoutNamespace = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?><log><events><event><creation-time>Monday, March 21, 2011 8:34:21 PM GMT</creation-time><uei>uei.opennms.org/test</uei><source>JaxbUtilsTest</source><time>Monday, March 21, 2011 8:34:21 PM GMT</time><descr>test</descr></event><event><creation-time>Monday, March 21, 2011 8:34:21 PM GMT</creation-time><uei>uei.opennms.org/test</uei><source>JaxbUtilsTest</source><time>Monday, March 21, 2011 8:34:21 PM GMT</time><descr>test 2</descr></event></events></log>";

    @Before
    public void setUp() {
        MockLogAppender.setupLogging();
    }

    @After
    public void tearDown() {
        MockLogAppender.assertNoWarningsOrGreater();
    }

    @Test
    public void testMarshalEvent() throws Exception {
        Event e = this.getEvent();
        String xml = JaxbUtils.marshal((Object)e);
        Assert.assertTrue((boolean)xml.contains("JaxbUtilsTest"));
        LogUtils.debugf((Object)this, (String)"event = %s", (Object[])new Object[]{e});
        LogUtils.debugf((Object)this, (String)"xml = %s", (Object[])new Object[]{xml});
        StringWriter sw = new StringWriter();
        JaxbUtils.marshal((Object)e, (Writer)sw);
        Assert.assertEquals((Object)sw.toString(), (Object)xml);
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        InputStream is = this.getClass().getResourceAsStream("/xsds/event.xsd");
        Assume.assumeNotNull((Object[])new Object[]{is});
        LogUtils.debugf((Object)this, (String)"Hooray!  We have an XSD!", (Object[])new Object[0]);
        Schema schema = factory.newSchema(new StreamSource(is));
        Validator v = schema.newValidator();
        v.validate(new StreamSource(new StringReader(xml)));
    }

    @Test
    public void testUnmarshalEvent() throws Exception {
        Event event = (Event)JaxbUtils.unmarshal(Event.class, (String)m_xmlWithNamespace);
        LogUtils.debugf((Object)this, (String)"event = %s", (Object[])new Object[]{event});
        Assert.assertEquals((Object)"1234", (Object)event.getUuid());
        Assert.assertEquals((Object)"192.168.0.1", (Object)event.getInterface());
    }

    @Test
    public void testMarshalLog() throws Exception {
        Event e1 = this.getEvent();
        Event e2 = this.getEvent();
        e2.setDescr("test 2");
        Events events = new Events();
        events.addEvent(e1);
        events.addEvent(e2);
        Log log = new Log();
        log.setEvents(events);
        String xml = JaxbUtils.marshal((Object)log);
        LogUtils.debugf((Object)this, (String)"xml = %s", (Object[])new Object[]{xml});
        Assert.assertNotNull((Object)xml);
        Assert.assertTrue((boolean)xml.contains("JaxbUtilsTest"));
    }

    @Test
    public void testUnmarshalLog() throws Exception {
        Log log = (Log)JaxbUtils.unmarshal(Log.class, (String)m_logXml);
        Assert.assertNotNull((Object)log.getEvents());
        Assert.assertEquals((long)2L, (long)log.getEvents().getEventCount());
        Assert.assertEquals((Object)"JaxbUtilsTest", (Object)log.getEvents().getEvent(0).getSource());
        ByteArrayInputStream is = new ByteArrayInputStream(m_logXml.getBytes());
        Log log2 = (Log)CastorUtils.unmarshal(Log.class, (InputStream)is);
        ((InputStream)is).close();
        Assert.assertNotNull((Object)log2.getEvents());
        Assert.assertEquals((long)2L, (long)log2.getEvents().getEventCount());
        Assert.assertEquals((Object)"JaxbUtilsTest", (Object)log2.getEvents().getEvent(0).getSource());
        Assert.assertNotNull((Object)log2.getEvents().getEvent(0).getTime());
        LogUtils.debugf((Object)this, (String)"castor log = %s", (Object[])new Object[]{log2});
    }

    @Test
    @Ignore
    public void testUnmarshalLogCastorVersusJaxb() throws Exception {
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            JaxbUtils.unmarshal(Log.class, (String)m_logXml);
        }
        long jaxbTime = System.currentTimeMillis() - startTime;
        byte[] logBytes = m_logXml.getBytes();
        startTime = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            CastorUtils.unmarshal(Log.class, (InputStream)new ByteArrayInputStream(logBytes));
        }
        long castorTime = System.currentTimeMillis() - startTime;
        System.out.printf("JAXB unmarshal: %dms, Castor unmarshal: %dms\n", jaxbTime, castorTime);
    }

    @Test
    @Ignore
    public void testMarshalLogCastorVersusJaxb() throws Exception {
        Log log = (Log)JaxbUtils.unmarshal(Log.class, (String)m_logXml);
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            JaxbUtils.marshal((Object)log);
        }
        long jaxbTime = System.currentTimeMillis() - startTime;
        log = (Log)CastorUtils.unmarshal(Log.class, (InputStream)new ByteArrayInputStream(m_logXml.getBytes()));
        startTime = System.currentTimeMillis();
        for (int i = 0; i < 10000; ++i) {
            CastorUtils.marshalWithTranslatedExceptions((Object)log, (Writer)new StringWriter());
        }
        long castorTime = System.currentTimeMillis() - startTime;
        System.out.printf("JAXB marshal: %dms, Castor marshal: %dms\n", jaxbTime, castorTime);
    }

    @Test
    public void testUnmarshalLogNoNamespace() throws Exception {
        Log log = (Log)JaxbUtils.unmarshal(Log.class, (String)m_logXmlWithoutNamespace);
        Assert.assertNotNull((Object)log.getEvents());
        Assert.assertEquals((long)2L, (long)log.getEvents().getEventCount());
        Assert.assertEquals((Object)"JaxbUtilsTest", (Object)log.getEvents().getEvent(0).getSource());
        ByteArrayInputStream is = new ByteArrayInputStream(m_logXmlWithoutNamespace.getBytes());
        Log log2 = (Log)CastorUtils.unmarshal(Log.class, (InputStream)is);
        ((InputStream)is).close();
        Assert.assertNotNull((Object)log2.getEvents());
        Assert.assertEquals((long)2L, (long)log2.getEvents().getEventCount());
        Assert.assertEquals((Object)"JaxbUtilsTest", (Object)log2.getEvents().getEvent(0).getSource());
        Assert.assertNotNull((Object)log2.getEvents().getEvent(0).getTime());
        LogUtils.debugf((Object)this, (String)"castor log = %s", (Object[])new Object[]{log2});
    }

    private Event getEvent() {
        EventBuilder eb = new EventBuilder("uei.opennms.org/test", "JaxbUtilsTest");
        Event e = eb.setDescription("test").addParam("foo", "bar").getEvent();
        return e;
    }

    @Test
    public void testSendEventXml() throws Exception {
        String text = "<log>\n <events>\n  <event >\n   <uei>uei.opennms.org/internal/capsd/addNode</uei>\n   <source>perl_send_event</source>\n   <time>Tuesday, 12 April 2011 18:05:00 o'clock GMT</time>\n   <host></host>\n   <interface>10.0.0.1</interface>\n   <parms>\n    <parm>\n     <parmName><![CDATA[txno]]></parmName>\n     <value type=\"string\" encoding=\"text\"><![CDATA[1]]></value>\n    </parm>\n    <parm>\n     <parmName><![CDATA[nodelabel]]></parmName>\n     <value type=\"string\" encoding=\"text\"><![CDATA[test10]]></value>\n    </parm>\n   </parms>\n  </event>\n </events>\n</log>\n";
        Log log = (Log)JaxbUtils.unmarshal(Log.class, (String)"<log>\n <events>\n  <event >\n   <uei>uei.opennms.org/internal/capsd/addNode</uei>\n   <source>perl_send_event</source>\n   <time>Tuesday, 12 April 2011 18:05:00 o'clock GMT</time>\n   <host></host>\n   <interface>10.0.0.1</interface>\n   <parms>\n    <parm>\n     <parmName><![CDATA[txno]]></parmName>\n     <value type=\"string\" encoding=\"text\"><![CDATA[1]]></value>\n    </parm>\n    <parm>\n     <parmName><![CDATA[nodelabel]]></parmName>\n     <value type=\"string\" encoding=\"text\"><![CDATA[test10]]></value>\n    </parm>\n   </parms>\n  </event>\n </events>\n</log>\n");
        Assert.assertNotNull((Object)log);
        Assert.assertNotNull((Object)log.getEvents());
        Assert.assertEquals((long)1L, (long)log.getEvents().getEvent().length);
    }

    @Test
    @Ignore
    public void testValidationMemoryLeak() throws Exception {
        String text = "<log>\n <events>\n  <event >\n   <uei>uei.opennms.org/internal/capsd/addNode</uei>\n   <source>perl_send_event</source>\n   <time>Tuesday, 12 April 2011 18:05:00 o'clock GMT</time>\n   <host></host>\n   <interface>10.0.0.1</interface>\n   <parms>\n    <parm>\n     <parmName><![CDATA[txno]]></parmName>\n     <value type=\"string\" encoding=\"text\"><![CDATA[1]]></value>\n    </parm>\n    <parm>\n     <parmName><![CDATA[nodelabel]]></parmName>\n     <value type=\"string\" encoding=\"text\"><![CDATA[test10]]></value>\n    </parm>\n   </parms>\n  </event>\n </events>\n</log>\n";
        int eventCount = 1000000;
        int logEvery = 1000;
        MockLogAppender.setupLogging((boolean)true, (String)"INFO");
        LogUtils.infof((Object)this, (String)"starting", (Object[])new Object[0]);
        Thread.sleep(30000L);
        for (int i = 0; i < 1000000; ++i) {
            if (i % 1000 == 0) {
                LogUtils.infof((Object)this, (String)"- event #%d", (Object[])new Object[]{i});
            }
            Log log = (Log)JaxbUtils.unmarshal(Log.class, (String)"<log>\n <events>\n  <event >\n   <uei>uei.opennms.org/internal/capsd/addNode</uei>\n   <source>perl_send_event</source>\n   <time>Tuesday, 12 April 2011 18:05:00 o'clock GMT</time>\n   <host></host>\n   <interface>10.0.0.1</interface>\n   <parms>\n    <parm>\n     <parmName><![CDATA[txno]]></parmName>\n     <value type=\"string\" encoding=\"text\"><![CDATA[1]]></value>\n    </parm>\n    <parm>\n     <parmName><![CDATA[nodelabel]]></parmName>\n     <value type=\"string\" encoding=\"text\"><![CDATA[test10]]></value>\n    </parm>\n   </parms>\n  </event>\n </events>\n</log>\n");
            Assert.assertNotNull((Object)log);
            Assert.assertNotNull((Object)log.getEvents());
            String results = JaxbUtils.marshal((Object)log);
            Assert.assertNotNull((Object)results);
            Assert.assertTrue((boolean)results.contains("uei.opennms.org/internal/capsd/addNode"));
        }
        LogUtils.infof((Object)this, (String)"finished", (Object[])new Object[0]);
        Thread.sleep(30000L);
    }
}

