/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.BeanUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.OnmsMapDao;
import org.opennms.netmgt.model.OnmsMap;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(dirtiesContext=false)
public class OnmsMapDaoHibernateTest
implements InitializingBean {
    @Autowired
    private OnmsMapDao m_onmsMapDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;
    private static boolean m_populated = false;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeTransaction
    public void setUp() {
        try {
            if (!m_populated) {
                this.m_databasePopulator.populateDatabase();
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        finally {
            m_populated = true;
        }
    }

    @Test
    @Transactional
    public void testSaveOnmsMap() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestMap", "admin");
        this.m_onmsMapDao.save((Object)map);
        this.m_onmsMapDao.flush();
        this.m_onmsMapDao.clear();
        OnmsMap map2 = this.m_onmsMapDao.findMapById(map.getId());
        Assert.assertNotSame((Object)map, (Object)map2);
        Assert.assertEquals((Object)map.getName(), (Object)map2.getName());
        Assert.assertEquals((Object)map.getOwner(), (Object)map2.getOwner());
        Assert.assertEquals((Object)map.getType(), (Object)"U");
        Assert.assertEquals((Object)map.getUserLastModifies(), (Object)map2.getUserLastModifies());
        Assert.assertEquals((Object)map.getLastModifiedTime(), (Object)map2.getLastModifiedTime());
        Assert.assertEquals((Object)map.getCreateTime(), (Object)map2.getCreateTime());
    }

    @Test
    @Transactional
    public void testSaveOnmsMap2() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestMap2", "admin", 969, 726);
        this.m_onmsMapDao.save((Object)map);
        this.m_onmsMapDao.flush();
        this.m_onmsMapDao.clear();
        OnmsMap map2 = this.m_onmsMapDao.findMapById(map.getId());
        Assert.assertNotSame((Object)map, (Object)map2);
        Assert.assertEquals((Object)map.getName(), (Object)map2.getName());
        Assert.assertEquals((Object)map.getOwner(), (Object)map2.getOwner());
        Assert.assertEquals((Object)map.getType(), (Object)"U");
        Assert.assertEquals((Object)map.getAccessMode().trim(), (Object)map2.getAccessMode().trim());
        Assert.assertEquals((Object)map.getUserLastModifies(), (Object)map2.getUserLastModifies());
        Assert.assertEquals((Object)map.getLastModifiedTime(), (Object)map2.getLastModifiedTime());
        Assert.assertEquals((Object)map.getCreateTime(), (Object)map2.getCreateTime());
        Assert.assertEquals((long)map.getWidth(), (long)map2.getWidth());
        Assert.assertEquals((long)map.getHeight(), (long)map2.getHeight());
    }

    @Test
    @Transactional
    public void testSaveOnmsMap3() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestMap3", "admin", "RWRO", 969, 726);
        this.m_onmsMapDao.save((Object)map);
        this.m_onmsMapDao.flush();
        this.m_onmsMapDao.clear();
        OnmsMap map2 = this.m_onmsMapDao.findMapById(map.getId());
        Assert.assertNotSame((Object)map, (Object)map2);
        Assert.assertEquals((Object)map.getName(), (Object)map2.getName());
        Assert.assertEquals((Object)map.getOwner(), (Object)map2.getOwner().trim());
        Assert.assertEquals((Object)map.getType(), (Object)"U");
        Assert.assertEquals((Object)map.getAccessMode(), (Object)map2.getAccessMode().trim());
        Assert.assertEquals((Object)map.getUserLastModifies(), (Object)map2.getUserLastModifies());
        Assert.assertEquals((Object)map.getLastModifiedTime(), (Object)map2.getLastModifiedTime());
        Assert.assertEquals((Object)map.getCreateTime(), (Object)map2.getCreateTime());
        Assert.assertEquals((long)map.getWidth(), (long)map2.getWidth());
        Assert.assertEquals((long)map.getHeight(), (long)map2.getHeight());
    }

    @Test
    @Transactional
    public void testSaveOnmsMap4() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestMap4", "users", "11aabb", "admin", "RWRO", "U", 800, 600);
        this.m_onmsMapDao.save((Object)map);
        this.m_onmsMapDao.flush();
        this.m_onmsMapDao.clear();
        OnmsMap map2 = this.m_onmsMapDao.findMapById(map.getId());
        Assert.assertNotSame((Object)map, (Object)map2);
        Assert.assertEquals((Object)map.getName(), (Object)map2.getName());
        Assert.assertEquals((Object)map.getOwner(), (Object)map2.getOwner());
        Assert.assertEquals((Object)map.getType(), (Object)"U");
        Assert.assertEquals((Object)map.getAccessMode(), (Object)map2.getAccessMode().trim());
        Assert.assertEquals((Object)map.getUserLastModifies(), (Object)map2.getUserLastModifies());
        Assert.assertEquals((Object)map.getLastModifiedTime(), (Object)map2.getLastModifiedTime());
        Assert.assertEquals((Object)map.getCreateTime(), (Object)map2.getCreateTime());
        Assert.assertEquals((long)map.getWidth(), (long)map2.getWidth());
        Assert.assertEquals((long)map.getHeight(), (long)map2.getHeight());
    }

    @Test
    @Transactional
    public void testSaveOnmsMap5() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestMap5", "users", "11aabb", "admin", "RWRO", "A", 800, 600);
        this.m_onmsMapDao.save((Object)map);
        this.m_onmsMapDao.flush();
        this.m_onmsMapDao.clear();
        OnmsMap map2 = this.m_onmsMapDao.findMapById(map.getId());
        Assert.assertNotSame((Object)map, (Object)map2);
        Assert.assertEquals((Object)map.getName(), (Object)map2.getName());
        Assert.assertEquals((Object)map.getOwner(), (Object)map2.getOwner());
        Assert.assertEquals((Object)map.getType(), (Object)"A");
        Assert.assertEquals((Object)map.getAccessMode(), (Object)map2.getAccessMode().trim());
        Assert.assertEquals((Object)map.getUserLastModifies(), (Object)map2.getUserLastModifies());
        Assert.assertEquals((Object)map.getLastModifiedTime(), (Object)map2.getLastModifiedTime());
        Assert.assertEquals((Object)map.getCreateTime(), (Object)map2.getCreateTime());
        Assert.assertEquals((long)map.getWidth(), (long)map2.getWidth());
        Assert.assertEquals((long)map.getHeight(), (long)map2.getHeight());
    }

    @Test
    @Transactional
    public void testSaveOnmsMap6() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestMap6", "users", "11aabb", "admin", "RWRO", "A", 800, 600);
        this.m_onmsMapDao.save((Object)map);
        this.m_onmsMapDao.flush();
        this.m_onmsMapDao.clear();
        OnmsMap map2 = this.m_onmsMapDao.findMapById(map.getId());
        map2.setType("S");
        this.m_onmsMapDao.save((Object)map2);
        this.m_onmsMapDao.flush();
        this.m_onmsMapDao.clear();
        OnmsMap map3 = this.m_onmsMapDao.findMapById(map.getId());
        Assert.assertNotSame((Object)map2, (Object)map3);
        Assert.assertEquals((Object)map2.getName(), (Object)map3.getName());
        Assert.assertEquals((Object)map2.getOwner(), (Object)map3.getOwner());
        Assert.assertEquals((Object)map2.getType(), (Object)"S");
        Assert.assertEquals((Object)map2.getAccessMode(), (Object)map3.getAccessMode().trim());
        Assert.assertEquals((Object)map2.getUserLastModifies(), (Object)map3.getUserLastModifies());
        Assert.assertEquals((Object)map2.getLastModifiedTime(), (Object)map3.getLastModifiedTime());
        Assert.assertEquals((Object)map2.getCreateTime(), (Object)map3.getCreateTime());
        Assert.assertEquals((long)map2.getWidth(), (long)map3.getWidth());
        Assert.assertEquals((long)map2.getHeight(), (long)map3.getHeight());
    }

    @Test
    @Transactional
    public void testFindById() {
        int id = 62;
        OnmsMap map = this.m_onmsMapDao.findMapById(id);
        if (map == null) {
            List maps = this.m_onmsMapDao.findAll();
            StringBuffer ids = new StringBuffer();
            for (OnmsMap current : maps) {
                if (ids.length() > 0) {
                    ids.append(", ");
                }
                ids.append(current.getId());
            }
            Assert.fail((String)("No OnmsMap record with ID " + id + " was found, the only IDs are: " + ids.toString()));
        }
        Assert.assertNotNull((Object)map);
        Assert.assertEquals((Object)"DB_Pop_Test_Map", (Object)map.getName());
        Assert.assertEquals((Object)"fake_background.jpg", (Object)map.getBackground());
        Assert.assertEquals((Object)"RW", (Object)map.getAccessMode());
        Assert.assertEquals((Object)"U", (Object)map.getType());
    }

    @Test
    @Transactional
    public void testFindMapsByName() {
        Collection maps = this.m_onmsMapDao.findMapsByName("DB_Pop_Test_Map");
        Assert.assertEquals((long)1L, (long)maps.size());
        OnmsMap map = (OnmsMap)maps.iterator().next();
        Assert.assertEquals((Object)"DB_Pop_Test_Map", (Object)map.getName());
        Assert.assertEquals((Object)"fake_background.jpg", (Object)map.getBackground());
        Assert.assertEquals((Object)"RW", (Object)map.getAccessMode());
        Assert.assertEquals((Object)"U", (Object)map.getType());
    }

    @Test
    @Transactional
    public void testFindMapsByNameAndTypeOk() {
        Collection maps = this.m_onmsMapDao.findMapsByNameAndType("DB_Pop_Test_Map", "U");
        Assert.assertEquals((long)1L, (long)maps.size());
        OnmsMap map = (OnmsMap)maps.iterator().next();
        Assert.assertEquals((Object)"DB_Pop_Test_Map", (Object)map.getName());
        Assert.assertEquals((Object)"fake_background.jpg", (Object)map.getBackground());
        Assert.assertEquals((Object)"RW", (Object)map.getAccessMode());
        Assert.assertEquals((Object)"U", (Object)map.getType());
    }

    @Test
    @Transactional
    public void testFindMapsByNameAndTypeKo() {
        Collection maps = this.m_onmsMapDao.findMapsByNameAndType("DB_Pop_Test_Map", "A");
        Assert.assertEquals((long)0L, (long)maps.size());
    }

    @Test
    @Transactional
    public void testFindMapsLike() {
        Collection maps = this.m_onmsMapDao.findMapsLike("Pop_Test");
        Assert.assertEquals((long)1L, (long)maps.size());
        OnmsMap map = (OnmsMap)maps.iterator().next();
        Assert.assertEquals((Object)"DB_Pop_Test_Map", (Object)map.getName());
        Assert.assertEquals((Object)"fake_background.jpg", (Object)map.getBackground());
        Assert.assertEquals((Object)"RW", (Object)map.getAccessMode());
        Assert.assertEquals((Object)"U", (Object)map.getType());
    }

    @Test
    @Transactional
    public void testFindMapsByType() {
        Collection maps = this.m_onmsMapDao.findMapsByType("X");
        Assert.assertEquals((long)0L, (long)maps.size());
    }

    @Test
    @Transactional
    public void testFindAutoMaps() {
        Collection maps = this.m_onmsMapDao.findAutoMaps();
        Assert.assertEquals((long)0L, (long)maps.size());
    }

    @Test
    @Transactional
    public void testFindSaveMaps() {
        Collection maps = this.m_onmsMapDao.findSaveMaps();
        Assert.assertEquals((long)0L, (long)maps.size());
    }

    @Test
    @Transactional
    public void testFindUserMaps() {
        Collection maps = this.m_onmsMapDao.findUserMaps();
        Assert.assertEquals((long)1L, (long)maps.size());
    }

    @Test
    @Transactional
    public void testDeleteOnmsMap() {
        int id = 62;
        OnmsMap map = this.m_onmsMapDao.findMapById(id);
        if (map == null) {
            List maps = this.m_onmsMapDao.findAll();
            StringBuffer ids = new StringBuffer();
            for (OnmsMap current : maps) {
                if (ids.length() > 0) {
                    ids.append(", ");
                }
                ids.append(current.getId());
            }
            Assert.fail((String)("No OnmsMap record with ID " + id + " was found, the only IDs are: " + ids.toString()));
        }
        Assert.assertNotNull((Object)map);
        this.m_onmsMapDao.delete((Object)map);
        Assert.assertNull((Object)this.m_onmsMapDao.findMapById(61));
    }

    @Test
    @Transactional
    public void testFindMapByOwner() {
        Collection maps = this.m_onmsMapDao.findMapsByOwner("admin");
        Assert.assertEquals((long)1L, (long)maps.size());
        OnmsMap map = (OnmsMap)maps.iterator().next();
        Assert.assertEquals((Object)"DB_Pop_Test_Map", (Object)map.getName());
        Assert.assertEquals((Object)"fake_background.jpg", (Object)map.getBackground());
        Assert.assertEquals((Object)"RW", (Object)map.getAccessMode());
        Assert.assertEquals((Object)"U", (Object)map.getType());
    }

    @Test
    @Transactional
    public void testFindMapbyGroup() {
        Collection maps = this.m_onmsMapDao.findMapsByGroup("admin");
        Assert.assertEquals((long)1L, (long)maps.size());
        OnmsMap map = (OnmsMap)maps.iterator().next();
        Assert.assertEquals((Object)"DB_Pop_Test_Map", (Object)map.getName());
        Assert.assertEquals((Object)"fake_background.jpg", (Object)map.getBackground());
        Assert.assertEquals((Object)"RW", (Object)map.getAccessMode());
        Assert.assertEquals((Object)"U", (Object)map.getType());
    }

    @Test
    @Transactional
    public void testFindMapbyGroup1() {
        Collection maps = this.m_onmsMapDao.findMapsByGroup("");
        Assert.assertEquals((long)0L, (long)maps.size());
    }

    @Test
    @Transactional
    public void testFindVisibleMapByGroup() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestVisibleMap", "admin", "RWRO", 969, 726);
        map.setMapGroup("testGroup");
        this.m_onmsMapDao.save((Object)map);
        this.m_onmsMapDao.flush();
        this.m_onmsMapDao.clear();
        Collection maps = this.m_onmsMapDao.findVisibleMapsByGroup("testGroup");
        Assert.assertEquals((long)2L, (long)maps.size());
    }

    @Test
    @Transactional
    public void testFindVisibleMapByGroup2() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestVisibleMap", "admin", "RWRO", 969, 726);
        map.setMapGroup("testGroup");
        this.m_onmsMapDao.save((Object)map);
        this.m_onmsMapDao.flush();
        this.m_onmsMapDao.clear();
        Collection maps = this.m_onmsMapDao.findVisibleMapsByGroup("wrongGroup");
        Assert.assertEquals((long)1L, (long)maps.size());
    }
}

