/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.List;
import org.hibernate.criterion.Restrictions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.test.MockLogAppender;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.BeanUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class HibernateCriteriaConverterTest
implements InitializingBean {
    @Autowired
    DatabasePopulator m_populator;
    @Autowired
    NodeDao m_nodeDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        MockLogAppender.setupLogging((boolean)true);
        this.m_populator.populateDatabase();
    }

    @Test
    @JUnitTemporaryDatabase
    public void testNodeQuery() throws Exception {
        OnmsCriteria crit = new OnmsCriteria(OnmsNode.class);
        crit.add(Restrictions.isNotNull((String)"id"));
        List nodes = this.m_nodeDao.findMatching(crit);
        Assert.assertEquals((long)6L, (long)nodes.size());
        CriteriaBuilder cb = new CriteriaBuilder(OnmsNode.class);
        cb.isNotNull("id");
        nodes = this.m_nodeDao.findMatching(cb.toCriteria());
        Assert.assertEquals((long)6L, (long)nodes.size());
        cb.eq("label", (Object)"node1").join("ipInterfaces", "ipInterface").eq("ipInterface.ipAddress", (Object)"192.168.1.1");
        nodes = this.m_nodeDao.findMatching(cb.toCriteria());
        Assert.assertEquals((long)1L, (long)nodes.size());
    }

    @Test
    @JUnitTemporaryDatabase
    public void testNodeIlikeQuery() {
        CriteriaBuilder cb = new CriteriaBuilder(OnmsNode.class);
        cb.isNotNull("id").eq("label", (Object)"node1").alias("ipInterfaces", "ipInterface", Alias.JoinType.LEFT_JOIN).ilike("ipInterface.ipAddress", (Object)"1%");
        List nodes = this.m_nodeDao.findMatching(cb.toCriteria());
        Assert.assertEquals((long)3L, (long)nodes.size());
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testDistinctQuery() {
        List nodes = null;
        CriteriaBuilder cb = new CriteriaBuilder(OnmsNode.class);
        cb.isNotNull("id").distinct();
        cb.eq("label", (Object)"node1").join("ipInterfaces", "ipInterface", Alias.JoinType.LEFT_JOIN).eq("ipInterface.ipAddress", (Object)"192.168.1.1");
        nodes = this.m_nodeDao.findMatching(cb.toCriteria());
        Assert.assertEquals((long)1L, (long)nodes.size());
        Assert.assertEquals((Object)1, (Object)((OnmsNode)nodes.get(0)).getId());
    }
}

