/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.castor;

import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.opennms.netmgt.config.reporting.DateParm;
import org.opennms.netmgt.config.reporting.IntParm;
import org.opennms.netmgt.dao.castor.DefaultOnmsReportConfigDao;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class DefaultOnmsReportDaoTest {
    private static final String ID = "defaultCalendarReport";
    private static final String ALTERNATE_ID = "defaultClassicReport";
    private static final String TYPE = "calendar";
    private static final String SVG_TEMPLATE = "SVGAvailReport.xsl";
    private static final String PDF_TEMPLATE = "PDFAvailReport.xsl";
    private static final String HTML_TEMPLATE = "HTMLAvailReport.xsl";
    private static final String LOGO = "logo.gif";
    private static final String DATE_DISPLAY_NAME = "end date";
    private static final String DATE_NAME = "endDate";
    private static final String STRING_NAME = "offenderCount";
    private static final String STRING_DISPLAY_NAME = "top offender count";
    private static DefaultOnmsReportConfigDao m_dao;

    @BeforeClass
    public static void setUp() throws Exception {
        ClassPathResource resource = new ClassPathResource("/opennms-reports-testdata.xml");
        m_dao = new DefaultOnmsReportConfigDao();
        m_dao.setConfigResource((Resource)resource);
        m_dao.afterPropertiesSet();
    }

    @Test
    public void testGetRenderParms() throws Exception {
        Assert.assertEquals((Object)m_dao.getType(ID), (Object)TYPE);
        Assert.assertEquals((Object)m_dao.getSvgStylesheetLocation(ID), (Object)SVG_TEMPLATE);
        Assert.assertEquals((Object)m_dao.getPdfStylesheetLocation(ID), (Object)PDF_TEMPLATE);
        Assert.assertEquals((Object)m_dao.getHtmlStylesheetLocation(ID), (Object)HTML_TEMPLATE);
        Assert.assertEquals((Object)m_dao.getLogo(ID), (Object)LOGO);
        Assert.assertNull((Object)m_dao.getSvgStylesheetLocation(ALTERNATE_ID));
    }

    @Test
    public void testGetReportParms() throws Exception {
        DateParm[] dates = m_dao.getDateParms(ID);
        Assert.assertEquals((long)1L, (long)dates.length);
        Assert.assertEquals((Object)DATE_NAME, (Object)dates[0].getName());
        Assert.assertEquals((Object)DATE_DISPLAY_NAME, (Object)dates[0].getDisplayName());
        Assert.assertEquals((Object)false, (Object)dates[0].getUseAbsoluteDate());
        Assert.assertEquals((long)1L, (long)dates[0].getDefaultCount());
        Assert.assertEquals((Object)"day", (Object)dates[0].getDefaultInterval());
        Assert.assertEquals((long)23L, (long)dates[0].getDefaultTime().getHours());
        Assert.assertEquals((long)59L, (long)dates[0].getDefaultTime().getMinutes());
        IntParm[] integers = m_dao.getIntParms(ID);
        Assert.assertEquals((long)1L, (long)integers.length);
        Assert.assertEquals((Object)STRING_NAME, (Object)integers[0].getName());
        Assert.assertEquals((Object)STRING_DISPLAY_NAME, (Object)integers[0].getDisplayName());
        Assert.assertEquals((long)20L, (long)integers[0].getDefault());
    }
}

