/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.BeanUtils;
import org.opennms.netmgt.dao.ServiceTypeDao;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(reuseDatabase=false)
public class ServiceTypeDaoTest
implements InitializingBean {
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Test
    @Transactional
    public void testLazyLoad() {
        OnmsServiceType t = new OnmsServiceType("ICMP");
        this.m_serviceTypeDao.save((Object)t);
        OnmsServiceType type = (OnmsServiceType)this.m_serviceTypeDao.get((Serializable)Integer.valueOf(1));
        Assert.assertEquals((Object)"ICMP", (Object)type.getName());
    }

    @Test
    @Transactional
    public void testSave() {
        String name = "ICMP";
        this.tweakSvcType(name);
        this.tweakSvcType(name);
        this.tweakSvcType(name);
        this.tweakSvcType(name);
    }

    private void tweakSvcType(String name) {
        OnmsServiceType svcType = this.m_serviceTypeDao.findByName(name);
        if (svcType == null) {
            this.m_serviceTypeDao.save((Object)new OnmsServiceType(name));
        } else {
            svcType.setName(svcType.getName() + '-' + svcType.getId());
            this.m_serviceTypeDao.update((Object)svcType);
        }
        this.m_serviceTypeDao.clear();
    }
}

