/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.test.db.annotations.JUnitTemporaryDatabase;
import org.opennms.core.utils.BeanUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.MonitoredServiceDao;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.test.JUnitConfigurationEnvironment;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class MonitoredServiceDaoTest
implements InitializingBean {
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;

    public void afterPropertiesSet() throws Exception {
        BeanUtils.assertAutowiring((Object)this);
    }

    @Before
    public void setUp() {
        this.m_databasePopulator.populateDatabase();
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testLazy() {
        List allSvcs = this.m_monitoredServiceDao.findAll();
        Assert.assertTrue((allSvcs.size() > 1 ? 1 : 0) != 0);
        OnmsMonitoredService svc = (OnmsMonitoredService)allSvcs.iterator().next();
        Assert.assertEquals((Object)InetAddressUtils.addr((String)"192.168.1.1"), (Object)svc.getIpAddress());
        Assert.assertEquals((long)1L, (long)svc.getIfIndex().intValue());
        Assert.assertEquals((long)1L, (long)svc.getIpInterface().getNode().getId().intValue());
        Assert.assertEquals((Object)"M", (Object)svc.getIpInterface().getIsManaged());
    }

    @Test
    @Transactional
    @JUnitTemporaryDatabase
    public void testGetByCompositeId() {
        OnmsMonitoredService monSvc = this.m_monitoredServiceDao.get(this.m_databasePopulator.getNode1().getId(), InetAddressUtils.addr((String)"192.168.1.1"), "SNMP");
        Assert.assertNotNull((Object)monSvc);
        OnmsMonitoredService monSvc2 = this.m_monitoredServiceDao.get(this.m_databasePopulator.getNode1().getId(), InetAddressUtils.addr((String)"192.168.1.1"), monSvc.getIfIndex(), monSvc.getServiceId());
        Assert.assertNotNull((Object)monSvc2);
    }
}

