/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.opennms.core.utils.LazyList;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;

public class NodeSourceResourceType
implements OnmsResourceType {
    private static final Set<OnmsAttribute> s_emptyAttributeSet = Collections.unmodifiableSet(new HashSet());
    private ResourceDao m_resourceDao;
    private NodeDao m_nodeDao;

    public NodeSourceResourceType(ResourceDao resourceDao, NodeDao nodeDao) {
        this.m_resourceDao = resourceDao;
        this.m_nodeDao = nodeDao;
    }

    public String getLabel() {
        return "Foreign Source";
    }

    public String getName() {
        return "nodeSource";
    }

    public List<OnmsResource> getResourcesForNodeSource(String nodeSource, int nodeId) {
        return null;
    }

    public List<OnmsResource> getResourcesForNode(int nodeId) {
        return null;
    }

    public List<OnmsResource> getResourcesForDomain(String domain) {
        return null;
    }

    public boolean isResourceTypeOnNodeSource(String nodeSource, int nodeId) {
        return false;
    }

    public boolean isResourceTypeOnNode(int nodeId) {
        return false;
    }

    public boolean isResourceTypeOnDomain(String domain) {
        return false;
    }

    public String getLinkForResource(OnmsResource resource) {
        String[] ident = resource.getName().split(":");
        int nodeId = this.m_nodeDao.findByForeignId(ident[0], ident[1]).getId();
        return "element/node.jsp?node=" + nodeId;
    }

    public OnmsResource createChildResource(String nodeSource) {
        String[] ident = nodeSource.split(":");
        String label = ident[0] + ":" + this.m_nodeDao.findByForeignId(ident[0], ident[1]).getLabel();
        NodeSourceChildResourceLoader loader = new NodeSourceChildResourceLoader(nodeSource);
        OnmsResource resource = new OnmsResource(nodeSource, label, (OnmsResourceType)this, s_emptyAttributeSet, (List)new LazyList((LazyList.Loader)loader));
        loader.setParent(resource);
        return resource;
    }

    private static ThreadCategory log() {
        return ThreadCategory.getInstance(NodeSourceResourceType.class);
    }

    public class NodeSourceChildResourceLoader
    implements LazyList.Loader<OnmsResource> {
        private String m_nodeSource;
        private OnmsResource m_parent;

        private int nodeSourceToNodeId() {
            String[] ident = this.m_nodeSource.split(":");
            return NodeSourceResourceType.this.m_nodeDao.findByForeignId(ident[0], ident[1]).getId();
        }

        public NodeSourceChildResourceLoader(String nodeSource) {
            this.m_nodeSource = nodeSource;
        }

        public void setParent(OnmsResource parent) {
            this.m_parent = parent;
        }

        public List<OnmsResource> load() {
            LinkedList<OnmsResource> children = new LinkedList<OnmsResource>();
            for (OnmsResourceType resourceType : this.getResourceTypesForNodeSource(this.m_nodeSource)) {
                for (OnmsResource resource : resourceType.getResourcesForNodeSource(this.m_nodeSource, this.nodeSourceToNodeId())) {
                    resource.setParent(this.m_parent);
                    children.add(resource);
                    NodeSourceResourceType.log().debug("load: adding resource " + resource.toString());
                }
            }
            return children;
        }

        private Collection<OnmsResourceType> getResourceTypesForNodeSource(String nodeSource) {
            LinkedList<OnmsResourceType> resourceTypes = new LinkedList<OnmsResourceType>();
            for (OnmsResourceType resourceType : NodeSourceResourceType.this.m_resourceDao.getResourceTypes()) {
                if (!resourceType.isResourceTypeOnNodeSource(nodeSource, this.nodeSourceToNodeId())) continue;
                resourceTypes.add(resourceType);
                NodeSourceResourceType.log().debug("getResourceTypesForNodeSource: adding type " + resourceType.getName());
            }
            return resourceTypes;
        }
    }
}

