/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.Timestamp;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.netmgt.dao.IpRouteInterfaceDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsIpRouteInterface;

public class IpRouteInterfaceDaoHibernate
extends AbstractDaoHibernate<OnmsIpRouteInterface, Integer>
implements IpRouteInterfaceDao {
    public IpRouteInterfaceDaoHibernate() {
        super(OnmsIpRouteInterface.class);
    }

    @Override
    public void markDeletedIfNodeDeleted() {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpRouteInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.type", (Object)"D"));
        for (OnmsIpRouteInterface ipRouteIface : this.findMatching(criteria)) {
            ipRouteIface.setStatus(Character.valueOf('D'));
            this.saveOrUpdate(ipRouteIface);
        }
    }

    @Override
    public void deactivateForNodeIdIfOlderThan(int nodeid, Timestamp scanTime) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpRouteInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add((Criterion)Restrictions.eq((String)"status", (Object)"A"));
        for (OnmsIpRouteInterface item : this.findMatching(criteria)) {
            item.setStatus(Character.valueOf('N'));
            this.saveOrUpdate(item);
        }
    }

    @Override
    public void deleteForNodeIdIfOlderThan(int nodeid, Timestamp scanTime) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpRouteInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add(Restrictions.not((Criterion)Restrictions.eq((String)"status", (Object)"A")));
        for (OnmsIpRouteInterface item : this.findMatching(criteria)) {
            this.delete(item);
        }
    }

    @Override
    public void setStatusForNode(Integer nodeid, Character action) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpRouteInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        for (OnmsIpRouteInterface item : this.findMatching(criteria)) {
            item.setStatus(action);
            this.saveOrUpdate(item);
        }
    }

    @Override
    public void setStatusForNodeAndIfIndex(Integer nodeid, Integer ifIndex, Character action) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpRouteInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.eq((String)"routeIfIndex", (Object)ifIndex));
        for (OnmsIpRouteInterface item : this.findMatching(criteria)) {
            item.setStatus(action);
            this.saveOrUpdate(item);
        }
    }

    @Override
    public OnmsIpRouteInterface findByNodeAndDest(Integer id, String routeDest) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsIpRouteInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)id));
        criteria.add((Criterion)Restrictions.eq((String)"routeDest", (Object)routeDest));
        List objects = this.findMatching(criteria);
        if (objects != null && objects.size() > 0) {
            return (OnmsIpRouteInterface)objects.get(0);
        }
        return null;
    }
}

