/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.map.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.opennms.core.utils.BundleLists;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.web.map.MapsException;
import org.opennms.web.map.config.Avail;
import org.opennms.web.map.config.ContextMenu;
import org.opennms.web.map.config.Link;
import org.opennms.web.map.config.LinkStatus;
import org.opennms.web.map.config.Severity;
import org.opennms.web.map.config.Status;

public class MapPropertiesFactory {
    private boolean m_loaded = false;
    protected static final String info = MapPropertiesFactory.class.getName();
    protected static final String name = MapPropertiesFactory.class.getSimpleName();
    protected File mapPropertiesFile;
    protected String mapPropertiesFileString;
    protected ThreadCategory log = null;
    protected Map<String, Status> statusesMap = null;
    protected Status[] orderedStatuses = null;
    protected Map<String, Severity> severitiesMap = null;
    protected Severity[] orderedSeverities = null;
    protected Map<String, Avail> availsMap = null;
    protected Avail[] orderedAvails = null;
    protected Map<String, String> iconsMap = null;
    protected Map<String, String> iconsBySysoidMap = null;
    protected Map<String, String> bgImagesMap = null;
    protected Map<Integer, Link> linksMap = null;
    protected Map<Integer, Set<Link>> linksBySnmpTypeMap = null;
    protected Map<String, LinkStatus> linkStatusesMap = null;
    protected String defaultNodeIcon = null;
    protected String defaultMapIcon = null;
    protected int defaultMapElementDimension = 25;
    protected int maxLinks = 3;
    protected int summaryLink = -1;
    protected String summaryLinkColor = "yellow";
    public static final String MULTILINK_BEST_STATUS = "best";
    public static final String MULTILINK_WORST_STATUS = "worst";
    public static final String MULTILINK_IGNORE_STATUS = "ignore";
    protected String multilinkStatus = "best";
    protected String multilinkIgnoreColor = "yellow";
    protected int defaultLink = -1;
    protected Severity defaultSeverity;
    protected Severity indeterminateSeverity;
    protected Status unknownStatus;
    protected Status defaultStatus;
    protected Avail undefinedAvail;
    protected Avail disabledAvail;
    protected boolean availEnabled = true;
    protected boolean doubleClickEnabled = true;
    protected boolean contextMenuEnabled = true;
    protected boolean useSemaphore = true;
    protected boolean reload = false;
    protected String severityMapAs = "avg";
    protected ContextMenu cmenu;

    public String getMapPropertiesFileString() {
        return this.mapPropertiesFileString;
    }

    public void setMapPropertiesFileString(String mapPropertiesFileString) {
        this.mapPropertiesFileString = mapPropertiesFileString;
    }

    public String getSeverityMapAs() {
        return this.severityMapAs;
    }

    public ContextMenu getContextMenu() {
        return this.cmenu;
    }

    public void setContextMenu(ContextMenu cmenu) {
        this.cmenu = cmenu;
    }

    public boolean isContextMenuEnabled() {
        return this.contextMenuEnabled;
    }

    public boolean isDoubleClickEnabled() {
        return this.doubleClickEnabled;
    }

    public boolean isReload() {
        return this.reload;
    }

    public MapPropertiesFactory(String mapPropertiesFileString) {
        ThreadCategory.setPrefix((String)"OpenNMS.Map");
        this.log = ThreadCategory.getInstance(this.getClass());
        this.mapPropertiesFileString = mapPropertiesFileString;
        if (this.log.isDebugEnabled()) {
            this.log.debug("Map Properties Configuration file: " + mapPropertiesFileString);
        }
        try {
            this.init();
        }
        catch (FileNotFoundException e) {
            this.log.error("Cannot found configuration file", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error("Cannot load configuration file", (Throwable)e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Instantiating MapPropertiesFactory with properties file: " + mapPropertiesFileString);
        }
    }

    public MapPropertiesFactory() {
        ThreadCategory.setPrefix((String)"OpenNMS.Map");
        this.log = ThreadCategory.getInstance(this.getClass());
        try {
            this.init();
        }
        catch (FileNotFoundException e) {
            this.log.error("Cannot found configuration file", (Throwable)e);
        }
        catch (IOException e) {
            this.log.error("Cannot load configuration file", (Throwable)e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Instantiating MapPropertiesFactory");
        }
    }

    public synchronized void init() throws FileNotFoundException, IOException {
        this.log.info("Init");
        if (this.mapPropertiesFileString == null) {
            this.mapPropertiesFile = ConfigFileConstants.getFile((int)ConfigFileConstants.MAP_PROPERTIES_FILE_NAME);
            this.log.info("Using default map properties file: " + this.mapPropertiesFile.getPath());
        } else {
            this.mapPropertiesFile = new File(this.mapPropertiesFileString);
            this.log.info("Using map properties file: " + this.mapPropertiesFile.getPath());
        }
        if (this.m_loaded) {
            return;
        }
        this.parseMapProperties();
        this.m_loaded = true;
    }

    public synchronized void reload(boolean reloadPropertiesFile) throws FileNotFoundException, IOException {
        if (reloadPropertiesFile) {
            this.m_loaded = false;
        }
        this.init();
    }

    public Map<String, Severity> getSeveritiesMap() {
        return Collections.unmodifiableMap(this.severitiesMap);
    }

    public Map<String, Avail> getAvailabilitiesMap() {
        return Collections.unmodifiableMap(this.availsMap);
    }

    public Avail getAvail(double avail) {
        if (avail < 0.0) {
            avail = -1.0;
        }
        Avail rightAv = null;
        int bestfound = -1;
        for (Avail av : this.availsMap.values()) {
            if (!(avail > (double)av.getMin()) || !(avail >= (double)bestfound)) continue;
            rightAv = av;
            bestfound = av.getMin();
        }
        return rightAv;
    }

    public Avail getDisabledAvail() {
        return this.disabledAvail;
    }

    public boolean isAvailEnabled() {
        return this.availEnabled;
    }

    public Status getDefaultStatus() {
        return this.defaultStatus;
    }

    public Status getUnknownStatus() {
        return this.unknownStatus;
    }

    public Severity getDefaultSeverity() {
        return this.defaultSeverity;
    }

    public Severity getIndeterminateSeverity() {
        return this.indeterminateSeverity;
    }

    public Avail getUndefinedAvail() {
        return this.undefinedAvail;
    }

    public Map<String, Status> getStatusesMap() {
        return Collections.unmodifiableMap(this.statusesMap);
    }

    public String getInfo() {
        return info;
    }

    public String getProperty(String key) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        props.load(new FileInputStream(this.mapPropertiesFile));
        return props.getProperty(key);
    }

    protected void parseMapProperties() throws FileNotFoundException, IOException {
        String reloadStr;
        String doubleclick;
        this.log.debug("Parsing map.properties...");
        this.severitiesMap = new HashMap<String, Severity>();
        this.statusesMap = new HashMap<String, Status>();
        this.availsMap = new HashMap<String, Avail>();
        this.iconsMap = new HashMap<String, String>();
        this.iconsBySysoidMap = new HashMap<String, String>();
        this.bgImagesMap = new HashMap<String, String>();
        this.linksMap = new HashMap<Integer, Link>();
        this.linksBySnmpTypeMap = new HashMap<Integer, Set<Link>>();
        this.linkStatusesMap = new HashMap<String, LinkStatus>();
        Properties props = new Properties();
        props.load(new FileInputStream(this.mapPropertiesFile));
        String cntxtmenu = props.getProperty("enable.contextmenu");
        if (cntxtmenu != null && cntxtmenu.equalsIgnoreCase("false")) {
            this.contextMenuEnabled = false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("enable.contextmenu=" + cntxtmenu);
        }
        this.cmenu = new ContextMenu();
        if (this.contextMenuEnabled) {
            String commandList = props.getProperty("cmenu.commands");
            if (commandList != null) {
                String[] commands = BundleLists.parseBundleList((String)commandList);
                if (commands != null) {
                    for (int j = 0; j < commands.length; ++j) {
                        String link = "-";
                        String params = "-";
                        if (!commands[j].equals("-")) {
                            link = props.getProperty("cmenu." + commands[j] + ".link");
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("cmenu." + commands[j] + ".link=" + link);
                            }
                            if (link == null) {
                                this.log.warn("link is null! skipping..");
                                continue;
                            }
                            params = props.getProperty("cmenu." + commands[j] + ".params");
                            if (this.log.isDebugEnabled()) {
                                this.log.debug("cmenu." + commands[j] + ".params=" + params);
                            }
                            if (params == null) {
                                params = "";
                            }
                        }
                        this.cmenu.addEntry(commands[j], link, params);
                    }
                }
            } else {
                this.log.warn("Context Menu enabled but No command found!");
            }
        }
        if ((doubleclick = props.getProperty("enable.doubleclick")) != null && doubleclick.equalsIgnoreCase("false")) {
            this.doubleClickEnabled = false;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("enable.doubleclick=" + doubleclick);
        }
        if ((reloadStr = props.getProperty("enable.reload")) != null && reloadStr.equalsIgnoreCase("true")) {
            this.reload = true;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("enable.reload=" + reloadStr);
        }
        this.severityMapAs = props.getProperty("severity.map", "avg");
        String[] severities = BundleLists.parseBundleList((String)props.getProperty("severities"));
        for (int i = 0; i < severities.length; ++i) {
            String id = props.getProperty("severity." + severities[i] + ".id");
            String label = props.getProperty("severity." + severities[i] + ".label");
            String color = props.getProperty("severity." + severities[i] + ".color");
            String flash = props.getProperty("severity." + severities[i] + ".flash");
            Severity sev = new Severity(Integer.parseInt(id), label, color);
            if (flash != null && flash.equalsIgnoreCase("true")) {
                sev.setFlash(true);
            }
            this.log.debug("found severity " + severities[i] + " with id=" + id + ", label=" + label + ", color=" + color + ". Adding it.");
            this.severitiesMap.put(label, sev);
        }
        this.orderedSeverities = new Severity[this.severitiesMap.size()];
        Iterator<Severity> it_sev = this.severitiesMap.values().iterator();
        int k = 0;
        while (it_sev.hasNext()) {
            this.orderedSeverities[k++] = it_sev.next();
        }
        Arrays.sort(this.orderedSeverities);
        String defaultid = props.getProperty("severity.default");
        if (defaultid == null) {
            throw new IllegalStateException("Required Default Severity not found.");
        }
        String sevid = props.getProperty("severity." + defaultid + ".id");
        String sevlabel = props.getProperty("severity." + defaultid + ".label");
        String sevcolor = props.getProperty("severity." + defaultid + ".color");
        this.defaultSeverity = new Severity(Integer.parseInt(sevid), sevlabel, sevcolor);
        String indeterminateId = props.getProperty("severity.indeterminate");
        if (indeterminateId == null) {
            throw new IllegalStateException("Required Indeterminate Severity not found.");
        }
        String indsevid = props.getProperty("severity." + indeterminateId + ".id");
        String indsevlabel = props.getProperty("severity." + indeterminateId + ".label");
        String indsevcolor = props.getProperty("severity." + indeterminateId + ".color");
        this.indeterminateSeverity = new Severity(Integer.parseInt(indsevid), indsevlabel, indsevcolor);
        String[] links = BundleLists.parseBundleList((String)props.getProperty("links"));
        String defaultLinkStr = props.getProperty("link.default");
        if (defaultLinkStr == null) {
            this.log.error("Mandatory property 'link.default' not found!");
            throw new IllegalStateException("The property 'link.default' is mandatory");
        }
        this.defaultLink = Integer.parseInt(defaultLinkStr);
        for (int i = 0; i < links.length; ++i) {
            String id = props.getProperty("link." + links[i] + ".id");
            String text = props.getProperty("link." + links[i] + ".text");
            String speed = props.getProperty("link." + links[i] + ".speed");
            String width = props.getProperty("link." + links[i] + ".width");
            String dasharray = props.getProperty("link." + links[i] + ".dash-array");
            String snmptype = props.getProperty("link." + links[i] + ".snmptype");
            String multilinkwidth = props.getProperty("link." + links[i] + ".multilink.width");
            String multilinkdasharray = props.getProperty("link." + links[i] + ".multilink.dash-array");
            if (id == null) {
                this.log.error("param id for link cannot be null in map.properties: skipping link...");
                continue;
            }
            if (text == null) {
                this.log.error("param text for link cannot be null in map.properties: skipping link...");
                continue;
            }
            if (width == null) {
                this.log.error("param width for link cannot be null in map.properties: skipping link...");
                continue;
            }
            if (speed == null) {
                this.log.info("param speed for link cannot be null in map.properties: skipping link...");
                speed = "Unknown";
            }
            int dash_arr = -1;
            if (dasharray != null) {
                dash_arr = Integer.parseInt(dasharray);
            }
            int snmp_type = -1;
            if (snmptype != null) {
                snmp_type = Integer.parseInt(snmptype);
            }
            if (multilinkwidth == null) {
                multilinkwidth = width;
            }
            int multilink_dasharray = dash_arr;
            if (multilinkdasharray != null) {
                multilink_dasharray = Integer.parseInt(multilinkdasharray);
            }
            Link lnk = new Link(Integer.parseInt(id), speed, text, width, dash_arr, snmp_type, multilinkwidth, multilink_dasharray);
            this.log.debug("found link " + links[i] + " with id=" + id + ", text=" + text + ", speed=" + speed + ", width=" + width + ", dash-array=" + dasharray + "snmp-type=" + snmp_type + ". Adding it.");
            this.linksMap.put(new Integer(id), lnk);
            Set<Link> linkbysnmptypeSet = this.linksBySnmpTypeMap.get(new Integer(snmp_type));
            if (linkbysnmptypeSet == null) {
                linkbysnmptypeSet = new HashSet<Link>();
            }
            linkbysnmptypeSet.add(lnk);
            this.linksBySnmpTypeMap.put(new Integer(snmp_type), linkbysnmptypeSet);
        }
        String[] linkStatuses = BundleLists.parseBundleList((String)props.getProperty("linkstatuses"));
        for (int i = 0; i < linkStatuses.length; ++i) {
            String color = props.getProperty("linkstatus." + linkStatuses[i] + ".color");
            String flash = props.getProperty("linkstatus." + linkStatuses[i] + ".flash");
            if (color == null) {
                this.log.error("param color for linkstatus cannot be null in map.properties: skipping linkstatus...");
                continue;
            }
            boolean flashBool = false;
            if (flash != null && flash.equalsIgnoreCase("false")) {
                flashBool = false;
            }
            this.log.debug("found linkstatus " + linkStatuses[i] + " with color=" + color + ", flash=" + flashBool + ". Adding it.");
            LinkStatus ls = new LinkStatus(linkStatuses[i], color, flashBool);
            this.linkStatusesMap.put(linkStatuses[i], ls);
        }
        if (props.getProperty("summarylink.id") != null) {
            this.summaryLink = Integer.parseInt(props.getProperty("summarylink.id"));
        }
        this.log.debug("found summarylink.id: " + this.summaryLink);
        if (props.getProperty("summarylink.color") != null) {
            this.summaryLinkColor = props.getProperty("summarylink.color");
        }
        this.log.debug("found summarylink.color: " + this.summaryLinkColor);
        if (props.getProperty("max.links") != null) {
            this.maxLinks = Integer.parseInt(props.getProperty("max.links"));
        }
        this.log.debug("found max.links: " + this.maxLinks);
        if (props.getProperty("multilink.status") != null) {
            this.multilinkStatus = props.getProperty("multilink.status");
        }
        if (!(this.multilinkStatus.equals(MULTILINK_BEST_STATUS) || this.multilinkStatus.equals(MULTILINK_IGNORE_STATUS) || this.multilinkStatus.equals(MULTILINK_WORST_STATUS))) {
            this.log.error("multilink.status property must be 'best' or 'worst' or 'ignore' ... using default ('best')");
            this.multilinkStatus = MULTILINK_BEST_STATUS;
        }
        this.log.debug("found multilink.status:" + this.multilinkStatus);
        if (props.getProperty("multilink.ignore.color") != null) {
            this.multilinkIgnoreColor = props.getProperty("multilink.ignore.color");
        }
        this.log.debug("found multilink.ignore.color:" + this.multilinkIgnoreColor);
        String[] statuses = BundleLists.parseBundleList((String)props.getProperty("statuses"));
        for (int i = 0; i < statuses.length; ++i) {
            String id = props.getProperty("status." + statuses[i] + ".id");
            String uei = props.getProperty("status." + statuses[i] + ".uei");
            String color = props.getProperty("status." + statuses[i] + ".color");
            String text = props.getProperty("status." + statuses[i] + ".text");
            this.log.debug("found status " + statuses[i] + " with id=" + id + ", uei=" + uei + ", color=" + color + ", text=" + text + ". Adding it.");
            Status status = new Status(Integer.parseInt(id), uei, color, text);
            this.statusesMap.put(uei, status);
        }
        this.orderedStatuses = new Status[this.statusesMap.size()];
        Iterator<Status> it_status = this.statusesMap.values().iterator();
        k = 0;
        while (it_status.hasNext()) {
            this.orderedStatuses[k++] = it_status.next();
        }
        Arrays.sort(this.orderedStatuses);
        String unknownid = props.getProperty("status.unknown.uei");
        if (unknownid == null) {
            throw new IllegalStateException("Required Unknown Uei Status not found.");
        }
        String stid = props.getProperty("status." + unknownid + ".id");
        String stuei = props.getProperty("status." + unknownid + ".uei");
        String stcolor = props.getProperty("status." + unknownid + ".color");
        String sttext = props.getProperty("status." + unknownid + ".text");
        this.unknownStatus = new Status(Integer.parseInt(stid), stuei, stcolor, sttext);
        String defaultstid = props.getProperty("status.default");
        if (defaultstid == null) {
            throw new IllegalStateException("Required Default Status not found.");
        }
        String staid = props.getProperty("status." + defaultstid + ".id");
        String stauei = props.getProperty("status." + defaultstid + ".uei");
        String stacolor = props.getProperty("status." + defaultstid + ".color");
        String statext = props.getProperty("status." + defaultstid + ".text");
        this.defaultStatus = new Status(Integer.parseInt(staid), stauei, stacolor, statext);
        String[] availes = BundleLists.parseBundleList((String)props.getProperty("availabilities"));
        for (int i = 0; i < availes.length; ++i) {
            String id = props.getProperty("avail." + availes[i] + ".id");
            String min = props.getProperty("avail." + availes[i] + ".min");
            String color = props.getProperty("avail." + availes[i] + ".color");
            String flash = props.getProperty("avail." + availes[i] + ".flash");
            this.log.debug("found avail " + availes[i] + " with id=" + id + ", min=" + min + ", color=" + color + ". Adding it.");
            Avail avail = new Avail(Integer.parseInt(id), Integer.parseInt(min), color);
            if (flash != null && flash.equalsIgnoreCase("true")) {
                avail.setFlash(true);
            }
            this.availsMap.put(min, avail);
        }
        this.orderedAvails = new Avail[this.availsMap.size()];
        Iterator<Avail> it_avail = this.availsMap.values().iterator();
        k = 0;
        while (it_avail.hasNext()) {
            this.orderedAvails[k++] = it_avail.next();
        }
        Arrays.sort(this.orderedAvails);
        String avid = props.getProperty("avail.undefined.id");
        String avmin = props.getProperty("avail.undefined.min");
        String avcolor = props.getProperty("avail.undefined.color");
        if (avid == null || avmin == null || avcolor == null) {
            throw new IllegalStateException("Required avail.undefined properties not found.");
        }
        this.undefinedAvail = new Avail(Integer.parseInt(avid), Integer.parseInt(avmin), avcolor);
        String enableAvail = props.getProperty("avail.enable");
        this.availEnabled = enableAvail == null || !enableAvail.equalsIgnoreCase("false");
        String disableAvailId = props.getProperty("avail.enable.false.id");
        if (disableAvailId == null) {
            throw new IllegalStateException("Required Default Status not found.");
        }
        for (Avail av : this.availsMap.values()) {
            if (av.getId() != Integer.parseInt(disableAvailId)) continue;
            this.disabledAvail = av;
            break;
        }
        String[] icons = BundleLists.parseBundleList((String)props.getProperty("icons"));
        for (int i = 0; i < icons.length; ++i) {
            String baseProperty = "icon." + icons[i] + ".";
            String filename = props.getProperty(baseProperty + "filename");
            this.log.debug("found icon " + icons[i] + " with filename=" + filename + ". Adding it.");
            this.iconsMap.put(icons[i], filename);
        }
        if (props.getProperty("sysoids") != null && props.getProperty("sysoids") != "") {
            String[] sysoids = BundleLists.parseBundleList((String)props.getProperty("sysoids"));
            for (int i = 0; i < sysoids.length; ++i) {
                String iconName = props.getProperty("sysoid." + sysoids[i] + ".iconName");
                this.log.debug("found sysoid " + sysoids[i] + " with iconName=" + iconName + ". Adding it.");
                this.iconsBySysoidMap.put(sysoids[i], iconName);
            }
        }
        this.defaultMapIcon = props.getProperty("icon.default.map");
        this.log.debug("default map icon: " + this.defaultMapIcon);
        if (this.defaultMapIcon == null) {
            throw new IllegalStateException("Required Default Map Icon not found.");
        }
        this.defaultNodeIcon = props.getProperty("icon.default.node");
        if (this.defaultNodeIcon == null) {
            throw new IllegalStateException("Required Default Icon Node not found.");
        }
        this.log.debug("default node icon: " + this.defaultNodeIcon);
        String defaultMapElementDimensionString = props.getProperty("icon.default.mapelementdimension");
        if (defaultMapElementDimensionString != null) {
            this.defaultMapElementDimension = Integer.parseInt(defaultMapElementDimensionString);
        }
        this.log.debug("default map element dimension: " + this.defaultMapElementDimension);
        String useSemaphoreString = props.getProperty("use.semaphore");
        this.useSemaphore = useSemaphoreString == null || !useSemaphoreString.equalsIgnoreCase("false");
        this.log.debug("use semaphore: " + useSemaphoreString);
        String[] bg = BundleLists.parseBundleList((String)props.getProperty("bgimages"));
        for (int i = 0; i < bg.length; ++i) {
            String filename = props.getProperty("bgimage." + bg[i] + ".filename");
            this.log.debug("found bgimage " + bg[i] + " with filename=" + filename + ". Adding it.");
            this.bgImagesMap.put(bg[i], filename);
        }
    }

    public String getSummaryLinkColor() {
        return this.summaryLinkColor;
    }

    public Map<String, String> getIconsBySysoidMap() {
        return Collections.unmodifiableMap(this.iconsBySysoidMap);
    }

    public Map<String, String> getBackgroundImagesMap() {
        return Collections.unmodifiableMap(this.bgImagesMap);
    }

    public String getDefaultMapIcon() {
        return this.defaultMapIcon;
    }

    public String getDefaultNodeIcon() {
        return this.defaultNodeIcon;
    }

    public Severity[] getOrderedSeverities() {
        return this.orderedSeverities;
    }

    public Avail[] getOrderedAvails() {
        return this.orderedAvails;
    }

    public Status[] getOrderedStatuses() {
        return this.orderedStatuses;
    }

    public int getSeverity(String severityLabel) {
        Severity sev = this.severitiesMap.get(severityLabel);
        if (sev == null) {
            throw new IllegalStateException("Severity with label " + severityLabel + " not found.");
        }
        return sev.getId();
    }

    public int getStatus(String uei) {
        Status status = this.statusesMap.get(uei);
        if (status == null) {
            try {
                return this.getUnknownStatus().getId();
            }
            catch (Throwable e) {
                throw new RuntimeException("Exception while getting unknown status " + e);
            }
        }
        return status.getId();
    }

    public Set<Link> getLinkBySnmpType(int linkTypologyId) {
        return this.linksBySnmpTypeMap.get(new Integer(linkTypologyId));
    }

    public int getLinkTypeId(int snmpiftype, long snmpifspeed) {
        Link link = null;
        Set<Link> linkSet = this.getLinkBySnmpType(snmpiftype);
        if (linkSet == null) {
            link = this.getDefaultLink();
        } else if (linkSet.size() > 1) {
            for (Link next : linkSet) {
                try {
                    if (Long.parseLong(next.getSpeed()) != snmpifspeed) continue;
                    link = next;
                    break;
                }
                catch (NumberFormatException e) {
                }
            }
        } else {
            Iterator<Link> it = linkSet.iterator();
            if (it.hasNext()) {
                link = it.next();
            }
        }
        if (link == null) {
            link = this.getDefaultLink();
        }
        return link.getId();
    }

    public Link getLink(int id) {
        return this.linksMap.get(new Integer(id));
    }

    public LinkStatus getLinkStatus(String linkStatusLabel) {
        return this.linkStatusesMap.get(linkStatusLabel);
    }

    public Link getDefaultLink() {
        return this.linksMap.get(this.defaultLink);
    }

    public Map<Integer, Link> getLinksMap() {
        return this.linksMap;
    }

    public Map<String, LinkStatus> getLinkStatusesMap() {
        return this.linkStatusesMap;
    }

    public String getMultilinkStatus() {
        return this.multilinkStatus;
    }

    public List<Avail> getAvails() throws MapsException {
        ArrayList<Avail> avails = new ArrayList<Avail>();
        avails.addAll(Arrays.asList(this.getOrderedAvails()));
        return avails;
    }

    public List<Link> getLinks() throws MapsException {
        ArrayList<Link> links = new ArrayList<Link>();
        links.addAll(this.getLinksMap().values());
        return links;
    }

    public List<LinkStatus> getLinkStatuses() throws MapsException {
        ArrayList<LinkStatus> linkstatutes = new ArrayList<LinkStatus>();
        linkstatutes.addAll(this.getLinkStatusesMap().values());
        return linkstatutes;
    }

    public List<Status> getStatuses() throws MapsException {
        ArrayList<Status> statutes = new ArrayList<Status>();
        statutes.addAll(this.getStatusesMap().values());
        return statutes;
    }

    public List<Severity> getSeverities() throws MapsException {
        ArrayList<Severity> sevs = new ArrayList<Severity>();
        sevs.addAll(this.getSeveritiesMap().values());
        return sevs;
    }

    public Map<String, String> getIcons() throws MapsException {
        return Collections.unmodifiableMap(this.iconsMap);
    }

    public Map<String, String> getIconsBySysoid() throws MapsException {
        return Collections.unmodifiableMap(this.getIconsBySysoidMap());
    }

    public Map<String, String> getBackgroundImages() throws MapsException {
        return Collections.unmodifiableMap(this.getBackgroundImagesMap());
    }

    public String getDefaultBackgroundColor() {
        return "ffffff";
    }

    public int getDefaultStatusId() {
        return this.getDefaultStatus().getId();
    }

    public int getUnknownStatusId() {
        return this.getUnknownStatus().getId();
    }

    public Map<String, String> getMapElementDimensions() {
        TreeMap<String, String> dims = new TreeMap<String, String>();
        dims.put("06", "smallest");
        dims.put("10", "very small");
        dims.put("15", "small");
        dims.put("20", "normal");
        dims.put("25", "firefox");
        dims.put("30", "bigger");
        dims.put("35", "biggest");
        return dims;
    }

    public int getDefaultMapElementDimension() {
        return this.defaultMapElementDimension;
    }

    public int getMaxLinks() {
        return this.maxLinks;
    }

    public int getSummaryLink() {
        return this.summaryLink;
    }

    public String getMultilinkIgnoreColor() {
        return this.multilinkIgnoreColor;
    }

    public boolean isUseSemaphore() {
        return this.useSemaphore;
    }
}

