/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.Timestamp;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.netmgt.dao.StpNodeDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsStpNode;

public class StpNodeDaoHibernate
extends AbstractDaoHibernate<OnmsStpNode, Integer>
implements StpNodeDao {
    public StpNodeDaoHibernate() {
        super(OnmsStpNode.class);
    }

    @Override
    public void markDeletedIfNodeDeleted() {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpNode.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.type", (Object)"D"));
        for (OnmsStpNode stpNode : this.findMatching(criteria)) {
            stpNode.setStatus(Character.valueOf('D'));
            this.saveOrUpdate(stpNode);
        }
    }

    @Override
    public void deactivateForNodeIdIfOlderThan(int nodeid, Timestamp scanTime) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpNode.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add((Criterion)Restrictions.eq((String)"status", (Object)"A"));
        for (OnmsStpNode item : this.findMatching(criteria)) {
            item.setStatus(Character.valueOf('N'));
            this.saveOrUpdate(item);
        }
    }

    @Override
    public void deleteForNodeIdIfOlderThan(int nodeid, Timestamp scanTime) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpNode.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add(Restrictions.not((Criterion)Restrictions.eq((String)"status", (Object)"A")));
        for (OnmsStpNode item : this.findMatching(criteria)) {
            this.delete(item);
        }
    }

    @Override
    public void setStatusForNode(Integer nodeid, Character action) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpNode.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        for (OnmsStpNode item : this.findMatching(criteria)) {
            item.setStatus(action);
            this.saveOrUpdate(item);
        }
    }

    @Override
    public OnmsStpNode findByNodeAndVlan(Integer nodeId, Integer baseVlan) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpNode.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"baseVlan", (Object)baseVlan));
        List stpNodes = this.findMatching(criteria);
        if (stpNodes != null && stpNodes.size() > 0) {
            return (OnmsStpNode)stpNodes.get(0);
        }
        return null;
    }
}

