/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import org.opennms.netmgt.dao.OnmsDao;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class UpsertTemplate<T, D extends OnmsDao<T, ?>> {
    protected final PlatformTransactionManager m_transactionManager;
    protected final D m_dao;

    public UpsertTemplate(PlatformTransactionManager transactionManager, D dao) {
        this.m_transactionManager = transactionManager;
        this.m_dao = dao;
    }

    public T execute() {
        TransactionTemplate template = new TransactionTemplate(this.m_transactionManager);
        template.setPropagationBehavior(0);
        return (T)template.execute(new TransactionCallback<T>(){

            public T doInTransaction(TransactionStatus status) {
                return UpsertTemplate.this.doUpsert();
            }
        });
    }

    private T doUpsert() {
        T dbObj = this.query();
        if (dbObj != null) {
            return this.update(dbObj);
        }
        this.m_dao.lock();
        dbObj = this.query();
        if (dbObj != null) {
            return this.update(dbObj);
        }
        return this.insert();
    }

    private T update(T dbObj) {
        return this.doUpdate(dbObj);
    }

    private T insert() {
        return this.doInsert();
    }

    protected abstract T query();

    protected abstract T doUpdate(T var1);

    protected abstract T doInsert();
}

