/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.netmgt.dao.DataLinkInterfaceDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.DataLinkInterface;
import org.opennms.netmgt.model.OnmsCriteria;
import org.springframework.orm.hibernate3.HibernateCallback;

public class DataLinkInterfaceDaoHibernate
extends AbstractDaoHibernate<DataLinkInterface, Integer>
implements DataLinkInterfaceDao {
    public DataLinkInterfaceDaoHibernate() {
        super(DataLinkInterface.class);
    }

    @Override
    public Collection<DataLinkInterface> findAll(final Integer offset, final Integer limit) {
        return (Collection)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<Collection<DataLinkInterface>>(){

            public Collection<DataLinkInterface> doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createCriteria(DataLinkInterface.class).setFirstResult(offset.intValue()).setMaxResults(limit.intValue()).list();
            }
        });
    }

    @Override
    public DataLinkInterface findById(Integer id) {
        return (DataLinkInterface)this.findUnique("from DataLinkInterface as dli where dli.id = ?", id);
    }

    @Override
    public Collection<DataLinkInterface> findByNodeId(Integer nodeId) {
        return this.find("from DataLinkInterface as dli where dli.node.id = ?", nodeId);
    }

    @Override
    public Collection<DataLinkInterface> findByNodeParentId(Integer nodeParentId) {
        return this.find("from DataLinkInterface as dli where dli.nodeParentId = ?", nodeParentId);
    }

    @Override
    public DataLinkInterface findByNodeIdAndIfIndex(Integer nodeId, Integer ifIndex) {
        OnmsCriteria criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"ifIndex", (Object)ifIndex));
        List interfaces = this.findMatching(criteria);
        if (interfaces.size() > 0) {
            return (DataLinkInterface)interfaces.get(0);
        }
        return null;
    }

    @Override
    public void markDeletedIfNodeDeleted() {
        OnmsCriteria criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.type", (Object)"D"));
        for (DataLinkInterface dataLinkIface : this.findMatching(criteria)) {
            dataLinkIface.setStatus("D");
            this.saveOrUpdate(dataLinkIface);
        }
    }

    @Override
    public void deactivateIfOlderThan(Timestamp scanTime, String source) {
        OnmsCriteria criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.add((Criterion)Restrictions.eq((String)"source", (Object)source));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add((Criterion)Restrictions.eq((String)"status", (Object)"A"));
        for (DataLinkInterface iface : this.findMatching(criteria)) {
            iface.setStatus("N");
            this.saveOrUpdate(iface);
        }
    }

    @Override
    public void deleteIfOlderThan(Timestamp scanTime, String source) {
        OnmsCriteria criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.add((Criterion)Restrictions.eq((String)"source", (Object)source));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add(Restrictions.not((Criterion)Restrictions.eq((String)"status", (Object)"A")));
        for (DataLinkInterface iface : this.findMatching(criteria)) {
            this.delete(iface);
        }
    }

    @Override
    public void setStatusForNode(Integer nodeid, Character action) {
        OnmsCriteria criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid), (Criterion)Restrictions.eq((String)"nodeParentId", (Object)nodeid)));
        for (DataLinkInterface iface : this.findMatching(criteria)) {
            iface.setStatus(String.valueOf(action));
            this.saveOrUpdate(iface);
        }
    }

    @Override
    public void setStatusForNode(Integer nodeid, String source, Character action) {
        OnmsCriteria criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"source", (Object)source), (Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid), (Criterion)Restrictions.eq((String)"nodeParentId", (Object)nodeid))));
        for (DataLinkInterface iface : this.findMatching(criteria)) {
            iface.setStatus(String.valueOf(action));
            this.saveOrUpdate(iface);
        }
    }

    @Override
    public void setStatusForNodeAndIfIndex(Integer nodeid, Integer ifIndex, Character action) {
        OnmsCriteria criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid), (Criterion)Restrictions.eq((String)"ifIndex", (Object)ifIndex)), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"nodeParentId", (Object)nodeid), (Criterion)Restrictions.eq((String)"parentIfIndex", (Object)ifIndex))));
        for (DataLinkInterface iface : this.findMatching(criteria)) {
            iface.setStatus(String.valueOf(action));
            this.saveOrUpdate(iface);
        }
    }

    @Override
    public void setStatusForNodeAndIfIndex(Integer nodeid, Integer ifIndex, String source, Character action) {
        OnmsCriteria criteria = new OnmsCriteria(DataLinkInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"source", (Object)source), (Criterion)Restrictions.or((Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid), (Criterion)Restrictions.eq((String)"ifIndex", (Object)ifIndex)), (Criterion)Restrictions.and((Criterion)Restrictions.eq((String)"nodeParentId", (Object)nodeid), (Criterion)Restrictions.eq((String)"parentIfIndex", (Object)ifIndex)))));
        for (DataLinkInterface iface : this.findMatching(criteria)) {
            iface.setStatus(String.valueOf(action));
            this.saveOrUpdate(iface);
        }
    }
}

