/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.opennms.core.utils.BundleLists;
import org.opennms.core.utils.ThreadCategory;
import org.opennms.netmgt.dao.GraphDao;
import org.opennms.netmgt.dao.support.FileReloadCallback;
import org.opennms.netmgt.dao.support.FileReloadContainer;
import org.opennms.netmgt.model.AdhocGraphType;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.model.PrefabGraphType;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class PropertiesGraphDao
implements GraphDao,
InitializingBean {
    public static final String DEFAULT_GRAPH_LIST_KEY = "reports";
    private Map<String, Resource> m_prefabConfigs;
    private Map<String, Resource> m_adhocConfigs;
    private Map<String, FileReloadContainer<PrefabGraphTypeDao>> m_types = new HashMap<String, FileReloadContainer<PrefabGraphTypeDao>>();
    private HashMap<String, FileReloadContainer<AdhocGraphType>> m_adhocTypes = new HashMap();
    private PrefabGraphTypeCallback m_prefabCallback = new PrefabGraphTypeCallback();
    private AdhocGraphTypeCallback m_adhocCallback = new AdhocGraphTypeCallback();

    private void initPrefab() throws IOException {
        for (Map.Entry<String, Resource> configEntry : this.m_prefabConfigs.entrySet()) {
            this.loadProperties(configEntry.getKey(), configEntry.getValue());
        }
    }

    private void initAdhoc() throws IOException {
        for (Map.Entry<String, Resource> configEntry : this.m_adhocConfigs.entrySet()) {
            this.loadAdhocProperties(configEntry.getKey(), configEntry.getValue());
        }
    }

    @Override
    public PrefabGraphType findPrefabGraphTypeByName(String name) {
        return this.findPrefabGraphTypeDaoByName(name);
    }

    PrefabGraphTypeDao findPrefabGraphTypeDaoByName(String name) {
        PrefabGraphTypeDao result = this.m_types.get(name).getObject();
        this.rescanIncludeDirectory(result);
        return result;
    }

    @Override
    public AdhocGraphType findAdhocGraphTypeByName(String name) {
        return this.m_adhocTypes.get(name).getObject();
    }

    public void loadProperties(String typeName, Resource resource) throws IOException {
        PrefabGraphTypeDao type = this.createPrefabGraphType(typeName, resource);
        this.m_types.put(type.getName(), new FileReloadContainer<PrefabGraphTypeDao>(type, resource, this.m_prefabCallback));
    }

    public void loadProperties(String type, InputStream in) throws IOException {
        InputStreamResource resource = new InputStreamResource(in);
        PrefabGraphTypeDao t = this.createPrefabGraphType(type, (Resource)resource, false);
        if (t != null) {
            this.m_types.put(t.getName(), new FileReloadContainer<PrefabGraphTypeDao>(t));
        }
    }

    private void rescanIncludeDirectory(PrefabGraphTypeDao type) {
        try {
            this.recheckMalformedIncludedFiles(type);
            if (System.currentTimeMillis() > type.getLastIncludeScan() + (long)type.getIncludeDirectoryRescanTimeout()) {
                this.scanIncludeDirectory(type);
            }
        }
        catch (IOException e) {
            this.log().error("Unable to rescan the include directory '" + type.getIncludeDirectory() + "' of type " + type.getName() + " because:", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIncludedFile(PrefabGraphTypeDao type, File file) throws FileNotFoundException, IOException {
        Properties props = new Properties();
        FileInputStream fileIn = new FileInputStream(file);
        try {
            props.load(fileIn);
        }
        finally {
            IOUtils.closeQuietly((InputStream)fileIn);
        }
        type.removeMalformedFile(file);
        try {
            List<PrefabGraph> subGraphs = this.loadPrefabGraphDefinitions(type, props);
            for (PrefabGraph graph : subGraphs) {
                if (graph == null) {
                    type.addMalformedFile(file);
                    continue;
                }
                type.addPrefabGraph(new FileReloadContainer<PrefabGraph>(graph, (Resource)new FileSystemResource(file), type.getCallback()));
            }
        }
        catch (DataAccessResourceFailureException e) {
            this.log().error("Problem while attempting to load " + file + ":", (Throwable)e);
            type.addMalformedFile(file);
        }
    }

    private void recheckMalformedIncludedFiles(PrefabGraphTypeDao type) throws IOException {
        File[] files;
        Map<File, Long> filesMap = type.getMalformedFiles();
        for (File file : files = filesMap.keySet().toArray(new File[0])) {
            Long lastKnownTimestamp = filesMap.get(file);
            if (file.lastModified() <= lastKnownTimestamp) continue;
            this.loadIncludedFile(type, file);
        }
    }

    private void scanIncludeDirectory(PrefabGraphTypeDao type) throws IOException {
        Resource includeDirectoryResource = type.getIncludeDirectoryResource();
        if (includeDirectoryResource != null) {
            File[] propertyFiles;
            File includeDirectory = includeDirectoryResource.getFile();
            FilenameFilter propertyFilesFilter = new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".properties");
                }
            };
            for (File file : propertyFiles = includeDirectory.listFiles(propertyFilesFilter)) {
                this.loadIncludedFile(type, file);
            }
        }
        type.setLastIncludeScan(System.currentTimeMillis());
    }

    private PrefabGraphTypeDao createPrefabGraphType(String type, Resource sourceResource) {
        return this.createPrefabGraphType(type, sourceResource, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrefabGraphTypeDao createPrefabGraphType(String type, Resource sourceResource, boolean reloadable) {
        InputStream in = null;
        try {
            int interval;
            in = sourceResource.getInputStream();
            Properties properties = new Properties();
            properties.load(in);
            PrefabGraphTypeDao t = new PrefabGraphTypeDao();
            t.setName(type);
            t.setCommandPrefix(this.getProperty(properties, "command.prefix"));
            t.setOutputMimeType(this.getProperty(properties, "output.mime"));
            t.setDefaultReport(properties.getProperty("default.report", "none"));
            String includeDirectoryString = properties.getProperty("include.directory");
            t.setIncludeDirectory(includeDirectoryString);
            if (includeDirectoryString != null) {
                File includeDirectoryFile = new File(includeDirectoryString);
                Object includeDirectoryResource = includeDirectoryFile.isAbsolute() ? new FileSystemResource(includeDirectoryString) : sourceResource.createRelative(includeDirectoryString);
                File includeDirectory = includeDirectoryResource.getFile();
                if (includeDirectory.isDirectory()) {
                    t.setIncludeDirectoryResource((Resource)includeDirectoryResource);
                } else {
                    this.log().warn("includeDirectory '" + includeDirectoryFile.getAbsolutePath() + "' specified in '" + sourceResource.getFilename() + "' is not a directory");
                }
            }
            try {
                interval = Integer.parseInt(properties.getProperty("include.directory.rescan", "300000"));
            }
            catch (NumberFormatException e) {
                interval = 300000;
                this.log().warn("The property 'include.directory.rescan' in " + sourceResource + " was not able to be parsed as an integer.  Defaulting to " + interval + "ms", (Throwable)e);
            }
            t.setIncludeDirectoryRescanInterval(interval);
            List<PrefabGraph> graphs = this.loadPrefabGraphDefinitions(t, properties);
            for (PrefabGraph graph : graphs) {
                if (graph == null) continue;
                FileReloadContainer<PrefabGraph> container = reloadable ? new FileReloadContainer<PrefabGraph>(graph, sourceResource, t.getCallback()) : new FileReloadContainer<PrefabGraph>(graph);
                t.addPrefabGraph(container);
            }
            this.scanIncludeDirectory(t);
            PrefabGraphTypeDao prefabGraphTypeDao = t;
            return prefabGraphTypeDao;
        }
        catch (IOException e) {
            this.log().error("Failed to load prefab graph configuration of type " + type + " from " + sourceResource, (Throwable)e);
            PrefabGraphTypeDao prefabGraphTypeDao = null;
            return prefabGraphTypeDao;
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadAdhocProperties(String type, Resource resource) throws IOException {
        AdhocGraphType t;
        InputStream in = resource.getInputStream();
        try {
            t = this.createAdhocGraphType(type, in);
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        this.m_adhocTypes.put(t.getName(), new FileReloadContainer<AdhocGraphType>(t, resource, this.m_adhocCallback));
    }

    public void loadAdhocProperties(String type, InputStream in) throws IOException {
        AdhocGraphType t = this.createAdhocGraphType(type, in);
        this.m_adhocTypes.put(t.getName(), new FileReloadContainer<AdhocGraphType>(t));
    }

    private AdhocGraphType createAdhocGraphType(String type, InputStream in) throws IOException {
        Properties properties = new Properties();
        properties.load(in);
        AdhocGraphType t = new AdhocGraphType();
        t.setName(type);
        t.setCommandPrefix(this.getProperty(properties, "command.prefix"));
        t.setOutputMimeType(this.getProperty(properties, "output.mime"));
        t.setTitleTemplate(this.getProperty(properties, "adhoc.command.title"));
        t.setDataSourceTemplate(this.getProperty(properties, "adhoc.command.ds"));
        t.setGraphLineTemplate(this.getProperty(properties, "adhoc.command.graphline"));
        return t;
    }

    private List<PrefabGraph> loadPrefabGraphDefinitions(PrefabGraphTypeDao type, Properties properties) {
        String[] list;
        Assert.notNull((Object)properties, (String)"properties argument cannot be null");
        ArrayList<PrefabGraph> result = new ArrayList<PrefabGraph>();
        String listString = properties.getProperty(DEFAULT_GRAPH_LIST_KEY);
        if (listString != null) {
            list = BundleLists.parseBundleList((String)listString);
        } else {
            list = new String[1];
            try {
                list[0] = this.getProperty(properties, "report.id");
            }
            catch (DataAccessResourceFailureException e) {
                throw new DataAccessResourceFailureException("Properties must contain a 'report.id' property or a 'reports' property");
            }
        }
        for (String name : list) {
            try {
                PrefabGraph graph = this.makePrefabGraph(name, properties, type.getNextOrdering());
                result.add(graph);
            }
            catch (DataAccessResourceFailureException e) {
                this.log().error("Failed to load report '" + name + "' because:", (Throwable)e);
                result.add(null);
            }
        }
        return result;
    }

    private PrefabGraph makePrefabGraph(String name, Properties props, int order) {
        Assert.notNull((Object)name, (String)"name argument cannot be null");
        Assert.notNull((Object)props, (String)"props argument cannot be null");
        String key = name;
        if (props.getProperty("report.id") != null) {
            key = null;
        }
        String title = this.getReportProperty(props, key, "name", true);
        String command = this.getReportProperty(props, key, "command", true);
        String columnString = this.getReportProperty(props, key, "columns", true);
        String[] columns = BundleLists.parseBundleList((String)columnString);
        String externalValuesString = this.getReportProperty(props, key, "externalValues", false);
        String[] externalValues = externalValuesString == null ? new String[]{} : BundleLists.parseBundleList((String)externalValuesString);
        String propertiesValuesString = this.getReportProperty(props, key, "propertiesValues", false);
        String[] propertiesValues = propertiesValuesString == null ? new String[]{} : BundleLists.parseBundleList((String)propertiesValuesString);
        String typesString = this.getReportProperty(props, key, "type", false);
        String[] types = typesString == null ? new String[]{} : BundleLists.parseBundleList((String)typesString);
        String description = this.getReportProperty(props, key, "description", false);
        Integer graphWidth = this.getIntegerReportProperty(props, key, "width", false);
        Integer graphHeight = this.getIntegerReportProperty(props, key, "height", false);
        String suppressString = this.getReportProperty(props, key, "suppress", false);
        String[] suppress = suppressString == null ? new String[]{} : BundleLists.parseBundleList((String)suppressString);
        return new PrefabGraph(name, title, columns, command, externalValues, propertiesValues, order, types, description, graphWidth, graphHeight, suppress);
    }

    private String getProperty(Properties props, String name) {
        String property = props.getProperty(name);
        if (property == null) {
            throw new DataAccessResourceFailureException("Properties must contain '" + name + "' property");
        }
        return property;
    }

    private String getReportProperty(Properties props, String key, String suffix, boolean required) {
        String graphName;
        String propertyName;
        if (key != null) {
            propertyName = "report." + key + "." + suffix;
            graphName = key;
        } else {
            propertyName = "report." + suffix;
            graphName = props.getProperty("report.id");
        }
        String property = props.getProperty(propertyName);
        if (property == null && required) {
            throw new DataAccessResourceFailureException("Properties for report '" + graphName + "' must contain '" + propertyName + "' property");
        }
        return property;
    }

    private Integer getIntegerReportProperty(Properties props, String key, String suffix, boolean required) {
        String value = this.getReportProperty(props, key, suffix, required);
        if (value == null) {
            return null;
        }
        try {
            return new Integer(value);
        }
        catch (NumberFormatException e) {
            throw new DataAccessResourceFailureException("Property value for '" + suffix + "' on report '" + key + "' must be an integer.  '" + value + "' is not a valid value");
        }
    }

    private ThreadCategory log() {
        return ThreadCategory.getInstance(PropertiesGraphDao.class);
    }

    @Override
    public List<PrefabGraph> getAllPrefabGraphs() {
        ArrayList<PrefabGraph> graphs = new ArrayList<PrefabGraph>();
        for (FileReloadContainer<PrefabGraphTypeDao> container : this.m_types.values()) {
            PrefabGraphTypeDao type = container.getObject();
            this.rescanIncludeDirectory(type);
            Map<String, FileReloadContainer<PrefabGraph>> map = type.getReportMap();
            for (FileReloadContainer<PrefabGraph> graphContainer : map.values()) {
                graphs.add(graphContainer.getObject());
            }
        }
        return graphs;
    }

    @Override
    public PrefabGraph getPrefabGraph(String name) {
        for (FileReloadContainer<PrefabGraphTypeDao> container : this.m_types.values()) {
            PrefabGraphTypeDao type = container.getObject();
            this.rescanIncludeDirectory(type);
            PrefabGraph graph = type.getQuery(name);
            if (graph == null) continue;
            return graph;
        }
        throw new ObjectRetrievalFailureException(PrefabGraph.class, (Object)name, "Could not find prefabricated graph report with name '" + name + "'", null);
    }

    @Override
    public PrefabGraph[] getPrefabGraphsForResource(OnmsResource resource) {
        if (resource == null) {
            this.log().warn("returning empty graph list for resource because it is null");
            return new PrefabGraph[0];
        }
        Set attributes = resource.getAttributes();
        if (attributes.size() == 0) {
            this.log().debug("returning empty graph list for resource " + resource + " because its attribute list is empty");
            return new PrefabGraph[0];
        }
        Set<String> availableRrdAttributes = resource.getRrdGraphAttributes().keySet();
        Set<String> availableStringAttributes = resource.getStringPropertyAttributes().keySet();
        Set<String> availableExternalAttributes = resource.getExternalValueAttributes().keySet();
        if (availableRrdAttributes.size() == 0) {
            this.log().debug("returning empty graph list for resource " + resource + " because it has no RRD attributes");
            return new PrefabGraph[0];
        }
        String resourceType = resource.getResourceType().getName();
        LinkedHashMap<String, PrefabGraph> returnList = new LinkedHashMap<String, PrefabGraph>();
        for (PrefabGraph query : this.getAllPrefabGraphs()) {
            if (resourceType != null && !query.hasMatchingType(new String[]{resourceType})) {
                if (!this.log().isDebugEnabled()) continue;
                this.log().debug("skipping " + query.getName() + " because its types \"" + StringUtils.arrayToDelimitedString((Object[])query.getTypes(), (String)", ") + "\" does not match resourceType \"" + resourceType + "\"");
                continue;
            }
            if (!this.verifyAttributesExist(query, "RRD", Arrays.asList(query.getColumns()), availableRrdAttributes) || !this.verifyAttributesExist(query, "string property", Arrays.asList(query.getPropertiesValues()), availableStringAttributes) || !this.verifyAttributesExist(query, "external value", Arrays.asList(query.getExternalValues()), availableExternalAttributes)) continue;
            if (this.log().isDebugEnabled()) {
                this.log().debug("adding " + query.getName() + " to query list");
            }
            returnList.put(query.getName(), query);
        }
        if (this.log().isDebugEnabled()) {
            ArrayList<String> nameList = new ArrayList<String>(returnList.size());
            for (PrefabGraph graph : returnList.values()) {
                nameList.add(graph.getName());
            }
            this.log().debug("found " + nameList.size() + " prefabricated graphs for resource " + resource + ": " + StringUtils.collectionToDelimitedString(nameList, (String)", "));
        }
        HashSet<String> suppressReports = new HashSet<String>();
        for (Map.Entry entry : returnList.entrySet()) {
            suppressReports.addAll(Arrays.asList(((PrefabGraph)entry.getValue()).getSuppress()));
        }
        suppressReports.retainAll(returnList.keySet());
        if (suppressReports.size() > 0 && this.log().isDebugEnabled()) {
            this.log().debug("suppressing " + suppressReports.size() + " prefabricated graphs for resource " + resource + ": " + StringUtils.collectionToDelimitedString(suppressReports, (String)", "));
        }
        for (String suppressReport : suppressReports) {
            returnList.remove(suppressReport);
        }
        return returnList.values().toArray(new PrefabGraph[returnList.size()]);
    }

    private boolean verifyAttributesExist(PrefabGraph query, String type, List<String> requiredList, Set<String> availableRrdAttributes) {
        if (availableRrdAttributes.containsAll(requiredList)) {
            return true;
        }
        if (this.log().isDebugEnabled()) {
            String name = query.getName();
            this.log().debug("not adding " + name + " to prefab graph list because the required list of " + type + " attributes (" + StringUtils.collectionToDelimitedString(requiredList, (String)", ") + ") is not in the list of " + type + " attributes on the resource (" + StringUtils.collectionToDelimitedString(availableRrdAttributes, (String)", ") + ")");
        }
        return false;
    }

    public void afterPropertiesSet() throws IOException {
        Assert.notNull(this.m_prefabConfigs, (String)"property prefabConfigs must be set to a non-null value");
        Assert.notNull(this.m_adhocConfigs, (String)"property adhocConfigs must be set to a non-null value");
        this.initPrefab();
        this.initAdhoc();
    }

    public Map<String, Resource> getAdhocConfigs() {
        return this.m_adhocConfigs;
    }

    public void setAdhocConfigs(Map<String, Resource> adhocConfigs) {
        this.m_adhocConfigs = adhocConfigs;
    }

    public Map<String, Resource> getPrefabConfigs() {
        return this.m_prefabConfigs;
    }

    public void setPrefabConfigs(Map<String, Resource> prefabConfigs) {
        this.m_prefabConfigs = prefabConfigs;
    }

    class PrefabGraphTypeDao
    extends PrefabGraphType {
        private Map<String, FileReloadContainer<PrefabGraph>> m_reportMap = new HashMap<String, FileReloadContainer<PrefabGraph>>();
        private int m_ordering = 0;
        private long m_lastIncludeScan;
        private PrefabGraphCallback m_callback;
        private Map<File, Long> m_malformedFiles;
        private Resource m_includeDirectoryResource;

        public PrefabGraphTypeDao() {
            this.m_callback = new PrefabGraphCallback(this);
            this.m_malformedFiles = new HashMap<File, Long>();
        }

        public void setIncludeDirectoryResource(Resource includeDirectoryResource) {
            this.m_includeDirectoryResource = includeDirectoryResource;
        }

        public Resource getIncludeDirectoryResource() {
            return this.m_includeDirectoryResource;
        }

        public FileReloadCallback<PrefabGraph> getCallback() {
            return this.m_callback;
        }

        public void addPrefabGraph(FileReloadContainer<PrefabGraph> graph) {
            this.m_reportMap.put(graph.getObject().getName(), graph);
        }

        public Map<String, FileReloadContainer<PrefabGraph>> getReportMap() {
            return Collections.unmodifiableMap(this.m_reportMap);
        }

        public PrefabGraph getQuery(String queryName) {
            FileReloadContainer<PrefabGraph> container = this.m_reportMap.get(queryName);
            if (container == null) {
                return null;
            }
            return container.getObject();
        }

        public int getNextOrdering() {
            return this.m_ordering++;
        }

        public long getLastIncludeScan() {
            return this.m_lastIncludeScan;
        }

        public void setLastIncludeScan(long lastIncludeScan) {
            this.m_lastIncludeScan = lastIncludeScan;
        }

        public Map<File, Long> getMalformedFiles() {
            return this.m_malformedFiles;
        }

        public void addMalformedFile(File malformedFile) {
            this.m_malformedFiles.put(malformedFile, malformedFile.lastModified());
        }

        public void removeMalformedFile(File malformedFile) {
            this.m_malformedFiles.remove(malformedFile);
        }
    }

    private class AdhocGraphTypeCallback
    implements FileReloadCallback<AdhocGraphType> {
        private AdhocGraphTypeCallback() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AdhocGraphType reload(AdhocGraphType object, Resource resource) {
            InputStream in = null;
            try {
                in = resource.getInputStream();
                AdhocGraphType adhocGraphType = PropertiesGraphDao.this.createAdhocGraphType(object.getName(), in);
                return adhocGraphType;
            }
            catch (Throwable e) {
                PropertiesGraphDao.this.log().error("Could not reload configuration from '" + resource + "'; nested exception: " + e, e);
                AdhocGraphType adhocGraphType = null;
                return adhocGraphType;
            }
            finally {
                IOUtils.closeQuietly((InputStream)in);
            }
        }
    }

    private class PrefabGraphCallback
    implements FileReloadCallback<PrefabGraph> {
        private PrefabGraphTypeDao m_type;

        public PrefabGraphCallback(PrefabGraphTypeDao type) {
            this.m_type = type;
        }

        @Override
        public PrefabGraph reload(PrefabGraph graph, Resource resource) {
            try {
                String graphName = graph.getName();
                Properties props = new Properties();
                props.load(resource.getInputStream());
                List reloadedGraphs = PropertiesGraphDao.this.loadPrefabGraphDefinitions(this.m_type, props);
                PrefabGraph result = null;
                for (PrefabGraph reloadedGraph : reloadedGraphs) {
                    if (reloadedGraph == null) continue;
                    if (reloadedGraph.getName().equals(graphName)) {
                        result = reloadedGraph;
                    }
                    this.m_type.addPrefabGraph(new FileReloadContainer<PrefabGraph>(reloadedGraph, resource, this));
                }
                return result;
            }
            catch (Throwable e) {
                PropertiesGraphDao.this.log().error("Could not reload configuration '" + resource + "'; nested exception: " + e, e);
                return null;
            }
        }
    }

    private class PrefabGraphTypeCallback
    implements FileReloadCallback<PrefabGraphTypeDao> {
        private PrefabGraphTypeCallback() {
        }

        @Override
        public PrefabGraphTypeDao reload(PrefabGraphTypeDao object, Resource resource) {
            try {
                return PropertiesGraphDao.this.createPrefabGraphType(object.getName(), resource);
            }
            catch (Throwable e) {
                PropertiesGraphDao.this.log().error("Could not reload configuration '" + resource + "'; nested exception: " + e, e);
                return null;
            }
        }
    }
}

