/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.util.Collections;
import org.opennms.netmgt.dao.FilterDao;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.support.ResourceTreeWalker;
import org.opennms.netmgt.model.AbstractEntityVisitor;
import org.opennms.netmgt.model.EntityVisitor;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.ResourceVisitor;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class FilterWalker
implements InitializingBean {
    private FilterDao m_filterDao;
    private String m_filter;
    private ResourceDao m_resourceDao;
    private ResourceVisitor m_visitor;
    private ResourceTreeWalker m_resourceWalker = new ResourceTreeWalker();

    public void walk() {
        AbstractEntityVisitor visitor = new AbstractEntityVisitor(){

            public void visitNode(OnmsNode node) {
                FilterWalker.this.walk(node);
            }
        };
        this.getFilterDao().walkMatchingNodes(this.m_filter, (EntityVisitor)visitor);
    }

    public void walk(OnmsNode node) {
        OnmsResource resource = this.getResourceDao().getResourceForNode(node);
        this.m_resourceWalker.walk(Collections.singleton(resource));
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_resourceDao != null ? 1 : 0) != 0, (String)"property resourceDao must be set to a non-null value");
        Assert.state((this.m_visitor != null ? 1 : 0) != 0, (String)"property visitor must be set to a non-null value");
        Assert.state((this.m_filterDao != null ? 1 : 0) != 0, (String)"property filterDao must be set to a non-null value");
        Assert.state((this.m_filter != null ? 1 : 0) != 0, (String)"property filter must be set to a non-null value");
        this.m_resourceWalker.setResourceDao(this.getResourceDao());
        this.m_resourceWalker.setVisitor(this.getVisitor());
        this.m_resourceWalker.afterPropertiesSet();
    }

    public ResourceDao getResourceDao() {
        return this.m_resourceDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public ResourceVisitor getVisitor() {
        return this.m_visitor;
    }

    public void setVisitor(ResourceVisitor visitor) {
        this.m_visitor = visitor;
    }

    public FilterDao getFilterDao() {
        return this.m_filterDao;
    }

    public void setFilterDao(FilterDao filterDao) {
        this.m_filterDao = filterDao;
    }

    public String getFilter() {
        return this.m_filter;
    }

    public void setFilter(String filter) {
        this.m_filter = filter;
    }
}

