/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.Timestamp;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.netmgt.dao.StpInterfaceDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsStpInterface;

public class StpInterfaceDaoHibernate
extends AbstractDaoHibernate<OnmsStpInterface, Integer>
implements StpInterfaceDao {
    public StpInterfaceDaoHibernate() {
        super(OnmsStpInterface.class);
    }

    @Override
    public void markDeletedIfNodeDeleted() {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.type", (Object)"D"));
        for (OnmsStpInterface stpIface : this.findMatching(criteria)) {
            stpIface.setStatus(Character.valueOf('D'));
            this.saveOrUpdate(stpIface);
        }
    }

    @Override
    public void deactivateForNodeIdIfOlderThan(int nodeid, Timestamp scanTime) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add((Criterion)Restrictions.eq((String)"status", (Object)"A"));
        for (OnmsStpInterface item : this.findMatching(criteria)) {
            item.setStatus(Character.valueOf('N'));
            this.saveOrUpdate(item);
        }
    }

    @Override
    public void setStatusForNode(Integer nodeid, Character action) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        for (OnmsStpInterface item : this.findMatching(criteria)) {
            item.setStatus(action);
            this.saveOrUpdate(item);
        }
    }

    @Override
    public void setStatusForNodeAndIfIndex(Integer nodeid, Integer ifIndex, Character action) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.eq((String)"ifIndex", (Object)ifIndex));
        for (OnmsStpInterface item : this.findMatching(criteria)) {
            item.setStatus(action);
            this.saveOrUpdate(item);
        }
    }

    @Override
    public OnmsStpInterface findByNodeAndVlan(Integer nodeId, Integer bridgePort, Integer vlan) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsStpInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"bridgePort", (Object)bridgePort));
        criteria.add((Criterion)Restrictions.eq((String)"vlan", (Object)vlan));
        List stpInterfaces = this.findMatching(criteria);
        if (stpInterfaces != null && stpInterfaces.size() > 0) {
            return (OnmsStpInterface)stpInterfaces.get(0);
        }
        return null;
    }
}

