/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.net.InetAddress;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.AtInterfaceDao;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.dao.support.UpsertTemplate;
import org.opennms.netmgt.model.OnmsAtInterface;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.util.Assert;

public class AtInterfaceDaoHibernate
extends AbstractDaoHibernate<OnmsAtInterface, Integer>
implements AtInterfaceDao {
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private PlatformTransactionManager m_transactionManager;

    public AtInterfaceDaoHibernate() {
        super(OnmsAtInterface.class);
    }

    @Override
    public void markDeletedIfNodeDeleted() {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAtInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.type", (Object)"D"));
        for (OnmsAtInterface iface : this.findMatching(criteria)) {
            iface.setStatus(Character.valueOf('D'));
            this.saveOrUpdate(iface);
        }
    }

    @Override
    public void deactivateForNodeIdIfOlderThan(int nodeid, Timestamp scanTime) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAtInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.lt((String)"lastPollTime", (Object)scanTime));
        criteria.add((Criterion)Restrictions.eq((String)"status", (Object)"A"));
        for (OnmsAtInterface iface : this.findMatching(criteria)) {
            iface.setStatus(Character.valueOf('N'));
            this.saveOrUpdate(iface);
        }
    }

    @Override
    public Collection<OnmsAtInterface> findByMacAddress(String macAddress) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAtInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"macAddress", (Object)macAddress));
        criteria.add((Criterion)Restrictions.ne((String)"status", (Object)"D"));
        return this.findMatching(criteria);
    }

    @Override
    public void setStatusForNode(Integer nodeid, Character action) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAtInterface.class);
        criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid), (Criterion)Restrictions.eq((String)"sourceNodeId", (Object)nodeid)));
        for (OnmsAtInterface iface : this.findMatching(criteria)) {
            iface.setStatus(action);
            this.saveOrUpdate(iface);
        }
    }

    @Override
    public void setStatusForNodeAndIp(Integer nodeid, String ipAddr, Character action) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAtInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)ipAddr));
        for (OnmsAtInterface iface : this.findMatching(criteria)) {
            iface.setStatus(action);
            this.saveOrUpdate(iface);
        }
    }

    @Override
    public void setStatusForNodeAndIfIndex(Integer nodeid, Integer ifIndex, Character action) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAtInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeid));
        criteria.add((Criterion)Restrictions.eq((String)"ifIndex", (Object)ifIndex));
        for (OnmsAtInterface iface : this.findMatching(criteria)) {
            iface.setStatus(action);
            this.saveOrUpdate(iface);
        }
    }

    @Override
    public OnmsAtInterface findByNodeAndAddress(Integer nodeId, InetAddress ipAddress, String macAddress) {
        OnmsCriteria criteria = new OnmsCriteria(OnmsAtInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.id", (Object)nodeId));
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)ipAddress));
        criteria.add((Criterion)Restrictions.eq((String)"macAddress", (Object)macAddress));
        List ifaces = this.findMatching(criteria);
        if (ifaces.size() == 0) {
            return null;
        }
        return (OnmsAtInterface)ifaces.get(0);
    }

    @Override
    public void saveAtInterface(Connection dbConn, final OnmsAtInterface saveMe) {
        new UpsertTemplate<OnmsAtInterface, AtInterfaceDao>(this.m_transactionManager, (AtInterfaceDao)this){

            @Override
            protected OnmsAtInterface query() {
                return ((AtInterfaceDao)this.m_dao).findByNodeAndAddress(saveMe.getNode().getId(), saveMe.getIpAddress(), saveMe.getMacAddress());
            }

            @Override
            protected OnmsAtInterface doUpdate(OnmsAtInterface updateMe) {
                Assert.isTrue((updateMe.getNode().compareTo(saveMe.getNode()) == 0 ? 1 : 0) != 0);
                Assert.isTrue((boolean)updateMe.getIpAddress().equals(saveMe.getIpAddress()));
                Assert.isTrue((boolean)updateMe.getMacAddress().equals(saveMe.getMacAddress()));
                if (updateMe.getId() == null && saveMe.getId() != null) {
                    updateMe.setId(saveMe.getId());
                }
                updateMe.setIfIndex(saveMe.getIfIndex());
                updateMe.setLastPollTime(saveMe.getLastPollTime());
                updateMe.setSourceNodeId(saveMe.getSourceNodeId());
                updateMe.setStatus(saveMe.getStatus());
                ((AtInterfaceDao)this.m_dao).update(updateMe);
                ((AtInterfaceDao)this.m_dao).flush();
                return updateMe;
            }

            @Override
            protected OnmsAtInterface doInsert() {
                ((AtInterfaceDao)this.m_dao).save(saveMe);
                ((AtInterfaceDao)this.m_dao).flush();
                return saveMe;
            }
        }.execute();
    }

    @Override
    public OnmsAtInterface getAtInterfaceForAddress(Connection dbConn, InetAddress address) {
        final String addressString = InetAddressUtils.str((InetAddress)address);
        if (address.isLoopbackAddress() || addressString.equals("0.0.0.0")) {
            return null;
        }
        OnmsCriteria criteria = new OnmsCriteria(OnmsAtInterface.class);
        criteria.createAlias("node", "node", 1);
        criteria.add((Criterion)Restrictions.eq((String)"node.type", (Object)"A"));
        criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)addressString));
        List interfaces = this.findMatching(criteria);
        if (interfaces.isEmpty()) {
            return (OnmsAtInterface)new UpsertTemplate<OnmsAtInterface, AtInterfaceDao>(this.m_transactionManager, (AtInterfaceDao)this){

                @Override
                protected OnmsAtInterface query() {
                    OnmsCriteria criteria = new OnmsCriteria(OnmsAtInterface.class);
                    criteria.createAlias("node", "node", 1);
                    criteria.add((Criterion)Restrictions.eq((String)"node.type", (Object)"A"));
                    criteria.add((Criterion)Restrictions.eq((String)"ipAddress", (Object)addressString));
                    List interfaces = AtInterfaceDaoHibernate.this.findMatching(criteria);
                    if (interfaces.isEmpty()) {
                        return null;
                    }
                    if (interfaces.size() > 1) {
                        LogUtils.debugf((Object)this, (String)"getAtInterfaceForAddress: More than one AtInterface matched address %s!", (Object[])new Object[]{addressString});
                    }
                    return (OnmsAtInterface)interfaces.get(0);
                }

                @Override
                protected OnmsAtInterface doUpdate(OnmsAtInterface dbObj) {
                    return dbObj;
                }

                @Override
                protected OnmsAtInterface doInsert() {
                    List<OnmsIpInterface> ifaces = AtInterfaceDaoHibernate.this.m_ipInterfaceDao.findByIpAddress(addressString);
                    if (ifaces.isEmpty()) {
                        return null;
                    }
                    if (ifaces.size() > 1) {
                        LogUtils.debugf((Object)this, (String)"getAtInterfaceForAddress: More than one AtInterface matched address %s!", (Object[])new Object[]{addressString});
                    }
                    OnmsIpInterface iface = ifaces.get(0);
                    OnmsAtInterface retval = new OnmsAtInterface(iface.getNode(), iface.getIpAddress());
                    retval.setLastPollTime(new Date());
                    retval.setSourceNodeId(iface.getNode().getId());
                    retval.setStatus(Character.valueOf('N'));
                    AtInterfaceDaoHibernate.this.save(retval);
                    return retval;
                }
            }.execute();
        }
        if (interfaces.size() > 1) {
            LogUtils.debugf((Object)this, (String)"getAtInterfaceForAddress: More than one AtInterface matched address %s!", (Object[])new Object[]{addressString});
        }
        return (OnmsAtInterface)interfaces.get(0);
    }
}

