/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.opennms.netmgt.dao.ResourceDao;
import org.opennms.netmgt.dao.support.ResourceTypeUtils;
import org.opennms.netmgt.model.OnmsAttribute;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.springframework.orm.ObjectRetrievalFailureException;

public class NodeSnmpResourceType
implements OnmsResourceType {
    private ResourceDao m_resourceDao;

    public NodeSnmpResourceType(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public String getName() {
        return "nodeSnmp";
    }

    public String getLabel() {
        return "SNMP Node Data";
    }

    public boolean isResourceTypeOnNode(int nodeId) {
        return this.getResourceDirectory(nodeId, false).isDirectory();
    }

    public File getResourceDirectory(int nodeId, boolean verify) {
        File snmp = new File(this.m_resourceDao.getRrdDirectory(verify), "snmp");
        File node = new File(snmp, Integer.toString(nodeId));
        if (verify && !node.isDirectory()) {
            throw new ObjectRetrievalFailureException(File.class, (Object)("No node directory exists for node " + nodeId + ": " + node));
        }
        return node;
    }

    public List<OnmsResource> getResourcesForNode(int nodeId) {
        ArrayList<OnmsResource> resources = new ArrayList<OnmsResource>();
        Set<OnmsAttribute> attributes = ResourceTypeUtils.getAttributesAtRelativePath(this.m_resourceDao.getRrdDirectory(), this.getRelativePathForResource(nodeId));
        OnmsResource resource = new OnmsResource("", "Node-level Performance Data", (OnmsResourceType)this, attributes);
        resources.add(resource);
        return resources;
    }

    private String getRelativePathForResource(int nodeId) {
        return "snmp" + File.separator + Integer.toString(nodeId);
    }

    public boolean isResourceTypeOnDomain(String domain) {
        return false;
    }

    public List<OnmsResource> getResourcesForDomain(String domain) {
        List<OnmsResource> empty = Collections.emptyList();
        return empty;
    }

    public String getLinkForResource(OnmsResource resource) {
        return null;
    }
}

