/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.Marshaller;
import org.exolab.castor.xml.ValidationException;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.opennms.core.xml.CastorUtils;
import org.opennms.core.xml.MarshallingResourceFailureException;
import org.opennms.netmgt.config.monitoringLocations.LocationDef;
import org.opennms.netmgt.config.monitoringLocations.Locations;
import org.opennms.netmgt.config.monitoringLocations.MonitoringLocationsConfiguration;
import org.opennms.netmgt.config.tags.Tag;
import org.opennms.netmgt.config.tags.Tags;
import org.opennms.netmgt.dao.LocationMonitorDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.LocationMonitorIpInterface;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsMonitoringLocationDefinition;
import org.springframework.core.io.Resource;
import org.springframework.orm.hibernate3.HibernateCallback;

public class LocationMonitorDaoHibernate
extends AbstractDaoHibernate<OnmsLocationMonitor, Integer>
implements LocationMonitorDao {
    private MonitoringLocationsConfiguration m_monitoringLocationsConfiguration;
    private Resource m_monitoringLocationConfigResource;
    private Map<String, LocationDef> m_locationDefs = new HashMap<String, LocationDef>();

    public LocationMonitorDaoHibernate() {
        super(OnmsLocationMonitor.class);
    }

    @Override
    protected void initDao() throws Exception {
        super.initDao();
        this.assertPropertiesSet();
        this.initializeConfigurations();
    }

    @Override
    public List<OnmsMonitoringLocationDefinition> findAllMonitoringLocationDefinitions() {
        List locationDefCollection;
        Locations locations = this.m_monitoringLocationsConfiguration.getLocations();
        if (locations != null && (locationDefCollection = locations.getLocationDefCollection()) != null) {
            return this.convertDefs(locationDefCollection);
        }
        return new ArrayList<OnmsMonitoringLocationDefinition>();
    }

    private List<OnmsMonitoringLocationDefinition> convertDefs(List<LocationDef> defs) {
        LinkedList<OnmsMonitoringLocationDefinition> onmsDefs = new LinkedList<OnmsMonitoringLocationDefinition>();
        for (LocationDef def : defs) {
            onmsDefs.add(this.convertDef(def));
        }
        return onmsDefs;
    }

    private OnmsMonitoringLocationDefinition convertDef(LocationDef def) {
        OnmsMonitoringLocationDefinition onmsDef = new OnmsMonitoringLocationDefinition();
        onmsDef.setArea(def.getMonitoringArea());
        onmsDef.setName(def.getLocationName());
        onmsDef.setPollingPackageName(def.getPollingPackageName());
        onmsDef.setGeolocation(def.getGeolocation());
        onmsDef.setCoordinates(def.getCoordinates());
        onmsDef.setPriority(Long.valueOf(def.getPriority()));
        if (def.getTags() != null) {
            HashSet<String> tags = new HashSet<String>();
            for (Tag t : def.getTags().getTagCollection()) {
                tags.add(t.getName());
            }
            onmsDef.setTags(tags);
        }
        return onmsDef;
    }

    @Override
    public void saveMonitoringLocationDefinitions(Collection<OnmsMonitoringLocationDefinition> onmsDefs) {
        for (OnmsMonitoringLocationDefinition onmsDef : onmsDefs) {
            LocationDef def = this.findLocationDef(onmsDef.getName());
            if (def == null) continue;
            this.updateLocationDef(def, onmsDef);
        }
        this.saveMonitoringConfig();
    }

    private void updateLocationDef(LocationDef def, OnmsMonitoringLocationDefinition onmsDef) {
        def.setMonitoringArea(onmsDef.getArea());
        def.setPollingPackageName(onmsDef.getPollingPackageName());
        def.setGeolocation(onmsDef.getGeolocation());
        def.setCoordinates(onmsDef.getCoordinates());
        def.setPriority(onmsDef.getPriority().longValue());
        Tags tags = new Tags();
        for (String tag : onmsDef.getTags()) {
            Tag t = new Tag();
            t.setName(tag);
            tags.addTag(t);
        }
        def.setTags(tags);
    }

    @Override
    public void saveMonitoringLocationDefinition(OnmsMonitoringLocationDefinition onmsDef) {
        LocationDef def = this.findLocationDef(onmsDef.getName());
        if (def != null) {
            this.updateLocationDef(def, onmsDef);
        }
        this.saveMonitoringConfig();
    }

    protected void saveMonitoringConfig() {
        String xml = null;
        StringWriter writer = new StringWriter();
        try {
            Marshaller.marshal((Object)this.m_monitoringLocationsConfiguration, (Writer)writer);
            xml = writer.toString();
            this.saveXml(xml);
        }
        catch (MarshalException e) {
            throw new MarshallingResourceFailureException("saveMonitoringConfig: couldn't marshal confg: \n" + (xml != null ? xml : ""), (Throwable)e);
        }
        catch (ValidationException e) {
            throw new MarshallingResourceFailureException("saveMonitoringConfig: couldn't validate confg: \n" + (xml != null ? xml : ""), (Throwable)e);
        }
        catch (IOException e) {
            throw new MarshallingResourceFailureException("saveMonitoringConfig: couldn't write confg: \n" + (xml != null ? xml : ""), (Throwable)e);
        }
    }

    protected void saveXml(String xml) throws IOException {
        if (xml != null) {
            OutputStreamWriter fileWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(this.m_monitoringLocationConfigResource.getFile()), "UTF-8");
            fileWriter.write(xml);
            ((Writer)fileWriter).flush();
            ((Writer)fileWriter).close();
        }
    }

    private LocationDef findLocationDef(String definitionName) {
        return this.m_locationDefs.get(definitionName);
    }

    private void initializeConfigurations() {
        this.initializeMonitoringLocationDefinition();
    }

    private void initializeMonitoringLocationDefinition() {
        this.m_monitoringLocationsConfiguration = (MonitoringLocationsConfiguration)CastorUtils.unmarshalWithTranslatedExceptions(MonitoringLocationsConfiguration.class, (Resource)this.m_monitoringLocationConfigResource);
        this.createLocationDefMap();
    }

    private void createLocationDefMap() {
        if (this.m_monitoringLocationsConfiguration.getLocations() != null) {
            for (LocationDef def : this.m_monitoringLocationsConfiguration.getLocations().getLocationDefCollection()) {
                this.m_locationDefs.put(def.getLocationName(), def);
            }
        }
    }

    public Collection<OnmsMonitoringLocationDefinition> findAllLocationDefinitions() {
        LinkedList<OnmsMonitoringLocationDefinition> eDefs = new LinkedList<OnmsMonitoringLocationDefinition>();
        for (LocationDef def : this.m_monitoringLocationsConfiguration.getLocations().getLocationDefCollection()) {
            eDefs.add(this.convertDef(def));
        }
        return eDefs;
    }

    private void assertPropertiesSet() {
        if (this.m_monitoringLocationConfigResource == null && this.m_monitoringLocationsConfiguration == null) {
            throw new IllegalStateException("either monitoringLocationConfigResource or monitorLocationsConfiguration must be set but is not");
        }
    }

    public Resource getMonitoringLocationConfigResource() {
        return this.m_monitoringLocationConfigResource;
    }

    public void setMonitoringLocationConfigResource(Resource monitoringLocationResource) {
        this.m_monitoringLocationConfigResource = monitoringLocationResource;
        this.initializeMonitoringLocationDefinition();
    }

    @Override
    public OnmsMonitoringLocationDefinition findMonitoringLocationDefinition(String monitoringLocationDefinitionName) {
        this.assertNotNull(monitoringLocationDefinitionName, "monitoringLocationDefinitionName must not be null");
        LocationDef locationDef = this.findLocationDef(monitoringLocationDefinitionName);
        return locationDef == null ? null : this.convertDef(locationDef);
    }

    private void assertNotNull(String monitoringLocationDefinitionName, String msg) {
        if (monitoringLocationDefinitionName == null) {
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public OnmsLocationSpecificStatus getMostRecentStatusChange(final OnmsLocationMonitor locationMonitor, final OnmsMonitoredService monSvc) {
        HibernateCallback<OnmsLocationSpecificStatus> callback = new HibernateCallback<OnmsLocationSpecificStatus>(){

            public OnmsLocationSpecificStatus doInHibernate(Session session) throws HibernateException, SQLException {
                return (OnmsLocationSpecificStatus)session.createQuery("from OnmsLocationSpecificStatus status where status.locationMonitor = :locationMonitor and status.monitoredService = :monitoredService order by status.pollResult.timestamp desc").setEntity("locationMonitor", (Object)locationMonitor).setEntity("monitoredService", (Object)monSvc).setMaxResults(1).uniqueResult();
            }
        };
        return (OnmsLocationSpecificStatus)this.getHibernateTemplate().execute((HibernateCallback)callback);
    }

    @Override
    public void saveStatusChange(OnmsLocationSpecificStatus statusChange) {
        this.getHibernateTemplate().save((Object)statusChange);
    }

    @Override
    public Collection<OnmsLocationMonitor> findByApplication(OnmsApplication application) {
        return this.findObjects(OnmsLocationMonitor.class, "select distinct l from OnmsLocationSpecificStatus as status join status.monitoredService as m join m.applications a join status.locationMonitor as l where a = ? and status.id in ( select max(s.id) from OnmsLocationSpecificStatus as s group by s.locationMonitor, s.monitoredService )", application);
    }

    @Override
    public Collection<OnmsLocationMonitor> findByLocationDefinition(OnmsMonitoringLocationDefinition locationDefinition) {
        return this.find("from OnmsLocationMonitor as mon where mon.definitionName = ?", locationDefinition.getName());
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getAllMostRecentStatusChanges() {
        return this.getAllStatusChangesAt(new Date());
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getAllStatusChangesAt(Date timestamp) {
        return this.findObjects(OnmsLocationSpecificStatus.class, "from OnmsLocationSpecificStatus as status left join fetch status.locationMonitor as l left join fetch status.monitoredService as m left join fetch m.serviceType left join fetch m.ipInterface where status.id in (select max(s.id) from OnmsLocationSpecificStatus as s where s.pollResult.timestamp <? group by s.locationMonitor, s.monitoredService )", timestamp);
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getStatusChangesBetween(Date startDate, Date endDate) {
        return this.findObjects(OnmsLocationSpecificStatus.class, "from OnmsLocationSpecificStatus as status where ? <= status.pollResult.timestamp and status.pollResult.timestamp < ?", startDate, endDate);
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getStatusChangesForLocationBetween(Date startDate, Date endDate, String locationName) {
        Collection<OnmsLocationSpecificStatus> statuses = this.getMostRecentStatusChangesForDateAndLocation(startDate, locationName);
        statuses.addAll(this.findObjects(OnmsLocationSpecificStatus.class, "from OnmsLocationSpecificStatus as status where ? <= status.pollResult.timestamp and status.pollResult.timestamp < ? and status.locationMonitor.definitionName = ?", startDate, endDate, locationName));
        return statuses;
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getStatusChangesForApplicationBetween(Date startDate, Date endDate, String applicationName) {
        return this.findObjects(OnmsLocationSpecificStatus.class, "from OnmsLocationSpecificStatus as status left join fetch status.monitoredService as m left join fetch m.applications as a left join fetch status.locationMonitor as lm where a.name = ? and ( status.pollResult.timestamp between ? and ?  or  status.id in    (       select max(s.id) from OnmsLocationSpecificStatus as s        where s.pollResult.timestamp < ?        group by s.locationMonitor, s.monitoredService    ))", applicationName, startDate, endDate, startDate);
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getStatusChangesBetweenForApplications(final Date startDate, final Date endDate, final Collection<String> applicationNames) {
        return (Collection)this.getHibernateTemplate().execute((HibernateCallback)new HibernateCallback<List<OnmsLocationSpecificStatus>>(){

            public List<OnmsLocationSpecificStatus> doInHibernate(Session session) throws HibernateException, SQLException {
                return session.createQuery("select distinct status from OnmsLocationSpecificStatus as status left join fetch status.monitoredService as m left join fetch m.serviceType left join fetch m.applications as a left join fetch status.locationMonitor as lm where a.name in (:applicationNames) and ( status.pollResult.timestamp between :startDate and :endDate  or  status.id in    (       select max(s.id) from OnmsLocationSpecificStatus as s        where s.pollResult.timestamp < :startDate        group by s.locationMonitor, s.monitoredService    )) order by status.pollResult.timestamp").setParameterList("applicationNames", applicationNames).setParameter("startDate", (Object)startDate).setParameter("endDate", (Object)endDate).list();
            }
        });
    }

    @Override
    public Collection<OnmsLocationSpecificStatus> getMostRecentStatusChangesForLocation(String locationName) {
        return this.getMostRecentStatusChangesForDateAndLocation(new Date(), locationName);
    }

    private Collection<OnmsLocationSpecificStatus> getMostRecentStatusChangesForDateAndLocation(Date date, String locationName) {
        return this.findObjects(OnmsLocationSpecificStatus.class, "from OnmsLocationSpecificStatus as status left join fetch status.locationMonitor as l left join fetch status.monitoredService as m left join fetch m.serviceType left join fetch m.ipInterface where status.pollResult.timestamp = (     select max(recentStatus.pollResult.timestamp)     from OnmsLocationSpecificStatus as recentStatus     where recentStatus.pollResult.timestamp < ?     group by recentStatus.locationMonitor, recentStatus.monitoredService     having recentStatus.locationMonitor = status.locationMonitor     and recentStatus.monitoredService = status.monitoredService ) and l.definitionName = ?", date, locationName);
    }

    @Override
    public Collection<LocationMonitorIpInterface> findStatusChangesForNodeForUniqueMonitorAndInterface(int nodeId) {
        List l = this.getHibernateTemplate().find("select distinct status.locationMonitor, status.monitoredService.ipInterface from OnmsLocationSpecificStatus as status where status.monitoredService.ipInterface.node.id = ?", (Object)nodeId);
        HashSet<LocationMonitorIpInterface> ret = new HashSet<LocationMonitorIpInterface>();
        for (Object[] tuple : l) {
            OnmsLocationMonitor mon = (OnmsLocationMonitor)tuple[0];
            OnmsIpInterface ip = (OnmsIpInterface)tuple[1];
            ret.add(new LocationMonitorIpInterface(mon, ip));
        }
        return ret;
    }

    @Override
    public void pauseAll() {
        this.getHibernateTemplate().bulkUpdate("update OnmsLocationMonitor as mon set mon.status = ? where mon.status != ?", new Object[]{OnmsLocationMonitor.MonitorStatus.PAUSED, OnmsLocationMonitor.MonitorStatus.STOPPED});
    }

    @Override
    public void resumeAll() {
        this.getHibernateTemplate().bulkUpdate("update OnmsLocationMonitor as mon set mon.status = ? where mon.status = ?", new Object[]{OnmsLocationMonitor.MonitorStatus.STARTED, OnmsLocationMonitor.MonitorStatus.PAUSED});
    }
}

