/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.sql.SQLException;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.opennms.netmgt.model.FilterManager;
import org.springframework.orm.hibernate3.HibernateCallback;
import org.springframework.orm.hibernate3.HibernateTemplate;

public class HibernateFilterManager
implements FilterManager {
    private HibernateTemplate m_template;

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.m_template = new HibernateTemplate(sessionFactory);
    }

    public void disableAuthorizationFilter() {
        HibernateCallback<Object> cb = new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.disableFilter("authorizedOnly");
                return null;
            }
        };
        this.m_template.execute((HibernateCallback)cb);
    }

    public void enableAuthorizationFilter(final String[] authorizationGroups) {
        HibernateCallback<Object> cb = new HibernateCallback<Object>(){

            public Object doInHibernate(Session session) throws HibernateException, SQLException {
                session.enableFilter("authorizedOnly").setParameterList("userGroups", (Object[])authorizationGroups);
                return null;
            }
        };
        this.m_template.execute((HibernateCallback)cb);
    }
}

