/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.FetchMode;
import org.hibernate.Session;
import org.hibernate.criterion.Conjunction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.DetachedCriteria;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.criterion.Subqueries;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.opennms.core.criteria.AbstractCriteriaVisitor;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.Fetch;
import org.opennms.core.criteria.Order;
import org.opennms.core.criteria.restrictions.AllRestriction;
import org.opennms.core.criteria.restrictions.AnyRestriction;
import org.opennms.core.criteria.restrictions.BaseRestrictionVisitor;
import org.opennms.core.criteria.restrictions.BetweenRestriction;
import org.opennms.core.criteria.restrictions.EqRestriction;
import org.opennms.core.criteria.restrictions.GeRestriction;
import org.opennms.core.criteria.restrictions.GtRestriction;
import org.opennms.core.criteria.restrictions.IlikeRestriction;
import org.opennms.core.criteria.restrictions.InRestriction;
import org.opennms.core.criteria.restrictions.IplikeRestriction;
import org.opennms.core.criteria.restrictions.LeRestriction;
import org.opennms.core.criteria.restrictions.LikeRestriction;
import org.opennms.core.criteria.restrictions.LtRestriction;
import org.opennms.core.criteria.restrictions.NeRestriction;
import org.opennms.core.criteria.restrictions.NotNullRestriction;
import org.opennms.core.criteria.restrictions.NotRestriction;
import org.opennms.core.criteria.restrictions.NullRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.RestrictionVisitor;
import org.opennms.core.criteria.restrictions.SqlRestriction;
import org.opennms.netmgt.dao.CriteriaConverter;

public class HibernateCriteriaConverter
implements CriteriaConverter<DetachedCriteria> {
    public org.hibernate.Criteria convert(Criteria criteria, Session session) {
        HibernateCriteriaVisitor visitor = new HibernateCriteriaVisitor();
        criteria.visit((Criteria.CriteriaVisitor)visitor);
        return visitor.getCriteria(session);
    }

    @Override
    public DetachedCriteria convert(Criteria criteria) {
        HibernateCriteriaVisitor visitor = new HibernateCriteriaVisitor();
        criteria.visit((Criteria.CriteriaVisitor)visitor);
        return visitor.getCriteria();
    }

    public static final class HibernateRestrictionVisitor
    extends BaseRestrictionVisitor
    implements RestrictionVisitor {
        private static final StringType STRING_TYPE = new StringType();
        private List<Criterion> m_criterions = new ArrayList<Criterion>();

        public List<Criterion> getCriterions() {
            return this.m_criterions;
        }

        public void visitNull(NullRestriction restriction) {
            this.m_criterions.add(Restrictions.isNull((String)restriction.getAttribute()));
        }

        public void visitNotNull(NotNullRestriction restriction) {
            this.m_criterions.add(Restrictions.isNotNull((String)restriction.getAttribute()));
        }

        public void visitEq(EqRestriction restriction) {
            this.m_criterions.add((Criterion)Restrictions.eq((String)restriction.getAttribute(), (Object)restriction.getValue()));
        }

        public void visitNe(NeRestriction restriction) {
            this.m_criterions.add((Criterion)Restrictions.ne((String)restriction.getAttribute(), (Object)restriction.getValue()));
        }

        public void visitGt(GtRestriction restriction) {
            this.m_criterions.add((Criterion)Restrictions.gt((String)restriction.getAttribute(), (Object)restriction.getValue()));
        }

        public void visitGe(GeRestriction restriction) {
            this.m_criterions.add((Criterion)Restrictions.ge((String)restriction.getAttribute(), (Object)restriction.getValue()));
        }

        public void visitLt(LtRestriction restriction) {
            this.m_criterions.add((Criterion)Restrictions.lt((String)restriction.getAttribute(), (Object)restriction.getValue()));
        }

        public void visitLe(LeRestriction restriction) {
            this.m_criterions.add((Criterion)Restrictions.le((String)restriction.getAttribute(), (Object)restriction.getValue()));
        }

        public void visitAllComplete(AllRestriction restriction) {
            int restrictionSize = restriction.getRestrictions().size();
            int criterionSize = this.m_criterions.size();
            if (criterionSize < restrictionSize) {
                throw new IllegalStateException("AllRestriction with " + restrictionSize + " entries encountered, but we only have " + criterionSize + " criterions!");
            }
            List<Criterion> criterions = this.m_criterions.subList(criterionSize - restrictionSize, criterionSize);
            Conjunction j = Restrictions.conjunction();
            for (Criterion crit : criterions) {
                j.add(crit);
            }
            criterions.clear();
            this.m_criterions.add((Criterion)j);
        }

        public void visitAnyComplete(AnyRestriction restriction) {
            int restrictionSize = restriction.getRestrictions().size();
            int criterionSize = this.m_criterions.size();
            if (criterionSize < restrictionSize) {
                throw new IllegalStateException("AllRestriction with " + restrictionSize + " entries encountered, but we only have " + criterionSize + " criterions!");
            }
            List<Criterion> criterions = this.m_criterions.subList(criterionSize - restrictionSize, criterionSize);
            Disjunction j = Restrictions.disjunction();
            for (Criterion crit : criterions) {
                j.add(crit);
            }
            criterions.clear();
            this.m_criterions.add((Criterion)j);
        }

        public void visitLike(LikeRestriction restriction) {
            this.m_criterions.add((Criterion)Restrictions.like((String)restriction.getAttribute(), (Object)restriction.getValue()));
        }

        public void visitIlike(IlikeRestriction restriction) {
            this.m_criterions.add(Restrictions.ilike((String)restriction.getAttribute(), (Object)restriction.getValue()));
        }

        public void visitIn(InRestriction restriction) {
            this.m_criterions.add(Restrictions.in((String)restriction.getAttribute(), (Collection)restriction.getValues()));
        }

        public void visitNotComplete(NotRestriction restriction) {
            if (this.m_criterions.size() == 0) {
                throw new IllegalStateException("NotRestriction called, but no criterions exist to negate!");
            }
            Criterion criterion = this.m_criterions.remove(this.m_criterions.size() - 1);
            this.m_criterions.add(Restrictions.not((Criterion)criterion));
        }

        public void visitBetween(BetweenRestriction restriction) {
            this.m_criterions.add(Restrictions.between((String)restriction.getAttribute(), (Object)restriction.getBegin(), (Object)restriction.getEnd()));
        }

        public void visitSql(SqlRestriction restriction) {
            this.m_criterions.add(Restrictions.sqlRestriction((String)restriction.getAttribute()));
        }

        public void visitIplike(IplikeRestriction restriction) {
            this.m_criterions.add(Restrictions.sqlRestriction((String)"iplike({alias}.ipAddr, ?)", (Object)((String)restriction.getValue()), (Type)STRING_TYPE));
        }
    }

    public static final class HibernateOrderVisitor
    implements Order.OrderVisitor {
        private String m_attribute;
        private boolean m_ascending = true;

        public void visitAttribute(String attribute) {
            this.m_attribute = attribute;
        }

        public void visitAscending(boolean ascending) {
            this.m_ascending = ascending;
        }

        public org.hibernate.criterion.Order getOrder() {
            if (this.m_ascending) {
                return org.hibernate.criterion.Order.asc((String)this.m_attribute);
            }
            return org.hibernate.criterion.Order.desc((String)this.m_attribute);
        }
    }

    public static final class HibernateCriteriaVisitor
    extends AbstractCriteriaVisitor {
        private DetachedCriteria m_criteria;
        private Class<?> m_class;
        private Set<org.hibernate.criterion.Order> m_orders = new LinkedHashSet<org.hibernate.criterion.Order>();
        private Set<Criterion> m_criterions = new LinkedHashSet<Criterion>();
        private boolean m_distinct = false;
        private Integer m_limit;
        private Integer m_offset;

        public org.hibernate.Criteria getCriteria(Session session) {
            org.hibernate.Criteria hibernateCriteria = this.getCriteria().getExecutableCriteria(session);
            if (this.m_limit != null) {
                hibernateCriteria.setMaxResults(this.m_limit.intValue());
            }
            if (this.m_offset != null) {
                hibernateCriteria.setFirstResult(this.m_offset.intValue());
            }
            return hibernateCriteria;
        }

        public DetachedCriteria getCriteria() {
            if (this.m_criteria == null) {
                throw new IllegalStateException("Unable to determine Class<?> of this criteria!");
            }
            for (Criterion criterion : this.m_criterions) {
                this.m_criteria.add(criterion);
            }
            if (this.m_distinct) {
                this.m_criteria.setProjection(Projections.distinct((Projection)Projections.id()));
                DetachedCriteria newCriteria = DetachedCriteria.forClass(this.m_class);
                newCriteria.add(Subqueries.propertyIn((String)"id", (DetachedCriteria)this.m_criteria));
                this.m_criteria = newCriteria;
            }
            for (org.hibernate.criterion.Order order : this.m_orders) {
                this.m_criteria.addOrder(order);
            }
            return this.m_criteria;
        }

        public void visitClass(Class<?> clazz) {
            this.m_class = clazz;
            this.m_criteria = DetachedCriteria.forClass(clazz);
        }

        public void visitOrder(Order order) {
            HibernateOrderVisitor visitor = new HibernateOrderVisitor();
            order.visit((Order.OrderVisitor)visitor);
            this.m_orders.add(visitor.getOrder());
        }

        public void visitAlias(Alias alias) {
            int aliasType = 0;
            switch (alias.getType()) {
                case FULL_JOIN: {
                    aliasType = 4;
                    break;
                }
                case LEFT_JOIN: {
                    aliasType = 1;
                    break;
                }
                case INNER_JOIN: {
                    aliasType = 0;
                    break;
                }
                default: {
                    aliasType = 0;
                }
            }
            this.m_criteria.createAlias(alias.getAssociationPath(), alias.getAlias(), aliasType);
        }

        public void visitFetch(Fetch fetch) {
            switch (fetch.getFetchType()) {
                case DEFAULT: {
                    this.m_criteria.setFetchMode(fetch.getAttribute(), FetchMode.DEFAULT);
                    break;
                }
                case EAGER: {
                    this.m_criteria.setFetchMode(fetch.getAttribute(), FetchMode.JOIN);
                    break;
                }
                case LAZY: {
                    this.m_criteria.setFetchMode(fetch.getAttribute(), FetchMode.SELECT);
                    break;
                }
                default: {
                    this.m_criteria.setFetchMode(fetch.getAttribute(), FetchMode.DEFAULT);
                }
            }
        }

        public void visitRestriction(Restriction restriction) {
            HibernateRestrictionVisitor visitor = new HibernateRestrictionVisitor();
            restriction.visit((RestrictionVisitor)visitor);
            this.m_criterions.addAll(visitor.getCriterions());
        }

        public void visitDistinct(boolean distinct) {
            this.m_distinct = distinct;
        }

        public void visitLimit(Integer limit) {
            this.m_limit = limit;
        }

        public void visitOffset(Integer offset) {
            this.m_offset = offset;
        }
    }
}

