/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.ObjectNotFoundException;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.dao.AcknowledgmentDao;
import org.opennms.netmgt.dao.hibernate.AbstractDaoHibernate;
import org.opennms.netmgt.model.AckType;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsNotification;

public class AcknowledgmentDaoHibernate
extends AbstractDaoHibernate<OnmsAcknowledgment, Integer>
implements AcknowledgmentDao {
    public AcknowledgmentDaoHibernate() {
        super(OnmsAcknowledgment.class);
    }

    @Override
    public void updateAckable(Acknowledgeable ackable) {
        this.getHibernateTemplate().update((Object)ackable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<Acknowledgeable> findAcknowledgables(OnmsAcknowledgment ack) {
        ArrayList<Acknowledgeable> ackables = new ArrayList<Acknowledgeable>();
        if (ack == null || ack.getAckType() == null) {
            return ackables;
        }
        if (ack.getAckType().equals((Object)AckType.ALARM)) {
            OnmsAlarm alarm = this.findAlarm(ack);
            try {
                if (alarm == null || alarm.getAckId() == null) return ackables;
                ackables.add((Acknowledgeable)alarm);
                List<OnmsNotification> notifs = this.findRelatedNotifications(alarm);
                if (notifs == null) return ackables;
                for (OnmsNotification notif : notifs) {
                    try {
                        if (notif.getAckId() == null) continue;
                        ackables.add((Acknowledgeable)notif);
                    }
                    catch (ObjectNotFoundException e) {
                        LogUtils.warnf((Object)this, (Throwable)e, (String)"found ackables for alarm #%d but ackable was invalid", (Object[])new Object[]{ack.getRefId()});
                    }
                }
                return ackables;
            }
            catch (ObjectNotFoundException e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"unable to find alarm with ID %d", (Object[])new Object[]{ack.getRefId()});
                return ackables;
            }
        }
        if (!ack.getAckType().equals((Object)AckType.NOTIFICATION)) return ackables;
        OnmsNotification notif = this.findNotification(ack);
        try {
            if (notif == null || notif.getAckId() == null) return ackables;
            ackables.add((Acknowledgeable)notif);
            try {
                OnmsAlarm alarm;
                if (notif.getEvent() == null || (alarm = notif.getEvent().getAlarm()) == null) return ackables;
                ackables.add((Acknowledgeable)alarm);
                return ackables;
            }
            catch (ObjectNotFoundException e) {
                LogUtils.warnf((Object)this, (Throwable)e, (String)"unable to find alarm for notification #%d", (Object[])new Object[]{notif.getNotifyId()});
            }
            return ackables;
        }
        catch (ObjectNotFoundException e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"unable to find notification with ID %d", (Object[])new Object[]{ack.getRefId()});
        }
        return ackables;
    }

    private List<OnmsNotification> findRelatedNotifications(OnmsAlarm alarm) {
        String hql = "from OnmsNotification as n where n.event.alarm = ?";
        return this.findObjects(OnmsNotification.class, "from OnmsNotification as n where n.event.alarm = ?", alarm);
    }

    private OnmsAlarm findAlarm(OnmsAcknowledgment ack) {
        try {
            if (ack != null) {
                return (OnmsAlarm)this.getHibernateTemplate().load(OnmsAlarm.class, (Serializable)ack.getRefId());
            }
        }
        catch (Exception e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"unable to find alarm with ID %d", (Object[])new Object[]{ack.getRefId()});
        }
        return null;
    }

    private OnmsNotification findNotification(OnmsAcknowledgment ack) {
        try {
            if (ack != null) {
                return (OnmsNotification)this.getHibernateTemplate().load(OnmsNotification.class, (Serializable)ack.getRefId());
            }
        }
        catch (Exception e) {
            LogUtils.warnf((Object)this, (Throwable)e, (String)"unable to find notification with ID %d", (Object[])new Object[]{ack.getRefId()});
        }
        return null;
    }
}

