/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.util.StringUtils;

public class Index {
    private String m_name;
    private String m_table;
    private String m_using;
    private List<String> m_columns;
    private boolean m_unique;
    private String m_where;
    private static Pattern m_pattern = Pattern.compile("(?i)create(\\s+unique)?\\s+index\\s+(\\S+)\\s+on\\s+(\\S+)(?:\\s+USING\\s+(\\S+))?\\s*\\(([^)]+)\\)(?:\\s+WHERE\\s+(.*?))?\\s*(?:;|$)");

    public Index(String name, String table, String using, List<String> columns, boolean unique, String where) {
        this.m_name = name;
        this.m_table = table;
        this.m_using = using;
        this.m_columns = columns;
        this.m_unique = unique;
        this.m_where = where;
    }

    public static Index findIndexInString(String create) {
        Matcher m = m_pattern.matcher(create.toString());
        if (!m.find()) {
            return null;
        }
        boolean unique = m.group(1) != null;
        String name = m.group(2);
        String table = m.group(3);
        String using = m.group(4);
        String columnList = m.group(5);
        String where = m.group(6);
        String[] columns = columnList.split("\\s*,\\s*");
        return new Index(name, table, using, Arrays.asList(columns), unique, where);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOnDatabase(Connection connection) throws SQLException {
        boolean exists;
        Statement st = connection.createStatement();
        ResultSet rs = null;
        try {
            rs = st.executeQuery("SELECT relname FROM pg_class WHERE relname = '" + this.m_name.toLowerCase() + "'");
            exists = rs.next();
        }
        finally {
            if (rs != null) {
                rs.close();
            }
            st.close();
        }
        return exists;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromDatabase(Connection connection) throws SQLException {
        Statement st = connection.createStatement();
        try {
            st.execute("DROP INDEX " + this.getName());
        }
        finally {
            st.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToDatabase(Connection connection) throws SQLException {
        Statement st = connection.createStatement();
        try {
            st.execute(this.getSql());
        }
        finally {
            st.close();
        }
    }

    public String getSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE ");
        if (this.m_unique) {
            sql.append("UNIQUE ");
        }
        sql.append("INDEX ");
        sql.append(this.m_name);
        sql.append(" ON ");
        sql.append(this.m_table);
        if (this.m_using != null) {
            sql.append(" USING ");
            sql.append(this.m_using);
        }
        sql.append(" ( ");
        sql.append(StringUtils.collectionToDelimitedString(this.m_columns, (String)", "));
        sql.append(" )");
        if (this.m_where != null) {
            sql.append(" WHERE ");
            sql.append(this.m_where);
        }
        return sql.toString();
    }

    public String getName() {
        return this.m_name;
    }

    public String getTable() {
        return this.m_table;
    }

    public boolean isUnique() {
        return this.m_unique;
    }

    public List<String> getColumns() {
        return this.m_columns;
    }

    public String getIndexUniquenessQuery() throws Exception {
        String firstColumn = this.getColumns().get(0);
        String columnList = StringUtils.collectionToDelimitedString(this.getColumns(), (String)", ");
        StringBuffer sql = new StringBuffer();
        sql.append("SELECT * FROM " + this.getTable() + " WHERE ( " + columnList + " ) IN ( SELECT " + columnList + " FROM " + this.getTable() + " GROUP BY " + columnList + " HAVING count(" + firstColumn + ") > 1");
        if (this.m_where != null) {
            sql.append(" AND ( " + this.m_where + " )");
        }
        sql.append(" ORDER BY " + columnList + " ) " + "ORDER BY " + columnList);
        return sql.toString();
    }
}

