/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import com.mchange.v2.c3p0.ComboPooledDataSource;
import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.BaseConnectionFactory;
import org.opennms.netmgt.config.opennmsDataSources.JdbcDataSource;
import org.opennms.netmgt.config.opennmsDataSources.Param;

public class C3P0ConnectionFactory
extends BaseConnectionFactory {
    private ComboPooledDataSource m_pool;

    public C3P0ConnectionFactory(InputStream stream, String dsName) throws MarshalException, ValidationException, PropertyVetoException, SQLException {
        super(stream, dsName);
    }

    public C3P0ConnectionFactory(String configFile, String dsName) throws IOException, MarshalException, ValidationException, PropertyVetoException, SQLException {
        super(configFile, dsName);
    }

    @Override
    protected void initializePool(JdbcDataSource dataSource) throws SQLException {
        this.m_pool = new ComboPooledDataSource();
        this.m_pool.setPassword(dataSource.getPassword());
        this.m_pool.setUser(dataSource.getUserName());
        this.m_pool.setJdbcUrl(dataSource.getUrl());
        try {
            this.m_pool.setDriverClass(dataSource.getClassName());
        }
        catch (PropertyVetoException e) {
            throw new SQLException("Unable to set driver class.", e);
        }
        Properties properties = new Properties();
        for (Param parameter : dataSource.getParamCollection()) {
            properties.put(parameter.getName(), parameter.getValue());
        }
        if (!properties.isEmpty()) {
            this.m_pool.setProperties(properties);
        }
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.m_pool.getConnection();
    }

    @Override
    public String getUrl() {
        return this.m_pool.getJdbcUrl();
    }

    @Override
    public void setUrl(String url) {
        this.m_pool.setJdbcUrl(url);
    }

    @Override
    public String getUser() {
        return this.m_pool.getUser();
    }

    @Override
    public void setUser(String user) {
        this.m_pool.setUser(user);
    }

    @Override
    public DataSource getDataSource() {
        return this.m_pool;
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.m_pool.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.m_pool.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.m_pool.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_pool.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.m_pool.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger not supported");
    }

    @Override
    public void close() throws SQLException {
        super.close();
        LogUtils.infof((Object)this, (String)"Closing C3P0 pool.", (Object[])new Object[0]);
        this.m_pool.close();
    }

    @Override
    public void setIdleTimeout(int idleTimeout) {
        this.m_pool.setMaxIdleTime(idleTimeout);
    }

    @Override
    public void setMinPool(int minPool) {
        LogUtils.debugf((Object)this, (String)"Because of a bug in C3P0, minPool should equal maxPool.  Ignoring.", (Object[])new Object[0]);
    }

    @Override
    public void setMaxPool(int maxPool) {
        this.m_pool.setMinPoolSize(maxPool);
        this.m_pool.setMaxPoolSize(maxPool);
    }

    @Override
    public void setMaxSize(int maxSize) {
        LogUtils.debugf((Object)this, (String)"C3P0 has no equivalent to setMaxSize.  Ignoring.", (Object[])new Object[0]);
    }
}

