/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import java.util.ArrayList;
import junit.framework.Assert;
import org.easymock.EasyMock;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.StorageStrategyService;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.config.datacollection.Parameter;
import org.opennms.netmgt.dao.support.MockCollectionResource;
import org.opennms.netmgt.dao.support.SiblingColumnStorageStrategy;
import org.opennms.netmgt.snmp.SnmpAgentConfig;

public class SiblingColumnStorageStrategyTest {
    private StorageStrategyService service;
    private SiblingColumnStorageStrategy strategy;

    @Before
    public void setUp() throws Exception {
        this.service = (StorageStrategyService)EasyMock.createMock(StorageStrategyService.class);
        SnmpAgentConfig agentConfig = new SnmpAgentConfig(InetAddressUtils.addr((String)"127.0.0.1"));
        agentConfig.setPort(1161);
        EasyMock.expect((Object)this.service.getAgentConfig()).andReturn((Object)agentConfig).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.service});
        this.strategy = new SiblingColumnStorageStrategy();
        this.strategy.setStorageStrategyService(this.service);
    }

    @After
    public void tearDown() throws Exception {
        EasyMock.verify((Object[])new Object[]{this.service});
    }

    @Test
    public void testStrategy() throws Exception {
        this.strategy.setResourceTypeName("hrStorageIndex");
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        params.add(this.createParameter("sibling-column-name", "hrStorageDescr"));
        params.add(this.createParameter("replace-first", "s/^-$/_root_fs/"));
        params.add(this.createParameter("replace-first", "s/^-//"));
        params.add(this.createParameter("replace-all", "s/\\s//"));
        params.add(this.createParameter("replace-all", "s/:\\\\.*//"));
        this.strategy.setParameters(params);
        String parentResource = "1";
        MockCollectionResource resource = new MockCollectionResource(parentResource, "1", "hrStorageIndex");
        resource.getAttribtueMap().put("hrStorageDescr", "/");
        String resourceName = this.strategy.getResourceNameFromIndex((CollectionResource)resource);
        Assert.assertEquals((String)"_root_fs", (String)resourceName);
        resource.setInstance("8");
        resource.getAttribtueMap().put("hrStorageDescr", "Volumes-iDisk");
        Assert.assertEquals((String)"Volumes-iDisk", (String)this.strategy.getResourceNameFromIndex((CollectionResource)resource));
        Assert.assertEquals((String)("1" + File.separator + "hrStorageIndex" + File.separator + "_root_fs"), (String)this.strategy.getRelativePathForAttribute(parentResource, resourceName, null));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBadParameters() throws Exception {
        this.strategy.setResourceTypeName("hrStorageIndex");
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        params.add(this.createParameter("sibling-column-oid", ".1.3.6.1.2.1.25.2.3.1.3"));
        params.add(this.createParameter("replace-first", "s/^-$/_root_fs/"));
        params.add(this.createParameter("replace-first", "s/^-//"));
        params.add(this.createParameter("replace-all", "s/\\s//"));
        params.add(this.createParameter("replace-all", "s/:\\\\.*//"));
        this.strategy.setParameters(params);
    }

    @Test
    public void testMatchIndex() throws Exception {
        this.strategy.setResourceTypeName("macIndex");
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        params.add(this.createParameter("sibling-column-name", "_index"));
        params.add(this.createParameter("replace-first", "s/^(([\\d]{1,3}\\.){8,8}).*$/$1/"));
        params.add(this.createParameter("replace-first", "s/\\.$//"));
        this.strategy.setParameters(params);
        String parentResource = "1";
        MockCollectionResource resource = new MockCollectionResource(parentResource, "0.132.43.51.76.89.2.144.10.1.1.1", "macIndex");
        String resourceName = this.strategy.getResourceNameFromIndex((CollectionResource)resource);
        Assert.assertEquals((String)"0.132.43.51.76.89.2.144", (String)resourceName);
    }

    private Parameter createParameter(String key, String value) {
        Parameter p = new Parameter();
        p.setKey(key);
        p.setValue(value);
        return p;
    }
}

