/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import junit.framework.Assert;
import org.easymock.EasyMock;
import org.junit.Test;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.StorageStrategyService;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.dao.support.HostFileSystemStorageStrategy;
import org.opennms.netmgt.dao.support.MockCollectionResource;
import org.opennms.netmgt.snmp.SnmpAgentConfig;

public class HostFileSystemStorageStrategyTest {
    @Test
    public void testStrategy() throws Exception {
        StorageStrategyService service = (StorageStrategyService)EasyMock.createMock(StorageStrategyService.class);
        SnmpAgentConfig agentConfig = new SnmpAgentConfig(InetAddressUtils.addr((String)"127.0.0.1"));
        agentConfig.setPort(1161);
        EasyMock.expect((Object)service.getAgentConfig()).andReturn((Object)agentConfig).anyTimes();
        EasyMock.replay((Object[])new Object[]{service});
        HostFileSystemStorageStrategy strategy = new HostFileSystemStorageStrategy();
        strategy.setResourceTypeName("hrStorageIndex");
        strategy.setStorageStrategyService(service);
        String parentResource = "1";
        MockCollectionResource resource = new MockCollectionResource(parentResource, "1", "hrStorageIndex");
        resource.getAttribtueMap().put("hrStorageDescr", "/");
        String resourceName = strategy.getResourceNameFromIndex((CollectionResource)resource);
        Assert.assertEquals((String)"_root_fs", (String)resourceName);
        resource.setInstance("8");
        resource.getAttribtueMap().put("hrStorageDescr", "Volumes-iDisk");
        Assert.assertEquals((String)"Volumes-iDisk", (String)strategy.getResourceNameFromIndex((CollectionResource)resource));
        Assert.assertEquals((String)("1" + File.separator + "hrStorageIndex" + File.separator + "_root_fs"), (String)strategy.getRelativePathForAttribute(parentResource, resourceName, null));
        EasyMock.verify((Object[])new Object[]{service});
    }
}

