/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.File;
import junit.framework.Assert;
import org.easymock.EasyMock;
import org.junit.Test;
import org.opennms.netmgt.config.StorageStrategyService;
import org.opennms.netmgt.config.collector.CollectionResource;
import org.opennms.netmgt.dao.support.FrameRelayStorageStrategy;
import org.opennms.netmgt.dao.support.MockCollectionResource;

public class FrameRelayStorageStrategyTest {
    @Test
    public void testStrategy() {
        StorageStrategyService service = (StorageStrategyService)EasyMock.createMock(StorageStrategyService.class);
        EasyMock.expect((Object)service.getSnmpInterfaceLabel(1)).andReturn((Object)"Se0_0").anyTimes();
        EasyMock.expect((Object)service.getSnmpInterfaceLabel(2)).andReturn(null).anyTimes();
        EasyMock.replay((Object[])new Object[]{service});
        FrameRelayStorageStrategy strategy = new FrameRelayStorageStrategy();
        strategy.setResourceTypeName("frCircuitIfIndex");
        strategy.setStorageStrategyService(service);
        String parentResource = "1";
        Assert.assertEquals((String)"Se0_0", (String)strategy.getInterfaceName(parentResource, "1"));
        Assert.assertEquals((String)"2", (String)strategy.getInterfaceName(parentResource, "2"));
        MockCollectionResource resource = new MockCollectionResource(parentResource, "1.100", "frCircuitIfIndex");
        String resourceName = strategy.getResourceNameFromIndex((CollectionResource)resource);
        Assert.assertEquals((String)"Se0_0.100", (String)resourceName);
        resource.setInstance("2.100");
        Assert.assertEquals((String)"2.100", (String)strategy.getResourceNameFromIndex((CollectionResource)resource));
        Assert.assertEquals((String)("1" + File.separator + "frCircuitIfIndex" + File.separator + "Se0_0.100"), (String)strategy.getRelativePathForAttribute(parentResource, resourceName, null));
        EasyMock.verify((Object[])new Object[]{service});
    }
}

