/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.xml.MarshallingResourceFailureException;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.LocationMonitorDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.hibernate.LocationMonitorDaoHibernate;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.PollStatus;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.ThrowableAnticipator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class LocationMonitorDaoHibernateTest {
    @Autowired
    private LocationMonitorDao m_locationMonitorDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;

    @Test
    @Transactional
    public void testSaveLocationMonitor() {
        HashMap<String, String> pollerDetails = new HashMap<String, String>();
        pollerDetails.put("os.name", "BogOS");
        pollerDetails.put("os.version", "sqrt(-1)");
        OnmsLocationMonitor mon = new OnmsLocationMonitor();
        mon.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        mon.setLastCheckInTime(new Date());
        mon.setDetails(pollerDetails);
        mon.setDefinitionName("RDU");
        this.m_locationMonitorDao.save((Object)mon);
        this.m_locationMonitorDao.flush();
        this.m_locationMonitorDao.clear();
        OnmsLocationMonitor mon2 = (OnmsLocationMonitor)this.m_locationMonitorDao.get((Serializable)mon.getId());
        Assert.assertNotSame((Object)mon, (Object)mon2);
        Assert.assertEquals((Object)mon.getStatus(), (Object)mon2.getStatus());
        Assert.assertEquals((Object)mon.getLastCheckInTime(), (Object)mon2.getLastCheckInTime());
        Assert.assertEquals((Object)mon.getDefinitionName(), (Object)mon2.getDefinitionName());
        Assert.assertEquals((Object)mon.getDetails(), (Object)mon2.getDetails());
    }

    @Test
    @Transactional
    public void testSetConfigResourceProduction() throws FileNotFoundException {
        ((LocationMonitorDaoHibernate)this.m_locationMonitorDao).setMonitoringLocationConfigResource((Resource)new InputStreamResource(ConfigurationTestUtils.getInputStreamForConfigFile((String)"monitoring-locations.xml")));
    }

    @Test
    @Transactional
    public void testSetConfigResourceExample() throws FileNotFoundException {
        ((LocationMonitorDaoHibernate)this.m_locationMonitorDao).setMonitoringLocationConfigResource((Resource)new InputStreamResource(ConfigurationTestUtils.getInputStreamForConfigFile((String)"examples/monitoring-locations.xml")));
    }

    @Test
    @Transactional
    public void testSetConfigResourceNoLocations() throws FileNotFoundException {
        ((LocationMonitorDaoHibernate)this.m_locationMonitorDao).setMonitoringLocationConfigResource((Resource)new FileSystemResource("src/test/resources/monitoring-locations-no-locations.xml"));
    }

    @Test
    @Transactional
    public void testBogusConfig() {
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new MarshallingResourceFailureException("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            ((LocationMonitorDaoHibernate)this.m_locationMonitorDao).setMonitoringLocationConfigResource((Resource)new FileSystemResource("some bogus filename"));
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    @Transactional
    public void testFindMonitoringLocationDefinitionNull() throws FileNotFoundException {
        ((LocationMonitorDaoHibernate)this.m_locationMonitorDao).setMonitoringLocationConfigResource((Resource)new InputStreamResource(ConfigurationTestUtils.getInputStreamForConfigFile((String)"monitoring-locations.xml")));
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new IllegalArgumentException("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            this.m_locationMonitorDao.findMonitoringLocationDefinition(null);
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    @Test
    @Transactional
    public void testFindMonitoringLocationDefinitionBogus() throws FileNotFoundException {
        ((LocationMonitorDaoHibernate)this.m_locationMonitorDao).setMonitoringLocationConfigResource((Resource)new InputStreamResource(ConfigurationTestUtils.getInputStreamForConfigFile((String)"monitoring-locations.xml")));
        Assert.assertNull((String)"should not have found monitoring location definition--should have returned null", (Object)this.m_locationMonitorDao.findMonitoringLocationDefinition("bogus"));
    }

    @Test
    @Transactional
    public void testFindStatusChangesForNodeForUniqueMonitorAndInterface() {
        this.m_databasePopulator.populateDatabase();
        OnmsLocationMonitor monitor1 = new OnmsLocationMonitor();
        monitor1.setDefinitionName("Outer Space");
        this.m_locationMonitorDao.save((Object)monitor1);
        OnmsLocationMonitor monitor2 = new OnmsLocationMonitor();
        monitor2.setDefinitionName("Really Outer Space");
        this.m_locationMonitorDao.save((Object)monitor2);
        OnmsNode node1 = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(1));
        Assert.assertNotNull((String)"node 1 should not be null", (Object)node1);
        OnmsNode node2 = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(2));
        Assert.assertNotNull((String)"node 2 should not be null", (Object)node2);
        this.addStatusChangesForMonitorAndService(monitor1, node1.getIpInterfaceByIpAddress("192.168.1.1").getMonitoredServices());
        this.addStatusChangesForMonitorAndService(monitor1, node1.getIpInterfaceByIpAddress("192.168.1.2").getMonitoredServices());
        this.addStatusChangesForMonitorAndService(monitor2, node1.getIpInterfaceByIpAddress("192.168.1.1").getMonitoredServices());
        this.addStatusChangesForMonitorAndService(monitor1, node1.getIpInterfaceByIpAddress("fe80::aaaa:bbbb:cccc:dddd%5").getMonitoredServices());
        this.addStatusChangesForMonitorAndService(monitor1, node2.getIpInterfaceByIpAddress("192.168.2.1").getMonitoredServices());
        this.addStatusChangesForMonitorAndService(monitor1, node1.getIpInterfaceByIpAddress("192.168.1.1").getMonitoredServices());
        Collection statuses = this.m_locationMonitorDao.findStatusChangesForNodeForUniqueMonitorAndInterface(1);
        Assert.assertEquals((String)"number of statuses found", (long)4L, (long)statuses.size());
    }

    private void addStatusChangesForMonitorAndService(OnmsLocationMonitor monitor, Set<OnmsMonitoredService> services) {
        for (OnmsMonitoredService service : services) {
            OnmsLocationSpecificStatus status = new OnmsLocationSpecificStatus();
            status.setLocationMonitor(monitor);
            status.setMonitoredService(service);
            status.setPollResult(PollStatus.available());
            this.m_locationMonitorDao.saveStatusChange(status);
        }
    }
}

