/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db;

import junit.framework.AssertionFailedError;
import org.opennms.netmgt.dao.db.PopulatedTemporaryDatabaseTestCase;
import org.opennms.test.ThrowableAnticipator;

public class TriggerSetSnmpInterfaceKeysOnUpdateTest
extends PopulatedTemporaryDatabaseTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
    }

    public void testSameSnmpInterfaceIdDifferentNodeId() {
        this.executeSQL("INSERT INTO snmpInterface (id, nodeId, snmpIfIndex) VALUES ( 1, 1, 1 )");
        this.executeSQL("INSERT INTO ipInterface (id, nodeId, ipAddr, ifIndex, snmpInterfaceId) VALUES ( 1, 1, '1.1.1.1', 1, 1 )");
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 2, now() )");
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"snmpInterface update count", (int)1, (int)this.jdbcTemplate.update("UPDATE snmpInterface SET nodeId = 2 WHERE nodeID = 1 AND snmpIfIndex = 1", new Object[0]));
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"snmpIfIndex after update", (int)1, (int)this.jdbcTemplate.queryForInt("SELECT snmpIfIndex FROM snmpInterface", new Object[0]));
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"snmpInterfaceId before update", (int)1, (int)this.jdbcTemplate.queryForInt("SELECT snmpInterfaceId FROM ipInterface", new Object[0]));
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"ipInterface update count", (int)1, (int)this.jdbcTemplate.update("UPDATE ipInterface SET nodeId = 2 WHERE nodeID = 1 AND ipAddr = '1.1.1.1'", new Object[0]));
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"snmpInterfaceId after update", (int)1, (int)this.jdbcTemplate.queryForInt("SELECT snmpInterfaceId FROM ipInterface", new Object[0]));
    }

    public void testSameSnmpInterfaceIdDifferentIfIndex() {
        this.executeSQL("INSERT INTO snmpInterface (id, nodeId, snmpIfIndex) VALUES ( 1, 1, 1 )");
        this.executeSQL("INSERT INTO ipInterface (id, nodeId, ipAddr, ifIndex, snmpInterfaceId) VALUES ( 1, 1, '1.1.1.1', 1, 1 )");
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"snmpInterface update count", (int)1, (int)this.jdbcTemplate.update("UPDATE snmpInterface SET snmpIfIndex = 2 WHERE nodeID = 1 AND snmpIfIndex = 1", new Object[0]));
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"snmpIfIndex after update", (int)2, (int)this.jdbcTemplate.queryForInt("SELECT snmpIfIndex FROM snmpInterface", new Object[0]));
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"snmpInterfaceId before update", (int)1, (int)this.jdbcTemplate.queryForInt("SELECT snmpInterfaceId FROM ipInterface", new Object[0]));
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"ipInterface update count", (int)1, (int)this.jdbcTemplate.update("UPDATE ipInterface SET ifIndex = 2 WHERE nodeID = 1 AND ipAddr = '1.1.1.1'", new Object[0]));
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"snmpInterfaceId after update", (int)1, (int)this.jdbcTemplate.queryForInt("SELECT snmpInterfaceId FROM ipInterface", new Object[0]));
    }

    public void testSameSnmpInterfaceIdDifferentIfIndexNull() {
        this.executeSQL("INSERT INTO snmpInterface (nodeId, snmpIfIndex) VALUES ( 1, 1 )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex, snmpInterfaceId) VALUES ( 1, '1.1.1.1', 1, 1 )");
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"snmpInterface update count", (int)1, (int)this.jdbcTemplate.update("UPDATE snmpInterface SET snmpIfIndex = 2 WHERE nodeID = 1 AND snmpIfIndex = 1", new Object[0]));
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"snmpIfIndex after update", (int)2, (int)this.jdbcTemplate.queryForInt("SELECT snmpIfIndex FROM snmpInterface", new Object[0]));
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"snmpInterfaceId before update", (int)1, (int)this.jdbcTemplate.queryForInt("SELECT snmpInterfaceId FROM ipInterface", new Object[0]));
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"ipInterface update count", (int)1, (int)this.jdbcTemplate.update("UPDATE ipInterface SET ifIndex = 2 WHERE nodeID = 1 AND ipAddr = '1.1.1.1'", new Object[0]));
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"snmpInterfaceId after update", (int)1, (int)this.jdbcTemplate.queryForInt("SELECT snmpInterfaceId FROM ipInterface", new Object[0]));
    }

    public void testSetIpInterfaceIfIndexLikeCapsdDoes() throws Exception {
        this.executeSQL("INSERT INTO ipInterface (id, nodeId, ipAddr, ifIndex) VALUES ( 1, 1, '1.1.1.1', null )");
        this.executeSQL("INSERT INTO snmpInterface (id, nodeId, snmpIfIndex) VALUES ( 1, 1, 1)");
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"ifIndex", null, (Object)this.jdbcTemplate.queryForObject("SELECT ifIndex FROM ipinterface", Integer.class, new Object[0]));
        this.executeSQL("UPDATE ipInterface SET ifIndex = 1 WHERE nodeID = 1 AND ipAddr = '1.1.1.1'");
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"ifIndex", (int)1, (int)this.jdbcTemplate.queryForInt("SELECT ifIndex FROM ipinterface", new Object[0]));
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"snmpInterfaceId", (int)1, (int)this.jdbcTemplate.queryForInt("SELECT snmpInterfaceId FROM ipInterface WHERE nodeID = ?", new Object[]{1}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetIpInterfaceIfIndexLikeCapsdDoesBadIfIndex() throws Exception {
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.1.1.1', null )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, snmpIfIndex) VALUES ( 1, 1)");
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"ifIndex", null, (Object)this.jdbcTemplate.queryForObject("SELECT ifIndex FROM ipinterface", Integer.class, new Object[0]));
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new AssertionFailedError("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            this.executeSQL("UPDATE ipInterface SET ifIndex = 2 WHERE nodeID = 1 AND ipAddr = '1.1.1.1'");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        finally {
            ta.verifyAnticipated();
        }
    }

    public void testSetIpInterfaceIfIndexLikeCapsdButOppositeOrder() throws Exception {
        this.executeSQL("INSERT INTO snmpInterface (nodeId, snmpIfIndex) VALUES ( 1, 1)");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.1.1.1', 1 )");
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"snmpInterfaceId", (int)1, (int)this.jdbcTemplate.queryForInt("SELECT snmpInterfaceId FROM ipInterface WHERE nodeID = ?", new Object[]{1}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetIpInterfaceIfIndexLikeCapsdButOppositeOrderUpdateWithBadIfIndex() throws Exception {
        this.executeSQL("INSERT INTO snmpInterface (nodeId, snmpIfIndex) VALUES ( 1, 1)");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.1.1.1', 1 )");
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"snmpInterfaceId", (int)1, (int)this.jdbcTemplate.queryForInt("SELECT snmpInterfaceId FROM ipInterface WHERE nodeID = ?", new Object[]{1}));
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new AssertionFailedError("*** ThrowableAnticipator ignore Throwable.getMessage() ***"));
        try {
            this.executeSQL("UPDATE ipInterface SET ifIndex = 2 WHERE nodeID = 1 AND ipAddr = '1.1.1.1'");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        finally {
            ta.verifyAnticipated();
        }
    }

    public void testSetIpInterfaceToNewNodeWithNodeSnmpInterfaces() throws Exception {
        this.executeSQL("INSERT INTO ipInterface (id, nodeId, ipAddr) VALUES ( 1, 1, '1.1.1.1')");
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 2, now() )");
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertNull((String)"snmpInterfaceId after update", (Object)this.jdbcTemplate.queryForObject("SELECT snmpInterfaceId FROM ipInterface", Object.class, new Object[0]));
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"ipInterface update count", (int)1, (int)this.jdbcTemplate.update("UPDATE ipInterface SET nodeId = 2 WHERE nodeID = 1 AND ipAddr = '1.1.1.1'", new Object[0]));
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertNull((String)"snmpInterfaceId after update", (Object)this.jdbcTemplate.queryForObject("SELECT snmpInterfaceId FROM ipInterface", Object.class, new Object[0]));
    }

    public void testBugNMS1881() {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 100, now() )");
        this.executeSQL("INSERT INTO snmpInterface (id, nodeId, snmpIfIndex) VALUES ( 100, 100, 1 )");
        this.executeSQL("INSERT INTO ipInterface (id, nodeId, ipAddr, ifIndex) VALUES ( 100, 100, '1.1.1.1', 1)");
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"snmpInterfaceId after creation of new node", (int)100, (int)this.jdbcTemplate.queryForInt("SELECT snmpInterfaceId FROM ipInterface WHERE id = 100", new Object[0]));
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"deleted interface count", (int)1, (int)this.jdbcTemplate.update("UPDATE ipInterface SET ismanaged = 'D' WHERE id = 100", new Object[0]));
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"deleted node count", (int)1, (int)this.jdbcTemplate.update("UPDATE node SET nodetype = 'D' WHERE nodeid = 100", new Object[0]));
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 101, now() )");
        this.executeSQL("INSERT INTO snmpInterface (id, nodeId, snmpIfIndex) VALUES ( 101, 101, 1 )");
        this.executeSQL("INSERT INTO ipInterface (id, nodeId, ipAddr, ifIndex) VALUES ( 101, 101, '1.1.1.1', 1)");
        TriggerSetSnmpInterfaceKeysOnUpdateTest.assertEquals((String)"snmpInterfaceId after creation of a second new node", (int)101, (int)this.jdbcTemplate.queryForInt("SELECT snmpInterfaceId FROM ipInterface WHERE id = 101", new Object[0]));
    }
}

