/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db;

import java.lang.reflect.UndeclaredThrowableException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import javax.sql.DataSource;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.opennms.netmgt.dao.db.SimpleDataSource;
import org.opennms.netmgt.dao.db.TemporaryDatabase;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class TemporaryDatabaseTestCase
extends TestCase {
    protected SimpleJdbcTemplate jdbcTemplate;
    private static final String TEST_DB_NAME_PREFIX = "opennms_test_";
    private static final String RUN_PROPERTY = "mock.rundbtests";
    private static final String LEAVE_PROPERTY = "mock.leaveDatabase";
    private static final String LEAVE_ON_FAILURE_PROPERTY = "mock.leaveDatabaseOnFailure";
    private static final String DRIVER_PROPERTY = "mock.db.driver";
    private static final String URL_PROPERTY = "mock.db.url";
    private static final String ADMIN_USER_PROPERTY = "mock.db.adminUser";
    private static final String ADMIN_PASSWORD_PROPERTY = "mock.db.adminPassword";
    private static final String DEFAULT_DRIVER = "org.postgresql.Driver";
    private static final String DEFAULT_URL = "jdbc:postgresql://localhost:5432/";
    private static final String DEFAULT_ADMIN_USER = "postgres";
    private static final String DEFAULT_ADMIN_PASSWORD = "";
    private static final int MAX_DATABASE_DROP_ATTEMPTS = 10;
    private String m_testDatabase;
    private boolean m_leaveDatabase = false;
    private boolean m_leaveDatabaseOnFailure = false;
    private Throwable m_throwable = null;
    private boolean m_destroyed = false;
    private String m_driver;
    private String m_url;
    private String m_adminUser;
    private String m_adminPassword;
    private DataSource m_dataSource;
    private DataSource m_adminDataSource;

    public TemporaryDatabaseTestCase() {
        this(System.getProperty(DRIVER_PROPERTY, DEFAULT_DRIVER), System.getProperty(URL_PROPERTY, DEFAULT_URL), System.getProperty(ADMIN_USER_PROPERTY, DEFAULT_ADMIN_USER), System.getProperty(ADMIN_PASSWORD_PROPERTY, DEFAULT_ADMIN_PASSWORD));
    }

    public TemporaryDatabaseTestCase(String driver, String url, String adminUser, String adminPassword) {
        this.m_driver = driver;
        this.m_url = url;
        this.m_adminUser = adminUser;
        this.m_adminPassword = adminPassword;
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.setTestFailureThrowable(null);
        if (!TemporaryDatabaseTestCase.isEnabled()) {
            return;
        }
        this.m_leaveDatabase = "true".equals(System.getProperty(LEAVE_PROPERTY));
        this.m_leaveDatabaseOnFailure = "true".equals(System.getProperty(LEAVE_ON_FAILURE_PROPERTY));
        this.setTestDatabase(this.getTestDatabaseName());
        this.setDataSource((DataSource)new SimpleDataSource(this.m_driver, this.m_url + this.getTestDatabase(), this.m_adminUser, this.m_adminPassword));
        this.setAdminDataSource((DataSource)new SimpleDataSource(this.m_driver, this.m_url + "template1", this.m_adminUser, this.m_adminPassword));
        this.createTestDatabase();
        Connection connection = this.getConnection();
        connection.close();
    }

    private void setTestDatabase(String testDatabase) {
        this.m_testDatabase = testDatabase;
    }

    protected void runTest() throws Throwable {
        if (!TemporaryDatabaseTestCase.isEnabled()) {
            TemporaryDatabaseTestCase.notifyTestDisabled(this.getName());
            return;
        }
        try {
            super.runTest();
        }
        catch (Throwable t) {
            this.setTestFailureThrowable(t);
            throw t;
        }
    }

    protected void tearDown() throws Exception {
        if (TemporaryDatabaseTestCase.isEnabled()) {
            try {
                this.destroyTestDatabase();
            }
            catch (Throwable t) {
                if (this.hasTestFailed()) {
                    throw new TestFailureAndTearDownErrorException(this.getTestFailureThrowable(), t);
                }
                if (t instanceof Exception) {
                    throw (Exception)t;
                }
                throw new UndeclaredThrowableException(t);
            }
        }
        super.tearDown();
    }

    public void testNothing() {
    }

    protected String getTestDatabaseName() {
        return TEST_DB_NAME_PREFIX + System.currentTimeMillis();
    }

    public String getTestDatabase() {
        return this.m_testDatabase;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
        this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    private void setAdminDataSource(DataSource dataSource) {
        this.m_adminDataSource = dataSource;
    }

    protected DataSource getAdminDataSource() {
        return this.m_adminDataSource;
    }

    public Connection getConnection() throws SQLException {
        return this.getDataSource().getConnection();
    }

    public String getDriver() {
        return this.m_driver;
    }

    public String getUrl() {
        return this.m_url;
    }

    public String getAdminUser() {
        return this.m_adminUser;
    }

    public String getAdminPassword() {
        return this.m_adminPassword;
    }

    public void setTestFailureThrowable(Throwable t) {
        this.m_throwable = t;
    }

    public Throwable getTestFailureThrowable() {
        return this.m_throwable;
    }

    public boolean hasTestFailed() {
        return this.m_throwable != null;
    }

    public static boolean isEnabled() {
        String property = System.getProperty(RUN_PROPERTY, "true");
        return "true".equals(property);
    }

    public static void notifyTestDisabled(String testMethodName) {
        System.out.println("Test '" + testMethodName + "' disabled.  Set '" + RUN_PROPERTY + "' property from 'false' to 'true' to enable.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestDatabase() throws Exception {
        Connection adminConnection = this.getAdminDataSource().getConnection();
        Statement st = null;
        try {
            st = adminConnection.createStatement();
            st.execute("CREATE DATABASE " + this.getTestDatabase() + " WITH ENCODING='UNICODE'");
        }
        finally {
            if (st != null) {
                st.close();
            }
            adminConnection.close();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    TemporaryDatabaseTestCase.this.destroyTestDatabase();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyTestDatabase() throws Exception {
        if (this.m_destroyed) {
            return;
        }
        if (this.m_leaveDatabase || this.m_leaveDatabaseOnFailure && this.hasTestFailed()) {
            System.err.println("Not dropping database '" + this.getTestDatabase() + "' for test '" + this.getName() + "'");
            return;
        }
        Thread.sleep(100L);
        Connection adminConnection = this.getAdminDataSource().getConnection();
        try {
            for (int dropAttempt = 0; dropAttempt < 10; ++dropAttempt) {
                Statement st = null;
                try {
                    st = adminConnection.createStatement();
                    st.execute("DROP DATABASE " + this.getTestDatabase());
                    break;
                }
                catch (SQLException e) {
                    if (dropAttempt + 1 >= 10) {
                        String message = "Failed to drop test database on last attempt " + (dropAttempt + 1) + ": " + e;
                        System.err.println(new Date().toString() + ": " + message);
                        TemporaryDatabase.dumpThreads();
                        SQLException newException = new SQLException(message);
                        newException.initCause(e);
                        throw newException;
                    }
                    System.err.println(new Date().toString() + ": Failed to drop test database on attempt " + (dropAttempt + 1) + ": " + e);
                    Thread.sleep(1000L);
                    continue;
                }
                finally {
                    if (st != null) {
                        st.close();
                        st = null;
                    }
                }
            }
        }
        finally {
            try {
                adminConnection.close();
            }
            catch (SQLException e) {
                System.err.println("Error closing administrative database connection after attempting to drop test database");
                e.printStackTrace();
            }
            Thread.sleep(100L);
        }
        this.m_destroyed = true;
    }

    public void executeSQL(String command) {
        this.executeSQL(new String[]{command});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeSQL(String[] commands) {
        Connection connection = null;
        Statement st = null;
        try {
            connection = this.getConnection();
        }
        catch (Throwable e) {
            this.fail("Could not get connection", e);
        }
        try {
            try {
                st = connection.createStatement();
            }
            catch (SQLException e) {
                this.fail("Could not create statement", e);
            }
            for (String command : commands) {
                try {
                    st.execute(command);
                }
                catch (SQLException e) {
                    this.fail("Could not execute statement: '" + command + "'", e);
                }
            }
        }
        finally {
            if (st != null) {
                try {
                    st.close();
                }
                catch (SQLException e) {
                    System.err.println("Could not close statement in executeSQL");
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    System.err.println("Could not close connection in executeSQL");
                    e.printStackTrace();
                }
            }
        }
    }

    public void fail(String message, Throwable t) throws AssertionFailedError {
        AssertionFailedError e = new AssertionFailedError(message + ": " + t.getMessage());
        e.initCause(t);
        throw e;
    }

    public SimpleJdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public class TestFailureAndTearDownErrorException
    extends Exception {
        private static final long serialVersionUID = -5664844942506660064L;
        private Throwable m_tearDownError;

        public TestFailureAndTearDownErrorException(Throwable testFailure, Throwable tearDownError) {
            super(testFailure);
            this.m_tearDownError = tearDownError;
        }

        @Override
        public String toString() {
            return super.toString() + "\nAlso received error on tearDown: " + this.m_tearDownError.toString();
        }
    }
}

