/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db;

import com.mchange.v2.c3p0.DataSources;
import com.mchange.v2.c3p0.PooledDataSource;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.sql.DataSource;
import org.junit.Test;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.DataSourceFactory;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.db.TemporaryDatabase;
import org.opennms.netmgt.dao.db.TemporaryDatabaseAware;
import org.springframework.jdbc.datasource.DelegatingDataSource;
import org.springframework.jdbc.datasource.LazyConnectionDataSourceProxy;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;
import org.springframework.util.Assert;

public class TemporaryDatabaseExecutionListener
extends AbstractTestExecutionListener {
    private boolean m_createNewDatabases = false;
    private TemporaryDatabase m_database;
    private final Queue<TemporaryDatabase> m_databases = new ConcurrentLinkedQueue<TemporaryDatabase>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTestMethod(TestContext testContext) throws Exception {
        DataSource dataSource;
        TemporaryDatabase tempDb;
        System.err.println(String.format("TemporaryDatabaseExecutionListener.afterTestMethod(%s)", testContext));
        JUnitTemporaryDatabase jtd = TemporaryDatabaseExecutionListener.findAnnotation(testContext);
        if (jtd == null) {
            return;
        }
        PooledDataSource pds = (PooledDataSource)testContext.getAttribute("org.opennms.netmgt.dao.db.TemporaryDatabaseExecutionListener.pooledDataSource");
        if (pds != null) {
            pds.hardReset();
        }
        try {
            if (this.m_createNewDatabases && (tempDb = TemporaryDatabaseExecutionListener.findTemporaryDatabase(dataSource = DataSourceFactory.getInstance())) != null) {
                tempDb.drop();
            }
        }
        finally {
            if (jtd.dirtiesContext()) {
                testContext.markApplicationContextDirty();
                testContext.setAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE, (Object)Boolean.TRUE);
            } else {
                dataSource = DataSourceFactory.getInstance();
                tempDb = TemporaryDatabaseExecutionListener.findTemporaryDatabase(dataSource);
                if (tempDb != this.m_databases.peek()) {
                    testContext.markApplicationContextDirty();
                    testContext.setAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE, (Object)Boolean.TRUE);
                }
            }
        }
    }

    private static TemporaryDatabase findTemporaryDatabase(DataSource dataSource) {
        if (dataSource instanceof TemporaryDatabase) {
            return (TemporaryDatabase)dataSource;
        }
        if (dataSource instanceof DelegatingDataSource) {
            return TemporaryDatabaseExecutionListener.findTemporaryDatabase(((DelegatingDataSource)dataSource).getTargetDataSource());
        }
        return null;
    }

    private static JUnitTemporaryDatabase findAnnotation(TestContext testContext) {
        JUnitTemporaryDatabase jtd = null;
        Method testMethod = testContext.getTestMethod();
        if (testMethod != null) {
            jtd = testMethod.getAnnotation(JUnitTemporaryDatabase.class);
        }
        if (jtd == null) {
            Class testClass = testContext.getTestClass();
            jtd = testClass.getAnnotation(JUnitTemporaryDatabase.class);
        }
        return jtd;
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        System.err.println(String.format("TemporaryDatabaseExecutionListener.beforeTestMethod(%s)", testContext));
        if (testContext.getTestInstance() instanceof TemporaryDatabaseAware) {
            System.err.println("injecting TemporaryDatabase into TemporaryDatabaseAware test: " + testContext.getTestInstance().getClass().getSimpleName() + "." + testContext.getTestMethod().getName());
            this.injectTemporaryDatabase(testContext);
        }
    }

    private void injectTemporaryDatabase(TestContext testContext) {
        ((TemporaryDatabaseAware)testContext.getTestInstance()).setTemporaryDatabase(this.m_database);
    }

    public void beforeTestClass(TestContext testContext) throws Exception {
        Future<TemporaryDatabase> classDs;
        ExecutorService pool = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        JUnitTemporaryDatabase classJtd = testContext.getTestClass().getAnnotation(JUnitTemporaryDatabase.class);
        if (classJtd != null) {
            classDs = pool.submit(new CreateNewDatabaseCallable(classJtd));
            if (!classJtd.reuseDatabase()) {
                this.m_createNewDatabases = true;
            }
        } else {
            classDs = null;
        }
        ArrayList<Future<TemporaryDatabase>> futures = new ArrayList<Future<TemporaryDatabase>>();
        for (Method method : testContext.getTestClass().getMethods()) {
            Future<TemporaryDatabase> submit;
            boolean methodHasTest;
            if (method == null) continue;
            JUnitTemporaryDatabase methodJtd = method.getAnnotation(JUnitTemporaryDatabase.class);
            boolean bl = methodHasTest = method.getAnnotation(Test.class) != null;
            if (!methodHasTest) continue;
            if (methodJtd != null) {
                submit = pool.submit(new CreateNewDatabaseCallable(methodJtd));
                Assert.notNull(submit, (String)("pool.submit(new CreateNewDatabaseCallable(methodJtd = " + methodJtd + ")"));
                futures.add(submit);
                continue;
            }
            if (classJtd == null) continue;
            if (this.m_createNewDatabases) {
                submit = pool.submit(new CreateNewDatabaseCallable(classJtd));
                Assert.notNull(submit, (String)("pool.submit(new CreateNewDatabaseCallable(classJtd = " + classJtd + ")"));
                futures.add(submit);
                continue;
            }
            Assert.notNull(classDs, (String)"classDs");
            futures.add(classDs);
        }
        for (Future future : futures) {
            this.m_databases.add((TemporaryDatabase)future.get());
        }
    }

    public void prepareTestInstance(TestContext testContext) throws Exception {
        System.err.println(String.format("TemporaryDatabaseExecutionListener.prepareTestInstance(%s)", testContext));
        JUnitTemporaryDatabase jtd = TemporaryDatabaseExecutionListener.findAnnotation(testContext);
        if (jtd == null) {
            return;
        }
        this.m_database = this.m_databases.remove();
        final PooledDataSource pooledDataSource = (PooledDataSource)DataSources.pooledDataSource((DataSource)this.m_database);
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    pooledDataSource.close();
                }
                catch (Throwable t) {
                    LogUtils.debugf((Object)this, (Throwable)t, (String)"failed to close pooled data source", (Object[])new Object[0]);
                }
            }
        });
        LazyConnectionDataSourceProxy proxy = new LazyConnectionDataSourceProxy((DataSource)pooledDataSource);
        DataSourceFactory.setInstance((DataSource)proxy);
        testContext.setAttribute("org.opennms.netmgt.dao.db.TemporaryDatabaseExecutionListener.pooledDataSource", (Object)pooledDataSource);
        System.err.println(String.format("TemporaryDatabaseExecutionListener.prepareTestInstance(%s) prepared db %s", testContext, this.m_database.toString()));
        System.err.println("Temporary Database Name: " + this.m_database.getTestDatabase());
    }

    private static TemporaryDatabase createNewDatabase(JUnitTemporaryDatabase jtd) throws Exception {
        boolean useExisting = false;
        if (jtd.useExistingDatabase() != null) {
            useExisting = !jtd.useExistingDatabase().equals("");
        }
        String dbName = useExisting ? jtd.useExistingDatabase() : TemporaryDatabaseExecutionListener.getDatabaseName(jtd);
        TemporaryDatabase retval = jtd.tempDbClass().getConstructor(String.class, Boolean.TYPE).newInstance(dbName, useExisting);
        retval.setPopulateSchema(jtd.createSchema() && !useExisting);
        retval.create();
        return retval;
    }

    private static String getDatabaseName(Object hashMe) {
        return String.format("opennms_test_%s_%s", System.nanoTime(), Math.abs(hashMe.hashCode()));
    }

    private static class CreateNewDatabaseCallable
    implements Callable<TemporaryDatabase> {
        private final JUnitTemporaryDatabase m_jtd;

        public CreateNewDatabaseCallable(JUnitTemporaryDatabase jtd) {
            this.m_jtd = jtd;
        }

        @Override
        public TemporaryDatabase call() throws Exception {
            return TemporaryDatabaseExecutionListener.createNewDatabase(this.m_jtd);
        }
    }
}

