/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Statement;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.opennms.netmgt.dao.db.InstallerDb;
import org.opennms.netmgt.dao.db.SimpleDataSource;
import org.opennms.test.ConfigurationTestUtils;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowCountCallbackHandler;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.util.StringUtils;

public class TemporaryDatabase
implements DataSource {
    private static final String TEST_DB_NAME_PREFIX = "opennms_test_";
    public static final String DRIVER_PROPERTY = "mock.db.driver";
    public static final String URL_PROPERTY = "mock.db.url";
    public static final String ADMIN_USER_PROPERTY = "mock.db.adminUser";
    public static final String ADMIN_PASSWORD_PROPERTY = "mock.db.adminPassword";
    public static final String DEFAULT_DRIVER = "org.postgresql.Driver";
    public static final String DEFAULT_URL = "jdbc:postgresql://localhost:5432/";
    public static final String DEFAULT_ADMIN_USER = "postgres";
    public static final String DEFAULT_ADMIN_PASSWORD = "";
    private static final int MAX_DATABASE_DROP_ATTEMPTS = 10;
    private static final Object TEMPLATE1_MUTEX = new Object();
    private final String m_testDatabase;
    private final String m_driver;
    private final String m_url;
    private final String m_adminUser;
    private final String m_adminPassword;
    private final boolean m_useExisting;
    private DataSource m_dataSource;
    private DataSource m_adminDataSource;
    private InstallerDb m_installerDb;
    private ByteArrayOutputStream m_outputStream;
    private boolean m_setupIpLike = true;
    private boolean m_populateSchema = false;
    private boolean m_destroyed = false;
    private SimpleJdbcTemplate m_jdbcTemplate;

    public TemporaryDatabase() throws Exception {
        this(TEST_DB_NAME_PREFIX + System.currentTimeMillis());
    }

    public TemporaryDatabase(String testDatabase) throws Exception {
        this(testDatabase, false);
    }

    public TemporaryDatabase(String testDatabase, boolean useExisting) throws Exception {
        this(testDatabase, System.getProperty(DRIVER_PROPERTY, DEFAULT_DRIVER), System.getProperty(URL_PROPERTY, DEFAULT_URL), System.getProperty(ADMIN_USER_PROPERTY, DEFAULT_ADMIN_USER), System.getProperty(ADMIN_PASSWORD_PROPERTY, DEFAULT_ADMIN_PASSWORD), useExisting);
    }

    public TemporaryDatabase(String testDatabase, String driver, String url, String adminUser, String adminPassword) throws Exception {
        this(testDatabase, driver, url, adminUser, adminPassword, false);
    }

    public TemporaryDatabase(String testDatabase, String driver, String url, String adminUser, String adminPassword, boolean useExisting) throws Exception {
        this.m_testDatabase = testDatabase;
        this.m_driver = driver;
        this.m_url = url;
        this.m_adminUser = adminUser;
        this.m_adminPassword = adminPassword;
        this.m_useExisting = useExisting;
    }

    public void setPopulateSchema(boolean populateSchema) {
        this.m_populateSchema = populateSchema;
    }

    public void create() throws Exception {
        this.setupDatabase();
        if (this.m_populateSchema) {
            this.initializeDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDatabase() throws Exception {
        this.m_installerDb = new InstallerDb();
        try {
            this.resetOutputStream();
            this.m_installerDb.setDatabaseName(this.getTestDatabase());
            this.m_installerDb.setDataSource(this.getDataSource());
            this.m_installerDb.setAdminDataSource(this.getAdminDataSource());
            this.m_installerDb.setPostgresOpennmsUser(this.m_adminUser);
            this.m_installerDb.setCreateSqlLocation(this.getCreateSqlLocation());
            this.m_installerDb.setStoredProcedureDirectory(this.getStoredProcDirectory());
            this.m_installerDb.readTables();
            this.m_installerDb.createSequences();
            this.m_installerDb.updatePlPgsql();
            this.m_installerDb.addStoredProcedures();
            if (this.isSetupIpLike() && !this.m_installerDb.isIpLikeUsable()) {
                this.m_installerDb.setupPlPgsqlIplike();
            }
            this.m_installerDb.createTables();
            this.m_installerDb.insertData();
        }
        finally {
            this.m_installerDb.closeConnection();
        }
    }

    protected String getStoredProcDirectory() {
        return ConfigurationTestUtils.getFileForConfigFile((String)"create.sql").getParentFile().getAbsolutePath();
    }

    protected String getCreateSqlLocation() {
        return ConfigurationTestUtils.getFileForConfigFile((String)"create.sql").getAbsolutePath();
    }

    public boolean isSetupIpLike() {
        return this.m_setupIpLike;
    }

    public void setSetupIpLike(boolean setupIpLike) {
        this.m_setupIpLike = setupIpLike;
    }

    protected File findIpLikeLibrary() {
        File topDir = ConfigurationTestUtils.getTopProjectDirectory();
        File ipLikeDir = new File(topDir, "opennms-iplike");
        this.assertTrue("iplike directory exists at ../opennms-iplike: " + ipLikeDir.getAbsolutePath(), ipLikeDir.exists());
        Object[] ipLikePlatformDirs = ipLikeDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().matches("opennms-iplike-.*") && file.isDirectory();
            }
        });
        this.assertTrue("expecting at least one opennms iplike platform directory in " + ipLikeDir.getAbsolutePath() + "; got: " + StringUtils.arrayToDelimitedString((Object[])ipLikePlatformDirs, (String)", "), ipLikePlatformDirs.length > 0);
        Object ipLikeFile = null;
        for (Object ipLikePlatformDir : ipLikePlatformDirs) {
            this.assertTrue("iplike platform directory does not exist but was listed in directory listing: " + ((File)ipLikePlatformDir).getAbsolutePath(), ((File)ipLikePlatformDir).exists());
            File ipLikeTargetDir = new File((File)ipLikePlatformDir, "target");
            if (!ipLikeTargetDir.exists() || !ipLikeTargetDir.isDirectory()) continue;
            Object[] ipLikeFiles = ipLikeTargetDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    return file.isFile() && file.getName().matches("opennms-iplike-.*\\.(so|dylib)");
                }
            });
            this.assertFalse("expecting zero or one iplike file in " + ipLikeTargetDir.getAbsolutePath() + "; got: " + StringUtils.arrayToDelimitedString((Object[])ipLikeFiles, (String)", "), ipLikeFiles.length > 1);
            if (ipLikeFiles.length != 1) continue;
            ipLikeFile = ipLikeFiles[0];
        }
        this.assertNotNull("Could not find iplike shared object in a target directory in any of these directories: " + StringUtils.arrayToDelimitedString((Object[])ipLikePlatformDirs, (String)", "), ipLikeFile);
        return ipLikeFile;
    }

    private void assertNotNull(String string, Object o) {
        if (o == null) {
            throw new IllegalStateException(string);
        }
    }

    private void assertFalse(String string, boolean b) {
        if (b) {
            throw new IllegalStateException(string);
        }
    }

    private void assertTrue(String string, boolean b) {
        if (!b) {
            throw new IllegalStateException(string);
        }
    }

    private void resetOutputStream() {
        this.m_outputStream = new ByteArrayOutputStream();
        this.m_installerDb.setOutputStream(new PrintStream(this.m_outputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setupDatabase() throws Exception {
        this.setDataSource((DataSource)new SimpleDataSource(this.m_driver, this.m_url + this.getTestDatabase(), this.m_adminUser, this.m_adminPassword));
        this.setAdminDataSource((DataSource)new SimpleDataSource(this.m_driver, this.m_url + "template1", this.m_adminUser, this.m_adminPassword));
        if (!this.m_useExisting) {
            Object object = TEMPLATE1_MUTEX;
            synchronized (object) {
                this.createTestDatabase();
            }
        }
        Connection connection = this.getConnection();
        connection.close();
        this.setJdbcTemplate(new SimpleJdbcTemplate((DataSource)this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTestDatabase() throws Exception {
        Connection adminConnection = this.getAdminDataSource().getConnection();
        Statement st = null;
        try {
            st = adminConnection.createStatement();
            st.execute("CREATE DATABASE " + this.getTestDatabase() + " WITH ENCODING='UNICODE'");
        }
        finally {
            if (st != null) {
                st.close();
            }
            adminConnection.close();
        }
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                try {
                    Thread.sleep(100L);
                    TemporaryDatabase.this.destroyTestDatabase();
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void drop() throws Exception {
        if (!this.m_useExisting) {
            this.destroyTestDatabase();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void destroyTestDatabase() throws Exception {
        if (this.m_useExisting) {
            return;
        }
        if (this.m_destroyed) {
            System.err.println("Database '" + this.getTestDatabase() + "' already destroyed");
            return;
        }
        Thread.sleep(100L);
        Connection adminConnection = this.getAdminDataSource().getConnection();
        try {
            for (int dropAttempt = 0; dropAttempt < 10; ++dropAttempt) {
                Statement st = null;
                try {
                    st = adminConnection.createStatement();
                    st.execute("DROP DATABASE " + this.getTestDatabase());
                    break;
                }
                catch (SQLException e) {
                    if (dropAttempt + 1 >= 10) {
                        String message = "Failed to drop test database on last attempt " + (dropAttempt + 1) + ": " + e;
                        System.err.println(new Date().toString() + ": " + message);
                        TemporaryDatabase.dumpThreads();
                        SQLException newException = new SQLException(message);
                        newException.initCause(e);
                        throw newException;
                    }
                    System.err.println(new Date().toString() + ": Failed to drop test database on attempt " + (dropAttempt + 1) + ": " + e);
                    Thread.sleep(1000L);
                    continue;
                }
                finally {
                    if (st != null) {
                        st.close();
                        st = null;
                    }
                }
            }
        }
        finally {
            try {
                adminConnection.close();
            }
            catch (SQLException e) {
                System.err.println("Error closing administrative database connection after attempting to drop test database");
                e.printStackTrace();
            }
            Thread.sleep(100L);
        }
        this.m_destroyed = true;
    }

    public static void dumpThreads() {
        Map<Thread, StackTraceElement[]> threads = Thread.getAllStackTraces();
        int daemons = 0;
        for (Thread t : threads.keySet()) {
            if (!t.isDaemon()) continue;
            ++daemons;
        }
        System.err.println("Thread dump of " + threads.size() + " threads (" + daemons + " daemons):");
        TreeMap<Thread, StackTraceElement[]> sortedThreads = new TreeMap<Thread, StackTraceElement[]>(new Comparator<Thread>(){

            @Override
            public int compare(Thread t1, Thread t2) {
                return Long.valueOf(t1.getId()).compareTo(t2.getId());
            }
        });
        sortedThreads.putAll(threads);
        for (Map.Entry entry : sortedThreads.entrySet()) {
            Thread thread = (Thread)entry.getKey();
            System.err.println("Thread " + thread.getId() + (thread.isDaemon() ? " (daemon)" : DEFAULT_ADMIN_PASSWORD) + ": " + thread + " (state: " + (Object)((Object)thread.getState()) + ")");
            for (StackTraceElement e : (StackTraceElement[])entry.getValue()) {
                System.err.println("\t" + e);
            }
        }
        System.err.println("Thread dump completed.");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.m_dataSource.getConnection();
    }

    public void update(String stmt, Object ... values) {
        this.getJdbcTemplate().update(stmt, values);
    }

    public int countRows(String sql, Object ... values) {
        RowCountCallbackHandler counter = new RowCountCallbackHandler();
        this.getJdbcTemplate().getJdbcOperations().query(sql, values, (RowCallbackHandler)counter);
        return counter.getRowCount();
    }

    public String getNextSequenceValStatement(String seqName) {
        return "select nextval('" + seqName + "')";
    }

    protected Integer getNextId(String nxtIdStmt) {
        return this.getJdbcTemplate().queryForInt(nxtIdStmt, new Object[0]);
    }

    @Override
    public Connection getConnection(String username, String password) throws SQLException {
        return this.m_dataSource.getConnection(username, password);
    }

    @Override
    public PrintWriter getLogWriter() throws SQLException {
        return this.m_dataSource.getLogWriter();
    }

    @Override
    public void setLogWriter(PrintWriter out) throws SQLException {
        this.m_dataSource.setLogWriter(out);
    }

    @Override
    public void setLoginTimeout(int seconds) throws SQLException {
        this.m_dataSource.setLoginTimeout(seconds);
    }

    @Override
    public int getLoginTimeout() throws SQLException {
        return this.m_dataSource.getLoginTimeout();
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("getParentLogger not supported");
    }

    public SimpleJdbcTemplate getJdbcTemplate() {
        return this.m_jdbcTemplate;
    }

    public void setJdbcTemplate(SimpleJdbcTemplate jdbcTemplate) {
        this.m_jdbcTemplate = jdbcTemplate;
    }

    public DataSource getAdminDataSource() {
        return this.m_adminDataSource;
    }

    public void setAdminDataSource(DataSource adminDataSource) {
        this.m_adminDataSource = adminDataSource;
    }

    public DataSource getDataSource() {
        return this.m_dataSource;
    }

    public void setDataSource(DataSource dataSource) {
        this.m_dataSource = dataSource;
    }

    public String getTestDatabase() {
        return this.m_testDatabase;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public String getDriver() {
        return this.m_driver;
    }

    public String getUrl() {
        return this.m_url;
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("driver", (Object)this.m_driver).append("url", (Object)this.m_url).append("testDatabase", (Object)this.m_testDatabase).append("useExisting", this.m_useExisting).append("setupIpLike", this.m_setupIpLike).append("populateSchema", this.m_populateSchema).append("dataSource", (Object)this.m_dataSource).append("adminDataSource", (Object)this.m_adminDataSource).append("adminUser", (Object)this.m_adminUser).toString();
    }
}

