/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.castor;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import org.opennms.netmgt.dao.castor.collector.DataCollectionConfigFileTest;

public class InvocationAnticipator
implements InvocationHandler {
    private HashMap<String, Integer> m_counts = new HashMap();
    private HashMap<String, Integer> m_anticipatedCounts = new HashMap();
    private Class<?> m_clazz;
    private InvocationHandler m_handler = new NullInvocationHandler();

    public InvocationAnticipator(Class<?> clazz) {
        this.m_clazz = clazz;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        int currentCount = 0;
        if (this.m_counts.get(method.getName()) != null) {
            currentCount = this.m_counts.get(method.getName());
        }
        this.m_counts.put(method.getName(), currentCount + 1);
        return this.m_handler.invoke(proxy, method, args);
    }

    public void setInvocationHandler(InvocationHandler handler) {
        this.m_handler = handler;
    }

    public int getCount(String methodName) {
        if (this.m_counts.get(methodName) == null) {
            return 0;
        }
        return this.m_counts.get(methodName);
    }

    public int getAnticipatedCount(String methodName) {
        if (this.m_anticipatedCounts.get(methodName) == null) {
            return 0;
        }
        return this.m_anticipatedCounts.get(methodName);
    }

    public void anticipateCalls(int count, String methodName) {
        this.m_anticipatedCounts.put(methodName, count);
    }

    public void verify() {
        this.ensureAnticipatedWereReceived();
        this.ensureNoUnanticipated();
    }

    private void ensureNoUnanticipated() {
        HashSet<String> unexpected = new HashSet<String>(this.m_counts.keySet());
        unexpected.removeAll(this.m_anticipatedCounts.keySet());
        if (!unexpected.isEmpty()) {
            String method = unexpected.iterator().next();
            DataCollectionConfigFileTest.fail((String)("Unexpected call to method " + method + ".  It was called " + this.getCount(method) + " times"));
        }
    }

    private void ensureAnticipatedWereReceived() {
        for (String methodName : this.m_anticipatedCounts.keySet()) {
            DataCollectionConfigFileTest.assertEquals((String)("Unexpected callCount for method " + methodName), (int)this.getAnticipatedCount(methodName), (int)this.getCount(methodName));
        }
    }

    public Object getProxy() {
        return Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{this.m_clazz}, (InvocationHandler)this);
    }

    public class NullInvocationHandler
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            return null;
        }
    }
}

