/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.castor;

import java.io.IOException;
import java.util.Map;
import junit.framework.TestCase;
import org.opennms.netmgt.config.surveillanceViews.Columns;
import org.opennms.netmgt.config.surveillanceViews.Rows;
import org.opennms.netmgt.config.surveillanceViews.View;
import org.opennms.netmgt.config.surveillanceViews.Views;
import org.opennms.netmgt.dao.castor.DefaultSurveillanceViewConfigDao;
import org.opennms.test.ConfigurationTestUtils;
import org.opennms.test.mock.MockLogAppender;
import org.opennms.test.mock.MockUtil;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.InputStreamResource;
import org.springframework.core.io.Resource;

public class DefaultSurveillanceViewConfigDaoTest
extends TestCase {
    private static final String CONFIG_WITH_VIEWS_RESOURCE = "/surveillance-views.testdata.xml";
    private static final String CONFIG_NO_VIEWS_RESOURCE = "/surveillance-views.testdata.noviews.xml";
    private DefaultSurveillanceViewConfigDao m_dao;

    protected void setUp() throws Exception {
        super.setUp();
        MockUtil.println((String)("------------ Begin Test " + this.getName() + " --------------------------"));
        MockLogAppender.setupLogging();
        this.createDaoWithResource(CONFIG_WITH_VIEWS_RESOURCE);
    }

    public void runTest() throws Throwable {
        super.runTest();
        MockLogAppender.assertNoWarningsOrGreater();
        MockUtil.println((String)("------------ End Test " + this.getName() + " --------------------------"));
    }

    public void testNothing() {
    }

    public void testDefaultView() {
        View view = this.m_dao.getDefaultView();
        DefaultSurveillanceViewConfigDaoTest.assertNotNull((String)"default view should not be null", (Object)view);
        DefaultSurveillanceViewConfigDaoTest.assertEquals((String)"default view name", (String)"default", (String)view.getName());
        Columns columns = view.getColumns();
        DefaultSurveillanceViewConfigDaoTest.assertNotNull((String)"default view columns should not be null", (Object)columns);
        DefaultSurveillanceViewConfigDaoTest.assertEquals((String)"default view column count", (int)3, (int)columns.getColumnDefCount());
        Rows rows = view.getRows();
        DefaultSurveillanceViewConfigDaoTest.assertNotNull((String)"default view rows should not be null", (Object)rows);
        DefaultSurveillanceViewConfigDaoTest.assertEquals((String)"default view row count", (int)3, (int)rows.getRowDefCount());
    }

    public void testViewByName() {
        View view = this.m_dao.getView("default");
        DefaultSurveillanceViewConfigDaoTest.assertNotNull((String)"default view should not be null", (Object)view);
        DefaultSurveillanceViewConfigDaoTest.assertEquals((String)"default view name", (String)"default", (String)view.getName());
        Columns columns = view.getColumns();
        DefaultSurveillanceViewConfigDaoTest.assertNotNull((String)"default view columns should not be null", (Object)columns);
        DefaultSurveillanceViewConfigDaoTest.assertEquals((String)"default view column count", (int)3, (int)columns.getColumnDefCount());
        Rows rows = view.getRows();
        DefaultSurveillanceViewConfigDaoTest.assertNotNull((String)"default view rows should not be null", (Object)rows);
        DefaultSurveillanceViewConfigDaoTest.assertEquals((String)"default view row count", (int)3, (int)rows.getRowDefCount());
    }

    public void testGetViews() {
        Views views = this.m_dao.getViews();
        DefaultSurveillanceViewConfigDaoTest.assertNotNull((String)"views should not be null", (Object)views);
        DefaultSurveillanceViewConfigDaoTest.assertEquals((String)"view count", (int)1, (int)views.getViewCount());
        View view = views.getView(0);
        DefaultSurveillanceViewConfigDaoTest.assertNotNull((String)"first view should not be null", (Object)view);
        DefaultSurveillanceViewConfigDaoTest.assertEquals((String)"first view name", (String)"default", (String)view.getName());
        Columns columns = view.getColumns();
        DefaultSurveillanceViewConfigDaoTest.assertNotNull((String)"first view columns should not be null", (Object)columns);
        DefaultSurveillanceViewConfigDaoTest.assertEquals((String)"first view column count", (int)3, (int)columns.getColumnDefCount());
        Rows rows = view.getRows();
        DefaultSurveillanceViewConfigDaoTest.assertNotNull((String)"first view rows should not be null", (Object)rows);
        DefaultSurveillanceViewConfigDaoTest.assertEquals((String)"first view row count", (int)3, (int)rows.getRowDefCount());
    }

    public void testGetViewMap() {
        Map viewMap = this.m_dao.getViewMap();
        DefaultSurveillanceViewConfigDaoTest.assertEquals((String)"view count", (int)1, (int)viewMap.size());
        DefaultSurveillanceViewConfigDaoTest.assertNull((String)"shouldn't have 'bogus' view", viewMap.get("bogus"));
        View view = (View)viewMap.get("default");
        DefaultSurveillanceViewConfigDaoTest.assertNotNull((String)"should have 'default' view", (Object)view);
        DefaultSurveillanceViewConfigDaoTest.assertNotNull((String)"first view should not be null", (Object)view);
        DefaultSurveillanceViewConfigDaoTest.assertEquals((String)"first view name", (String)"default", (String)view.getName());
        Columns columns = view.getColumns();
        DefaultSurveillanceViewConfigDaoTest.assertNotNull((String)"first view columns should not be null", (Object)columns);
        DefaultSurveillanceViewConfigDaoTest.assertEquals((String)"first view column count", (int)3, (int)columns.getColumnDefCount());
        Rows rows = view.getRows();
        DefaultSurveillanceViewConfigDaoTest.assertNotNull((String)"first view rows should not be null", (Object)rows);
        DefaultSurveillanceViewConfigDaoTest.assertEquals((String)"first view row count", (int)3, (int)rows.getRowDefCount());
    }

    public void testInitNoViews() throws IOException {
        this.createDaoWithResource(CONFIG_NO_VIEWS_RESOURCE);
    }

    public void testGetDefaultViewNoViews() throws IOException {
        this.createDaoWithResource(CONFIG_NO_VIEWS_RESOURCE);
        View view = this.m_dao.getDefaultView();
        DefaultSurveillanceViewConfigDaoTest.assertNull((String)"default view should be null", (Object)view);
    }

    public void testGetViewByNameNoViews() throws IOException {
        this.createDaoWithResource(CONFIG_NO_VIEWS_RESOURCE);
        View view = this.m_dao.getView("default");
        DefaultSurveillanceViewConfigDaoTest.assertNull((String)"view by name 'default' should be null", (Object)view);
    }

    public void testGetViewsNoViews() throws IOException {
        this.createDaoWithResource(CONFIG_NO_VIEWS_RESOURCE);
        Views views = this.m_dao.getViews();
        DefaultSurveillanceViewConfigDaoTest.assertNotNull((String)"views should not be null", (Object)views);
        DefaultSurveillanceViewConfigDaoTest.assertEquals((String)"view count", (int)0, (int)views.getViewCount());
    }

    public void testGetViewMapNoViews() throws IOException {
        this.createDaoWithResource(CONFIG_NO_VIEWS_RESOURCE);
        Map viewMap = this.m_dao.getViewMap();
        DefaultSurveillanceViewConfigDaoTest.assertNotNull((String)"viewMap should not be null", (Object)viewMap);
        DefaultSurveillanceViewConfigDaoTest.assertEquals((String)"view count", (int)0, (int)viewMap.size());
    }

    public void testConfigProduction() throws IOException {
        this.createDaoWithConfigFile("surveillance-views.xml");
    }

    public void testConfigExample() throws IOException {
        this.createDaoWithConfigFile("examples/surveillance-views.xml");
    }

    private void createDaoWithResource(String configResource) throws IOException {
        ClassPathResource resource = new ClassPathResource(configResource);
        this.m_dao = new DefaultSurveillanceViewConfigDao();
        this.m_dao.setConfigResource((Resource)resource);
        this.m_dao.afterPropertiesSet();
    }

    private void createDaoWithConfigFile(String configFileName) throws IOException {
        InputStreamResource resource = new InputStreamResource(ConfigurationTestUtils.getInputStreamForConfigFile((String)configFileName));
        this.m_dao = new DefaultSurveillanceViewConfigDao();
        this.m_dao.setConfigResource((Resource)resource);
        this.m_dao.afterPropertiesSet();
    }
}

