/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.IpInterfaceDao;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class IpInterfaceDaoTest {
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;

    @Before
    public void setUp() {
        this.m_databasePopulator.populateDatabase();
    }

    @Test
    @Transactional
    public void testGetByIpAddress() {
        List ifaces = this.m_ipInterfaceDao.findByIpAddress("192.168.1.1");
        Assert.assertEquals((long)1L, (long)ifaces.size());
        OnmsIpInterface iface = (OnmsIpInterface)ifaces.iterator().next();
        Assert.assertEquals((Object)"node1", (Object)iface.getNode().getLabel());
        int count = 0;
        Iterator it = iface.getMonitoredServices().iterator();
        while (it.hasNext()) {
            it.next();
            ++count;
        }
        Assert.assertEquals((long)2L, (long)count);
        Assert.assertEquals((long)2L, (long)iface.getMonitoredServices().size());
        Assert.assertEquals((Object)"192.168.1.1", (Object)InetAddressUtils.str((InetAddress)iface.getIpAddress()));
    }

    @Test
    @Transactional
    public void testGetByService() {
        List ifaces = this.m_ipInterfaceDao.findByServiceType("SNMP");
        Collections.sort(ifaces, new Comparator<OnmsIpInterface>(){

            @Override
            public int compare(OnmsIpInterface o1, OnmsIpInterface o2) {
                return Integer.valueOf(o1.getNode().getId()).compareTo(o2.getNode().getId());
            }
        });
        Assert.assertEquals((long)6L, (long)ifaces.size());
        OnmsIpInterface iface = (OnmsIpInterface)ifaces.iterator().next();
        Assert.assertEquals((Object)"node1", (Object)iface.getNode().getLabel());
        Assert.assertEquals((long)2L, (long)iface.getMonitoredServices().size());
        Assert.assertEquals((Object)"192.168.1.1", (Object)InetAddressUtils.str((InetAddress)iface.getIpAddress()));
        OnmsMonitoredService service = iface.getMonitoredServiceByServiceType("SNMP");
        Assert.assertNotNull((Object)service);
        Assert.assertEquals((Object)InetAddressUtils.addr((String)"192.168.1.1"), (Object)service.getIpAddress());
    }

    @Test
    @Transactional
    public void testCountMatchingInerfaces() {
        OnmsCriteria crit = new OnmsCriteria(OnmsIpInterface.class);
        crit.add((Criterion)Restrictions.like((String)"ipAddress", (Object)"192.168.1.%"));
        Assert.assertEquals((long)3L, (long)this.m_ipInterfaceDao.countMatching(crit));
        crit = new OnmsCriteria(OnmsIpInterface.class);
        crit.add((Criterion)Restrictions.like((String)"ipAddress", (Object)"fe80:%dddd\\%5"));
        Assert.assertEquals((long)1L, (long)this.m_ipInterfaceDao.countMatching(crit));
    }

    @Test
    @Transactional
    public void testGetIPv6Interfaces() {
        OnmsCriteria crit = new OnmsCriteria(OnmsIpInterface.class);
        crit.add((Criterion)Restrictions.like((String)"ipAddress", (Object)"fe80:%dddd\\%5"));
        List ifaces = this.m_ipInterfaceDao.findMatching(crit);
        Assert.assertEquals((long)1L, (long)ifaces.size());
        OnmsIpInterface iface = (OnmsIpInterface)ifaces.get(0);
        Assert.assertTrue((boolean)(iface.getIpAddress() instanceof Inet6Address));
        Inet6Address v6address = (Inet6Address)iface.getIpAddress();
        Assert.assertEquals((long)5L, (long)v6address.getScopeId());
        Assert.assertEquals((Object)"fe80:0000:0000:0000:aaaa:bbbb:cccc:dddd%5", (Object)InetAddressUtils.str((InetAddress)iface.getIpAddress()));
    }

    @Test
    @Transactional
    public void testGetInterfacesForNodes() throws UnknownHostException {
        Map interfaceNodes = this.m_ipInterfaceDao.getInterfacesForNodes();
        Assert.assertNotNull((String)"interfaceNodes", (Object)interfaceNodes);
        for (Map.Entry entry : interfaceNodes.entrySet()) {
            System.out.println(entry.getKey() + ": " + entry.getValue());
        }
        Assert.assertEquals((String)"node ID for 192.168.1.1", (Object)this.m_databasePopulator.getNode1().getId(), interfaceNodes.get(InetAddressUtils.addr((String)"192.168.1.1")));
        Assert.assertEquals((String)"node ID for 192.168.1.2", (Object)this.m_databasePopulator.getNode1().getId(), interfaceNodes.get(InetAddressUtils.addr((String)"192.168.1.2")));
        Assert.assertEquals((String)"node ID for 192.168.2.1", (Object)(this.m_databasePopulator.getNode1().getId() + 1), interfaceNodes.get(InetAddressUtils.addr((String)"192.168.2.1")));
        Assert.assertFalse((String)"node ID for *BOGUS*IP* should not have been found", (boolean)interfaceNodes.containsKey("*BOGUS*IP*"));
    }
}

