/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.junit.Assert;
import org.junit.Test;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.DiscoveryConfigFactory;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.opennms.netmgt.config.discovery.ExcludeRange;
import org.opennms.netmgt.config.discovery.IncludeRange;
import org.opennms.netmgt.config.discovery.Specific;
import org.opennms.netmgt.model.discovery.IPPollAddress;

public class DiscoveryConfigFactoryTest {
    @Test
    public void testAddToSpecificsFromURLViaURL() throws Exception {
        ArrayList specifics = new ArrayList();
        URL in = Thread.currentThread().getContextClassLoader().getResource("org/opennms/netmgt/config/validDiscoveryIncludeFile.txt");
        long timeout = 100L;
        boolean retries = true;
        DiscoveryConfigFactory.addToSpecificsFromURL(specifics, (String)in.toString(), (long)100L, (int)1);
        Assert.assertEquals((long)8L, (long)specifics.size());
        Assert.assertEquals((Object)"127.0.0.1", (Object)InetAddressUtils.str((InetAddress)((IPPollAddress)specifics.get(0)).getAddress()));
        Assert.assertEquals((Object)"10.1.1.1", (Object)InetAddressUtils.str((InetAddress)((IPPollAddress)specifics.get(1)).getAddress()));
        Assert.assertEquals((Object)"10.2.1.1", (Object)InetAddressUtils.str((InetAddress)((IPPollAddress)specifics.get(2)).getAddress()));
        Assert.assertEquals((Object)"8.8.8.8", (Object)InetAddressUtils.str((InetAddress)((IPPollAddress)specifics.get(3)).getAddress()));
        Assert.assertEquals((Object)"fe80:0000:0000:0000:ffff:eeee:dddd:cccc", (Object)InetAddressUtils.str((InetAddress)((IPPollAddress)specifics.get(4)).getAddress()));
        Assert.assertEquals((Object)"0000:0000:0000:0000:0000:0000:0000:0001", (Object)InetAddressUtils.str((InetAddress)((IPPollAddress)specifics.get(5)).getAddress()));
        Assert.assertEquals((Object)"fe80:0000:0000:0000:ffff:eeee:dddd:cccd", (Object)InetAddressUtils.str((InetAddress)((IPPollAddress)specifics.get(6)).getAddress()));
        Assert.assertEquals((Object)"fe80:0000:0000:0000:ffff:eeee:dddd:cccc", (Object)InetAddressUtils.str((InetAddress)((IPPollAddress)specifics.get(7)).getAddress()));
    }

    @Test
    public void testAddToSpecificsFromURLViaStream() throws Exception {
        ArrayList specifics = new ArrayList();
        InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream("org/opennms/netmgt/config/validDiscoveryIncludeFile.txt");
        long timeout = 100L;
        boolean retries = true;
        DiscoveryConfigFactory.addToSpecificsFromURL(specifics, (InputStream)in, (long)100L, (int)1);
        Assert.assertEquals((long)8L, (long)specifics.size());
        Assert.assertEquals((Object)"127.0.0.1", (Object)InetAddressUtils.str((InetAddress)((IPPollAddress)specifics.get(0)).getAddress()));
        Assert.assertEquals((Object)"10.1.1.1", (Object)InetAddressUtils.str((InetAddress)((IPPollAddress)specifics.get(1)).getAddress()));
        Assert.assertEquals((Object)"10.2.1.1", (Object)InetAddressUtils.str((InetAddress)((IPPollAddress)specifics.get(2)).getAddress()));
        Assert.assertEquals((Object)"8.8.8.8", (Object)InetAddressUtils.str((InetAddress)((IPPollAddress)specifics.get(3)).getAddress()));
        Assert.assertEquals((Object)"fe80:0000:0000:0000:ffff:eeee:dddd:cccc", (Object)InetAddressUtils.str((InetAddress)((IPPollAddress)specifics.get(4)).getAddress()));
        Assert.assertEquals((Object)"0000:0000:0000:0000:0000:0000:0000:0001", (Object)InetAddressUtils.str((InetAddress)((IPPollAddress)specifics.get(5)).getAddress()));
        Assert.assertEquals((Object)"fe80:0000:0000:0000:ffff:eeee:dddd:cccd", (Object)InetAddressUtils.str((InetAddress)((IPPollAddress)specifics.get(6)).getAddress()));
        Assert.assertEquals((Object)"fe80:0000:0000:0000:ffff:eeee:dddd:cccc", (Object)InetAddressUtils.str((InetAddress)((IPPollAddress)specifics.get(7)).getAddress()));
    }

    @Test
    public void testMultipleExcludes() throws Exception {
        DiscoveryConfigFactory factory = new DiscoveryConfigFactory(){

            public void saveConfiguration(DiscoveryConfiguration configuration) throws MarshalException, ValidationException, IOException {
            }

            public synchronized DiscoveryConfiguration getConfiguration() {
                DiscoveryConfiguration conf = new DiscoveryConfiguration();
                IncludeRange ir = new IncludeRange();
                ir.setBegin("192.168.0.1");
                ir.setEnd("192.168.0.254");
                conf.addIncludeRange(ir);
                ir = new IncludeRange();
                ir.setBegin("192.168.2.1");
                ir.setEnd("192.168.2.255");
                conf.addIncludeRange(ir);
                Specific s = new Specific();
                s.setContent("192.168.1.1");
                conf.addSpecific(s);
                s = new Specific();
                s.setContent("192.168.4.1");
                conf.addSpecific(s);
                ExcludeRange er = new ExcludeRange();
                er.setBegin("192.168.0.100");
                er.setEnd("192.168.0.150");
                conf.addExcludeRange(er);
                er = new ExcludeRange();
                er.setBegin("192.168.2.200");
                er.setEnd("192.168.4.254");
                conf.addExcludeRange(er);
                return conf;
            }
        };
        Assert.assertFalse((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.0.1")));
        Assert.assertFalse((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.0.2")));
        Assert.assertFalse((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.0.99")));
        Assert.assertTrue((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.0.100")));
        Assert.assertTrue((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.0.140")));
        Assert.assertTrue((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.0.150")));
        Assert.assertFalse((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.0.151")));
        Assert.assertFalse((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.1.1")));
        Assert.assertFalse((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.2.1")));
        Assert.assertFalse((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.2.100")));
        Assert.assertTrue((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.2.200")));
        Assert.assertTrue((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.2.220")));
        Assert.assertTrue((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.2.255")));
        Assert.assertTrue((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.4.1")));
    }

    @Test
    public void testSingleIPExclude() throws Exception {
        DiscoveryConfigFactory factory = new DiscoveryConfigFactory(){

            public void saveConfiguration(DiscoveryConfiguration configuration) throws MarshalException, ValidationException, IOException {
            }

            public synchronized DiscoveryConfiguration getConfiguration() {
                DiscoveryConfiguration conf = new DiscoveryConfiguration();
                IncludeRange ir = new IncludeRange();
                ir.setBegin("192.168.0.1");
                ir.setEnd("192.168.0.254");
                conf.addIncludeRange(ir);
                ExcludeRange er = new ExcludeRange();
                er.setBegin("192.168.0.100");
                er.setEnd("192.168.0.100");
                conf.addExcludeRange(er);
                return conf;
            }
        };
        Assert.assertFalse((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.0.1")));
        Assert.assertFalse((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.0.2")));
        Assert.assertFalse((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.0.99")));
        Assert.assertTrue((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.0.100")));
        Assert.assertFalse((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.0.101")));
        Assert.assertFalse((boolean)factory.isExcluded(InetAddressUtils.addr((String)"192.168.0.151")));
    }
}

