/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config;

import java.beans.PropertyVetoException;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.netmgt.config.C3P0ConnectionFactory;
import org.opennms.test.ConfigurationTestUtils;

public class C3P0ConnectionFactoryTest
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testMarshalDataSourceFromConfig() throws Exception {
        C3P0ConnectionFactory factory1 = null;
        C3P0ConnectionFactory factory2 = null;
        try {
            factory1 = this.makeFactory("opennms");
            factory2 = this.makeFactory("opennms2");
            Connection conn = null;
            Statement s = null;
            try {
                conn = factory2.getConnection();
                s = conn.createStatement();
                s.execute("select * from pg_proc");
            }
            finally {
                if (s != null) {
                    s.close();
                }
                if (conn != null) {
                    conn.close();
                }
            }
        }
        finally {
            Throwable t1 = null;
            Throwable t2 = null;
            if (factory1 != null) {
                try {
                    factory1.close();
                    factory1 = null;
                }
                catch (Throwable e1) {
                    t1 = e1;
                }
            }
            if (factory2 != null) {
                try {
                    factory2.close();
                    factory2 = null;
                }
                catch (Throwable e2) {
                    t2 = e2;
                }
            }
            if (t1 != null || t2 != null) {
                Throwable choice;
                StringBuffer message = new StringBuffer();
                message.append("Could not successfully close both C3P0 factories.  Future tests might fail.");
                if (t1 != null) {
                    message.append("  First factory failed with: " + t1.getMessage() + "; see stack back trace.");
                    choice = t1;
                    if (t2 != null) {
                        System.err.println("  Both factories failed to close.  See stderr for second stack back trace.");
                        t2.printStackTrace(System.err);
                    }
                } else {
                    choice = t2;
                }
                AssertionError e = new AssertionError((Object)message.toString());
                ((Throwable)((Object)e)).initCause(choice);
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private C3P0ConnectionFactory makeFactory(String database) throws MarshalException, ValidationException, PropertyVetoException, SQLException, IOException {
        InputStream stream = ConfigurationTestUtils.getInputStreamForResource((Object)((Object)this), (String)"opennms-datasources.xml");
        try {
            C3P0ConnectionFactory c3P0ConnectionFactory = new C3P0ConnectionFactory(stream, database);
            return c3P0ConnectionFactory;
        }
        finally {
            IOUtils.closeQuietly((InputStream)stream);
        }
    }
}

