/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.support;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.LogUtils;
import org.opennms.netmgt.config.SnmpAgentConfigProxyMapper;
import org.opennms.netmgt.config.SnmpPeerFactory;
import org.opennms.netmgt.snmp.SnmpAgentAddress;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.test.ConfigurationTestUtils;

public class ProxySnmpAgentConfigFactory
extends SnmpPeerFactory {
    public ProxySnmpAgentConfigFactory() throws MarshalException, ValidationException, FileNotFoundException, IOException {
        super(ConfigurationTestUtils.getInputStreamForConfigFile((String)"snmp-config.xml"));
    }

    public SnmpAgentConfig getAgentConfig(InetAddress address) {
        SnmpAgentConfigProxyMapper mapper = SnmpAgentConfigProxyMapper.getInstance();
        SnmpAgentAddress agentAddress = mapper.getAddress(address);
        String addressString = InetAddressUtils.str((InetAddress)address);
        if (agentAddress == null) {
            LogUtils.debugf((Object)((Object)this), (String)"No agent address mapping found for %s!  Try adding a @JUnitSnmpAgent(host=\"%s\", resource=\"...\" entry...", (Object[])new Object[]{addressString, addressString});
            return super.getAgentConfig(address);
        }
        SnmpAgentConfig config = new SnmpAgentConfig(agentAddress.getAddress());
        config.setProxyFor(address);
        config.setPort(agentAddress.getPort().intValue());
        LogUtils.debugf((Object)((Object)this), (String)"proxying %s -> %s", (Object[])new Object[]{addressString, agentAddress});
        return config;
    }
}

