/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.stats;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.Fetch;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.dao.stats.AlarmStatisticsService;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class AlarmStatisticsServiceTest {
    @Autowired
    DatabasePopulator m_dbPopulator;
    @Autowired
    private AlarmStatisticsService m_statisticsService;
    private static boolean m_initialized = false;

    @Before
    public void setUp() {
        org.springframework.util.Assert.notNull((Object)this.m_statisticsService);
        MockLogAppender.setupLogging();
        if (!m_initialized) {
            this.m_dbPopulator.populateDatabase();
        }
        m_initialized = true;
    }

    @Test
    public void testCount() {
        CriteriaBuilder cb = new CriteriaBuilder(OnmsAlarm.class);
        cb.fetch("firstEvent", Fetch.FetchType.EAGER);
        cb.fetch("lastEvent", Fetch.FetchType.EAGER);
        cb.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        cb.alias("node.snmpInterfaces", "snmpInterface", Alias.JoinType.LEFT_JOIN);
        cb.alias("node.ipInterfaces", "ipInterface", Alias.JoinType.LEFT_JOIN);
        cb.distinct();
        int count = this.m_statisticsService.getTotalCount(cb.toCriteria());
        Assert.assertEquals((long)1L, (long)count);
    }

    @Test
    public void testCountBySeverity() {
        CriteriaBuilder cb = new CriteriaBuilder(OnmsAlarm.class);
        cb.ge("severity", (Object)OnmsSeverity.NORMAL);
        cb.fetch("firstEvent", Fetch.FetchType.EAGER);
        cb.fetch("lastEvent", Fetch.FetchType.EAGER);
        cb.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        cb.alias("node.snmpInterfaces", "snmpInterface", Alias.JoinType.LEFT_JOIN);
        cb.alias("node.ipInterfaces", "ipInterface", Alias.JoinType.LEFT_JOIN);
        cb.distinct();
        int count = this.m_statisticsService.getTotalCount(cb.toCriteria());
        Assert.assertEquals((long)1L, (long)count);
    }
}

