/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.hibernate;

import java.util.Collection;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.OnmsMapDao;
import org.opennms.netmgt.dao.OnmsMapElementDao;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.model.OnmsMap;
import org.opennms.netmgt.model.OnmsMapElement;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(dirtiesContext=false)
public class OnmsMapElementDaoHibernateTest {
    @Autowired
    private OnmsMapElementDao m_onmsMapElementDao;
    @Autowired
    private OnmsMapDao m_onmsMapDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;
    private static boolean m_populated = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeTransaction
    public void setUp() {
        try {
            if (!m_populated) {
                this.m_databasePopulator.populateDatabase();
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        finally {
            m_populated = true;
        }
    }

    @Test
    @Transactional
    public void testSaveOnmsMapElement() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestMap", "admin");
        this.m_onmsMapDao.save((Object)map);
        this.m_onmsMapDao.flush();
        this.m_onmsMapDao.clear();
        OnmsMapElement mapElement = new OnmsMapElement(map, 2, "N", "Test Node Two", "unspecified", 0, 10);
        this.m_onmsMapElementDao.save((Object)mapElement);
        this.m_onmsMapElementDao.flush();
        this.m_onmsMapElementDao.clear();
        OnmsMapElement mapElement2 = this.m_onmsMapElementDao.findElementById(mapElement.getId());
        Assert.assertNotSame((Object)mapElement, (Object)mapElement2);
        Assert.assertEquals((long)mapElement.getMap().getId(), (long)mapElement2.getMap().getId());
        Assert.assertEquals((long)mapElement.getElementId(), (long)mapElement2.getElementId());
        Assert.assertEquals((Object)mapElement.getType(), (Object)mapElement2.getType());
        Assert.assertEquals((Object)mapElement.getLabel(), (Object)mapElement2.getLabel());
        Assert.assertEquals((Object)mapElement.getIconName(), (Object)mapElement2.getIconName());
        Assert.assertEquals((long)mapElement.getX(), (long)mapElement2.getX());
        Assert.assertEquals((long)mapElement.getY(), (long)mapElement2.getY());
    }

    @Test
    @Transactional
    public void testSaveOnmsMapElement1() {
        OnmsMap map = new OnmsMap("onmsMapDaoHibernateTestMap1", "admin");
        this.m_onmsMapDao.save((Object)map);
        this.m_onmsMapDao.flush();
        this.m_onmsMapDao.clear();
        OnmsMapElement mapElement = new OnmsMapElement(map, 2, "H", "Test Node Two", "unspecified", 0, 10);
        this.m_onmsMapElementDao.save((Object)mapElement);
        this.m_onmsMapElementDao.flush();
        this.m_onmsMapElementDao.clear();
        OnmsMapElement mapElement2 = this.m_onmsMapElementDao.findElementById(mapElement.getId());
        Assert.assertNotSame((Object)mapElement, (Object)mapElement2);
        Assert.assertEquals((long)mapElement.getMap().getId(), (long)mapElement2.getMap().getId());
        Assert.assertEquals((long)mapElement.getElementId(), (long)mapElement2.getElementId());
        Assert.assertEquals((Object)mapElement.getType(), (Object)mapElement2.getType());
        Assert.assertEquals((Object)mapElement.getLabel(), (Object)mapElement2.getLabel());
        Assert.assertEquals((Object)mapElement.getIconName(), (Object)mapElement2.getIconName());
        Assert.assertEquals((long)mapElement.getX(), (long)mapElement2.getX());
        Assert.assertEquals((long)mapElement.getY(), (long)mapElement2.getY());
    }

    @Test
    @Transactional
    public void testFindById() {
        int id = 63;
        OnmsMapElement mapElement = this.m_onmsMapElementDao.findElementById(id);
        if (mapElement == null) {
            List maps = this.m_onmsMapElementDao.findAll();
            StringBuffer ids = new StringBuffer();
            for (OnmsMapElement current : maps) {
                if (ids.length() > 0) {
                    ids.append(", ");
                }
                ids.append(current.getId());
            }
            Assert.fail((String)("No OnmsMapElement record with ID " + id + " was found, the only IDs are: " + ids.toString()));
        }
        Assert.assertEquals((long)62L, (long)mapElement.getMap().getId());
        Assert.assertEquals((long)1L, (long)mapElement.getElementId());
        Assert.assertEquals((Object)"N", (Object)mapElement.getType());
        Assert.assertEquals((Object)"Test Node", (Object)mapElement.getLabel());
        Assert.assertEquals((Object)"unspecified", (Object)mapElement.getIconName());
        Assert.assertEquals((long)0L, (long)mapElement.getX());
        Assert.assertEquals((long)10L, (long)mapElement.getY());
    }

    @Test
    @Transactional
    public void testFind() {
        int id = 62;
        OnmsMap map = this.m_onmsMapDao.findMapById(id);
        if (map == null) {
            List maps = this.m_onmsMapDao.findAll();
            StringBuffer ids = new StringBuffer();
            for (OnmsMap current : maps) {
                if (ids.length() > 0) {
                    ids.append(", ");
                }
                ids.append(current.getId());
            }
            Assert.fail((String)("No OnmsMap record with ID " + id + " was found, the only IDs are: " + ids.toString()));
        }
        Assert.assertNotNull((Object)map);
        OnmsMapElement mapElement = this.m_onmsMapElementDao.findElement(1, "N", map);
        Assert.assertEquals((long)62L, (long)mapElement.getMap().getId());
        Assert.assertEquals((long)1L, (long)mapElement.getElementId());
        Assert.assertEquals((Object)"N", (Object)mapElement.getType());
        Assert.assertEquals((Object)"Test Node", (Object)mapElement.getLabel());
        Assert.assertEquals((Object)"unspecified", (Object)mapElement.getIconName());
        Assert.assertEquals((long)0L, (long)mapElement.getX());
        Assert.assertEquals((long)10L, (long)mapElement.getY());
    }

    @Test
    @Transactional
    public void testFindMapElementsByMapId() {
        int id = 62;
        OnmsMap map = this.m_onmsMapDao.findMapById(id);
        if (map == null) {
            List maps = this.m_onmsMapDao.findAll();
            StringBuffer ids = new StringBuffer();
            for (OnmsMap current : maps) {
                if (ids.length() > 0) {
                    ids.append(", ");
                }
                ids.append(current.getId());
            }
            Assert.fail((String)("No OnmsMap record with ID " + id + " was found, the only IDs are: " + ids.toString()));
        }
        Assert.assertNotNull((Object)map);
        Collection elems = this.m_onmsMapElementDao.findElementsByMapId(map);
        Assert.assertEquals((long)1L, (long)elems.size());
        OnmsMapElement mapElement = (OnmsMapElement)elems.iterator().next();
        Assert.assertEquals((long)62L, (long)mapElement.getMap().getId());
        Assert.assertEquals((long)1L, (long)mapElement.getElementId());
        Assert.assertEquals((Object)"N", (Object)mapElement.getType());
        Assert.assertEquals((Object)"Test Node", (Object)mapElement.getLabel());
        Assert.assertEquals((Object)"unspecified", (Object)mapElement.getIconName());
        Assert.assertEquals((long)0L, (long)mapElement.getX());
        Assert.assertEquals((long)10L, (long)mapElement.getY());
    }

    @Test
    @Transactional
    public void testFindElementsByElementIdAndType1() {
        Collection elems = this.m_onmsMapElementDao.findElementsByElementIdAndType(1, "N");
        Assert.assertEquals((long)1L, (long)elems.size());
        OnmsMapElement mapElement = (OnmsMapElement)elems.iterator().next();
        Assert.assertEquals((long)62L, (long)mapElement.getMap().getId());
        Assert.assertEquals((long)1L, (long)mapElement.getElementId());
        Assert.assertEquals((Object)"N", (Object)mapElement.getType());
        Assert.assertEquals((Object)"Test Node", (Object)mapElement.getLabel());
        Assert.assertEquals((Object)"unspecified", (Object)mapElement.getIconName());
        Assert.assertEquals((long)0L, (long)mapElement.getX());
        Assert.assertEquals((long)10L, (long)mapElement.getY());
    }

    @Test
    @Transactional
    public void testFindElementsByElementIdAndType2() {
        Collection elems = this.m_onmsMapElementDao.findElementsByElementIdAndType(2, "N");
        Assert.assertEquals((long)0L, (long)elems.size());
    }

    @Test
    @Transactional
    public void testFindElementsByElementIdAndType3() {
        Collection elems = this.m_onmsMapElementDao.findElementsByElementIdAndType(1, "M");
        Assert.assertEquals((long)0L, (long)elems.size());
    }

    @Test
    @Transactional
    public void testFindElementsByElementIdAndType4() {
        Collection elems = this.m_onmsMapElementDao.findElementsByElementIdAndType(2, "M");
        Assert.assertEquals((long)0L, (long)elems.size());
    }

    @Test
    @Transactional
    public void testFindElementsByElementIdAndType5() {
        Collection elems = this.m_onmsMapElementDao.findElementsByElementIdAndType(1, "H");
        Assert.assertEquals((long)0L, (long)elems.size());
    }

    @Test
    @Transactional
    public void testFindElementsByElementIdAndType6() {
        Collection elems = this.m_onmsMapElementDao.findElementsByElementIdAndType(2, "H");
        Assert.assertEquals((long)0L, (long)elems.size());
    }

    @Test
    @Transactional
    public void testFindElementsByType1() {
        Collection elems = this.m_onmsMapElementDao.findElementsByType("N");
        Assert.assertEquals((long)1L, (long)elems.size());
        OnmsMapElement mapElement = (OnmsMapElement)elems.iterator().next();
        Assert.assertEquals((long)62L, (long)mapElement.getMap().getId());
        Assert.assertEquals((long)1L, (long)mapElement.getElementId());
        Assert.assertEquals((Object)"N", (Object)mapElement.getType());
        Assert.assertEquals((Object)"Test Node", (Object)mapElement.getLabel());
        Assert.assertEquals((Object)"unspecified", (Object)mapElement.getIconName());
        Assert.assertEquals((long)0L, (long)mapElement.getX());
        Assert.assertEquals((long)10L, (long)mapElement.getY());
    }

    @Test
    @Transactional
    public void testFindElementsByType2() {
        Collection elems = this.m_onmsMapElementDao.findElementsByType("M");
        Assert.assertEquals((long)0L, (long)elems.size());
    }

    @Test
    @Transactional
    public void testDeleteElement() {
        Collection elems = this.m_onmsMapElementDao.findElementsByType("N");
        Assert.assertEquals((long)1L, (long)elems.size());
        OnmsMapElement element = (OnmsMapElement)elems.iterator().next();
        this.m_onmsMapElementDao.delete((Object)element);
        Assert.assertNull((Object)this.m_onmsMapElementDao.findElementById(59));
    }

    @Test
    @Transactional
    public void testDeleteElementsByElementIdAndType() {
        this.m_onmsMapElementDao.deleteElementsByElementIdAndType(1, "N");
        Assert.assertNull((Object)this.m_onmsMapElementDao.findElementById(59));
    }

    @Test
    @Transactional
    public void testDeleteElementsByMapType() {
        this.m_onmsMapElementDao.deleteElementsByMapType("U");
        this.m_onmsMapElementDao.deleteElementsByMapType("A");
        Assert.assertEquals((long)0L, (long)this.m_onmsMapElementDao.findAll().size());
    }
}

