/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.db;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import junit.framework.AssertionFailedError;
import org.opennms.netmgt.dao.db.PopulatedTemporaryDatabaseTestCase;
import org.opennms.test.ThrowableAnticipator;

public class TriggerSetSnmpInterfaceKeysOnInsertTest
extends PopulatedTemporaryDatabaseTestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetSnmpInterfaceIdInIpInterface() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, snmpIfIndex) VALUES ( 1, 1)");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', 1 )");
        Connection connection = this.getConnection();
        try {
            Statement st = connection.createStatement();
            ResultSet rs = st.executeQuery("SELECT id, snmpInterfaceID from ipInterface");
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertTrue((String)"could not advance to read first row in ResultSet", (boolean)rs.next());
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertEquals((String)"expected ipInterface id", (int)2, (int)rs.getInt(1));
            int id = rs.getInt(2);
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertFalse((String)"expected ipInterface snmpInterfaceId to be non-null", (boolean)rs.wasNull());
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertEquals((String)"expected ipInterface snmpInterfaceId to be the same", (int)1, (int)id);
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertFalse((String)"ResultSet contains more than one row", (boolean)rs.next());
        }
        finally {
            connection.close();
        }
    }

    public void testSetSnmpInterfaceIdInIpInterfaceNoSnmpInterfaceEntry() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new AssertionFailedError("Could not execute statement: 'INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', 1 )': ERROR: IpInterface Trigger Notice, Condition 1: No SnmpInterface found for... nodeid: 1 ifindex: 1"));
        try {
            this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', 1 )");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetSnmpInterfaceIdInIpInterfaceNullIfIndex() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, snmpIfIndex) VALUES ( 1, 1)");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', null )");
        Connection connection = this.getConnection();
        try {
            Statement st = connection.createStatement();
            ResultSet rs = st.executeQuery("SELECT id, snmpInterfaceID from ipInterface");
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertTrue((String)"could not advance to read first row in ResultSet", (boolean)rs.next());
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertEquals((String)"ipInterface id", (int)2, (int)rs.getInt(1));
            int id = rs.getInt(2);
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertTrue((String)("ipInterface snmpInterfaceId to be null (was " + id + ")"), (boolean)rs.wasNull());
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertFalse((String)"ResultSet contains more than one row", (boolean)rs.next());
            rs.close();
            st.close();
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetSnmpInterfaceIdInIpInterfaceNullIfIndexNoSnmpInterface() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', null )");
        Connection connection = this.getConnection();
        try {
            Statement st = connection.createStatement();
            ResultSet rs = st.executeQuery("SELECT id, snmpInterfaceID from ipInterface");
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertTrue((String)"could not advance to read first row in ResultSet", (boolean)rs.next());
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertEquals((String)"ipInterface id", (int)1, (int)rs.getInt(1));
            int id = rs.getInt(2);
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertTrue((String)("ipInterface snmpInterfaceId to be null (was " + id + ")"), (boolean)rs.wasNull());
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertFalse((String)"ResultSet contains more than one row", (boolean)rs.next());
        }
        finally {
            connection.close();
        }
    }

    public void testSetSnmpInterfaceIdInIpInterfaceLessThanOneIfIndex() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        ThrowableAnticipator ta = new ThrowableAnticipator();
        ta.anticipate((Throwable)new AssertionFailedError("Could not execute statement: 'INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', 0 )': ERROR: IpInterface Trigger Notice, Condition 1: No SnmpInterface found for... nodeid: 1 ifindex: 0"));
        try {
            this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', 0 )");
        }
        catch (Throwable t) {
            ta.throwableReceived(t);
        }
        ta.verifyAnticipated();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetSnmpInterfaceIdInIpInterfaceLessThanOneIfIndexWithSnmpInterface() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (nodeId, snmpIfIndex) VALUES ( 1, 0)");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex) VALUES ( 1, '1.2.3.4', 0 )");
        Connection connection = this.getConnection();
        try {
            Statement st = connection.createStatement();
            ResultSet rs = st.executeQuery("SELECT snmpInterfaceID from ipInterface");
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertTrue((String)"could not advance to read first row in results", (boolean)rs.next());
            rs.getInt(1);
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertFalse((String)"ipInterface.snmpInterfaceId should not be null", (boolean)rs.wasNull());
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertFalse((String)"results contains more than one row", (boolean)rs.next());
        }
        finally {
            connection.close();
        }
    }

    public void testSetSnmpInterfaceIdInIpInterfaceWithSnmpInterfaceId() {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (id, nodeId, snmpIfIndex) VALUES ( 1, 1, 1 )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, ifIndex, snmpInterfaceId) VALUES ( 1, '1.2.3.4', 1, 1 )");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetSnmpInterfaceIdInIpInterfaceWithSnmpInterfaceIdNullIfIndex() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (id, nodeId, snmpIfIndex) VALUES ( 1, 1, 1 )");
        this.executeSQL("INSERT INTO ipInterface (nodeId, ipAddr, snmpInterfaceId) VALUES ( 1, '1.2.3.4', 1 )");
        Connection connection = this.getConnection();
        try {
            Statement st = connection.createStatement();
            ResultSet rs = st.executeQuery("SELECT ifIndex from ipInterface");
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertTrue((String)"could not advance to read first row in results", (boolean)rs.next());
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertEquals((String)"ipInterface.ifIndex", (int)1, (int)rs.getInt(1));
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertFalse((String)"ipInterface.ifIndex should not be null", (boolean)rs.wasNull());
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertFalse((String)"results contains more than one row", (boolean)rs.next());
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetSnmpInterfaceIdInIpInterfaceWithSnmpInterfaceIdNullNodeId() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (id, nodeId, snmpIfIndex) VALUES ( 1, 1, 1 )");
        this.executeSQL("INSERT INTO ipInterface (ipAddr, ifIndex, snmpInterfaceId) VALUES ( '1.2.3.4', 1, 1 )");
        Connection connection = this.getConnection();
        try {
            Statement st = connection.createStatement();
            ResultSet rs = st.executeQuery("SELECT nodeId from ipInterface");
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertTrue((String)"could not advance to read first row in results", (boolean)rs.next());
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertEquals((String)"ipInterface.nodeId", (int)1, (int)rs.getInt(1));
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertFalse((String)"ipInterface.nodeId should not be null", (boolean)rs.wasNull());
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertFalse((String)"results contains more than one row", (boolean)rs.next());
        }
        finally {
            connection.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSetSnmpInterfaceIdInIpInterfaceWithSnmpInterfaceIdNullNodeIdAndIpAddr() throws Exception {
        this.executeSQL("INSERT INTO node (nodeId, nodeCreateTime) VALUES ( 1, now() )");
        this.executeSQL("INSERT INTO snmpInterface (id, nodeId, snmpIfIndex) VALUES ( 1, 1, 1 )");
        this.executeSQL("INSERT INTO ipInterface (ipAddr, snmpInterfaceId) VALUES ( '1.2.3.4', 1 )");
        Connection connection = this.getConnection();
        try {
            Statement st = connection.createStatement();
            ResultSet rs = st.executeQuery("SELECT nodeId, ifIndex from ipInterface");
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertTrue((String)"could not advance to read first row in results", (boolean)rs.next());
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertEquals((String)"ipInterface.nodeId", (int)1, (int)rs.getInt(1));
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertFalse((String)"ipInterface.nodeId should not be null", (boolean)rs.wasNull());
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertEquals((String)"ipInterface.ifIndex", (int)1, (int)rs.getInt(2));
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertFalse((String)"ipInterface.ifIndex should not be null", (boolean)rs.wasNull());
            TriggerSetSnmpInterfaceKeysOnInsertTest.assertFalse((String)"results contains more than one row", (boolean)rs.next());
        }
        finally {
            connection.close();
        }
    }
}

