/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.castor;

import java.util.Properties;
import junit.framework.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.netmgt.dao.JavaMailConfigurationDao;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.test.mock.MockLogAppender;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class DefaultJavamailConfigurationDaoTest
implements InitializingBean {
    @Autowired
    private JavaMailConfigurationDao m_jmcDao;

    @Before
    public void setUp() throws Exception {
        Properties props = new Properties();
        props.setProperty("log4j.logger.org.hibernate", "INFO");
        props.setProperty("log4j.logger.org.springframework", "INFO");
        props.setProperty("log4j.logger.org.hibernate.SQL", "DEBUG");
        MockLogAppender.setupLogging((Properties)props);
    }

    public void afterPropertiesSet() {
        Assert.assertNotNull((Object)this.m_jmcDao);
    }

    @Test
    public void testMarshalling() {
        Assert.assertEquals((String)"localhost", (String)this.m_jmcDao.getDefaultReadmailConfig().getName());
        Assert.assertEquals((String)"localhost", (String)this.m_jmcDao.getDefaultSendmailConfig().getName());
        Assert.assertEquals((String)"false", (String)this.m_jmcDao.getDefaultReadmailConfig().getJavamailProperty(0).getValue());
        Assert.assertNotNull((Object)this.m_jmcDao.getEnd2EndConfig("default"));
        Assert.assertEquals((String)"localhost", (String)this.m_jmcDao.getEnd2EndConfig("default").getReadmailConfigName());
        Assert.assertEquals((String)"localhost", (String)this.m_jmcDao.getEnd2EndConfig("default").getSendmailConfigName());
    }
}

