/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.SnmpInterfaceDao;
import org.opennms.netmgt.dao.UpsertService;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.support.TransactionTemplate;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath*:/META-INF/opennms/component-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath:upsertTest-context.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class UpsertTest
implements InitializingBean {
    @Autowired
    UpsertService m_upsertService;
    @Autowired
    NodeDao m_nodeDao;
    @Autowired
    SnmpInterfaceDao m_snmpIfaceDao;
    @Autowired
    JdbcTemplate m_jdbcTemplate;
    @Autowired
    DatabasePopulator m_populator;
    @Autowired
    TransactionTemplate m_transTemplate;

    public void afterPropertiesSet() {
        Assert.assertNotNull((Object)this.m_upsertService);
        Assert.assertNotNull((Object)this.m_nodeDao);
        Assert.assertNotNull((Object)this.m_snmpIfaceDao);
        Assert.assertNotNull((Object)this.m_jdbcTemplate);
        Assert.assertNotNull((Object)this.m_populator);
        Assert.assertNotNull((Object)this.m_transTemplate);
    }

    @Before
    public void setUp() {
        this.m_populator.populateDatabase();
    }

    @Test
    @JUnitTemporaryDatabase
    public void testInsert() {
        String newIfName = "newIf0";
        Assert.assertEquals((long)0L, (long)this.countIfs(this.m_populator.getNode1().getId(), 1001, newIfName));
        OnmsSnmpInterface snmpIface = new OnmsSnmpInterface();
        snmpIface.setNode(this.m_populator.getNode1());
        snmpIface.setIfIndex(Integer.valueOf(1001));
        snmpIface.setIfName(newIfName);
        this.m_upsertService.upsert(this.m_populator.getNode1().getId(), snmpIface, 0);
        Assert.assertEquals((long)1L, (long)this.countIfs(this.m_populator.getNode1().getId(), 1001, newIfName));
    }

    private int countIfs(int nodeId, int ifIndex, String ifName) {
        return this.m_jdbcTemplate.queryForInt("select count(*) from snmpInterface where nodeid=? and snmpifindex=? and snmpifname=?", new Object[]{nodeId, ifIndex, ifName});
    }

    @Test
    @JUnitTemporaryDatabase
    public void testUpdate() {
        String oldIfName = "eth0";
        String newIfName = "newIf0";
        Assert.assertEquals((long)1L, (long)this.countIfs(this.m_populator.getNode1().getId(), 2, oldIfName));
        Assert.assertEquals((long)0L, (long)this.countIfs(this.m_populator.getNode1().getId(), 2, newIfName));
        OnmsSnmpInterface snmpIface = new OnmsSnmpInterface();
        snmpIface.setIfIndex(Integer.valueOf(2));
        snmpIface.setIfName(newIfName);
        this.m_upsertService.upsert(this.m_populator.getNode1().getId(), snmpIface, 0);
        Assert.assertEquals((long)0L, (long)this.countIfs(this.m_populator.getNode1().getId(), 2, oldIfName));
        Assert.assertEquals((long)1L, (long)this.countIfs(this.m_populator.getNode1().getId(), 2, newIfName));
    }

    @Test
    @JUnitTemporaryDatabase
    public void testConcurrentInsert() throws InterruptedException {
        Inserter one = new Inserter(this.m_upsertService, this.m_populator.getNode1().getId(), 1001, "ifName1");
        Inserter two = new Inserter(this.m_upsertService, this.m_populator.getNode1().getId(), 1001, "ifName2");
        one.start();
        two.start();
        one.join();
        two.join();
        Assert.assertNull((String)("Exception on upsert two " + two.getThrowable()), (Object)two.getThrowable());
        Assert.assertNull((String)("Exception on upsert one " + one.getThrowable()), (Object)one.getThrowable());
    }

    private static class Inserter
    extends Thread {
        private final UpsertService m_upsertService;
        private final int m_nodeId;
        private final int m_ifIndex;
        private final String m_ifName;
        private AtomicReference<Throwable> m_throwable = new AtomicReference();

        public Inserter(UpsertService upsertService, int nodeId, int ifIndex, String ifName) {
            this.m_upsertService = upsertService;
            this.m_nodeId = nodeId;
            this.m_ifIndex = ifIndex;
            this.m_ifName = ifName;
        }

        @Override
        public void run() {
            try {
                OnmsSnmpInterface snmpIface = new OnmsSnmpInterface();
                snmpIface.setIfIndex(Integer.valueOf(this.m_ifIndex));
                snmpIface.setIfName(this.m_ifName);
                this.m_upsertService.upsert(this.m_nodeId, snmpIface, 1000);
            }
            catch (Throwable t) {
                t.printStackTrace();
                this.m_throwable.set(t);
            }
        }

        public Throwable getThrowable() {
            return this.m_throwable.get();
        }
    }
}

