/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.SnmpInterfaceDao;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase
public class SnmpInterfaceDaoTest {
    @Autowired
    private SnmpInterfaceDao m_snmpInterfaceDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;

    @Before
    public void setUp() {
        this.m_databasePopulator.populateDatabase();
    }

    @Test
    @Transactional
    public void testGet() throws Exception {
        List snmpIfs = this.m_snmpInterfaceDao.findAll();
        Assert.assertEquals((long)4L, (long)snmpIfs.size());
        for (OnmsSnmpInterface snmpIf : snmpIfs) {
            Assert.assertEquals((long)10000000L, (long)snmpIf.getIfSpeed().intValue());
            Assert.assertNotNull((Object)snmpIf.getNode());
            Assert.assertEquals((long)1L, (long)snmpIf.getNode().getId().intValue());
            Assert.assertEquals((Object)"node1", (Object)snmpIf.getNode().getLabel());
        }
    }
}

