/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.io.Serializable;
import java.util.Date;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.netmgt.dao.AlarmDao;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.DistPollerDao;
import org.opennms.netmgt.dao.EventDao;
import org.opennms.netmgt.dao.MemoDao;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsDistPoller;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsMemo;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-soa.xml", "classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(dirtiesContext=false)
public class MemoDaoTest
implements InitializingBean {
    @Autowired
    private DistPollerDao m_distPollerDao;
    @Autowired
    private EventDao m_eventDao;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private AlarmDao m_alarmDao;
    @Autowired
    private MemoDao m_memoDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;
    private static boolean m_populated = false;

    public void afterPropertiesSet() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeTransaction
    public void setUp() {
        try {
            if (!m_populated) {
                this.m_databasePopulator.populateDatabase();
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        finally {
            m_populated = true;
        }
    }

    @Test
    @Transactional
    public void testAddStickyMemoToExistingAlarm() {
        OnmsEvent event = new OnmsEvent();
        event.setEventLog("Y");
        event.setEventDisplay("Y");
        event.setEventCreateTime(new Date());
        event.setDistPoller((OnmsDistPoller)this.m_distPollerDao.load((Serializable)((Object)"localhost")));
        event.setEventTime(new Date());
        event.setEventSeverity(new Integer(7));
        event.setEventUei("uei://org/opennms/test/EventDaoTest");
        event.setEventSource("test");
        this.m_eventDao.save((Object)event);
        OnmsNode node = (OnmsNode)this.m_nodeDao.findAll().iterator().next();
        OnmsAlarm alarm = new OnmsAlarm();
        alarm.setNode(node);
        alarm.setUei(event.getEventUei());
        alarm.setSeverityId(event.getEventSeverity());
        alarm.setFirstEventTime(event.getEventTime());
        alarm.setLastEvent(event);
        alarm.setCounter(Integer.valueOf(1));
        alarm.setDistPoller((OnmsDistPoller)this.m_distPollerDao.load((Serializable)((Object)"localhost")));
        alarm.setReductionKey("fristReductionKey");
        this.m_alarmDao.save((Object)alarm);
        OnmsAlarm newAlarm = (OnmsAlarm)this.m_alarmDao.load((Serializable)alarm.getId());
        Assert.assertEquals((Object)"uei://org/opennms/test/EventDaoTest", (Object)newAlarm.getUei());
        Assert.assertEquals((Object)alarm.getLastEvent().getId(), (Object)newAlarm.getLastEvent().getId());
        OnmsMemo memo = new OnmsMemo();
        memo.setBody("Call me Ishmael...");
        memo.setAuthor("Herman Melville");
        Date memoCreation = new Date();
        memo.setCreated(memoCreation);
        newAlarm.setStickyMemo(memo);
        this.m_alarmDao.update((Object)newAlarm);
        this.m_alarmDao.flush();
        Assert.assertNotNull((Object)newAlarm.getStickyMemo().getId());
        Assert.assertNotNull((Object)newAlarm.getStickyMemo().getCreated());
        Assert.assertNotNull((Object)newAlarm.getStickyMemo().getAuthor());
        Assert.assertNotNull((Object)newAlarm.getStickyMemo().getBody());
        Assert.assertNotNull((Object)alarm.getStickyMemo().getId());
        Assert.assertNotNull((Object)alarm.getStickyMemo().getCreated());
        Assert.assertNotNull((Object)alarm.getStickyMemo().getAuthor());
        Assert.assertNotNull((Object)alarm.getStickyMemo().getBody());
    }
}

