/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao;

import java.util.List;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.opennms.core.test.OpenNMSJUnit4ClassRunner;
import org.opennms.netmgt.dao.DatabasePopulator;
import org.opennms.netmgt.dao.NodeDao;
import org.opennms.netmgt.dao.db.JUnitConfigurationEnvironment;
import org.opennms.netmgt.dao.db.JUnitTemporaryDatabase;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsNode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.transaction.annotation.Transactional;

@RunWith(value=OpenNMSJUnit4ClassRunner.class)
@ContextConfiguration(locations={"classpath:/META-INF/opennms/applicationContext-dao.xml", "classpath:/META-INF/opennms/applicationContext-databasePopulator.xml", "classpath:/META-INF/opennms/applicationContext-setupIpLike-enabled.xml", "classpath*:/META-INF/opennms/component-dao.xml"})
@JUnitConfigurationEnvironment
@JUnitTemporaryDatabase(dirtiesContext=false)
public class CriteriaTest {
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private DatabasePopulator m_databasePopulator;
    private static boolean m_populated = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @BeforeTransaction
    public void setUp() {
        try {
            if (!m_populated) {
                this.m_databasePopulator.populateDatabase();
            }
        }
        catch (Throwable e) {
            e.printStackTrace(System.err);
        }
        finally {
            m_populated = true;
        }
    }

    @Test
    @Transactional
    public void testSimple() {
        OnmsCriteria crit = new OnmsCriteria(OnmsNode.class);
        crit.add((Criterion)Restrictions.eq((String)"label", (Object)"node1"));
        List matching = this.m_nodeDao.findMatching(crit);
        Assert.assertEquals((String)"Expect a single node with label node1", (long)1L, (long)matching.size());
        OnmsNode node = (OnmsNode)matching.iterator().next();
        Assert.assertEquals((Object)"node1", (Object)node.getLabel());
        Assert.assertEquals((long)4L, (long)node.getIpInterfaces().size());
    }

    @Test
    @Transactional
    public void testComplicated() {
        OnmsCriteria crit = new OnmsCriteria(OnmsNode.class).createAlias("ipInterfaces", "iface").add((Criterion)Restrictions.eq((String)"iface.ipAddress", (Object)"192.168.2.1"));
        List matching = this.m_nodeDao.findMatching(crit);
        Assert.assertEquals((String)"Expect a single node with an interface 192.168.2.1", (long)1L, (long)matching.size());
        OnmsNode node = (OnmsNode)matching.iterator().next();
        Assert.assertEquals((Object)"node2", (Object)node.getLabel());
        Assert.assertEquals((long)3L, (long)node.getIpInterfaces().size());
    }
}

