/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.opennms.netmgt.dao.api.SnmpInterfaceDao;
import org.opennms.netmgt.dao.mock.AbstractMockDao;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockSnmpInterfaceDao
extends AbstractMockDao<OnmsSnmpInterface, Integer>
implements SnmpInterfaceDao {
    private static final Logger LOG = LoggerFactory.getLogger(MockSnmpInterfaceDao.class);
    private AtomicInteger m_id = new AtomicInteger(0);

    @Override
    public Integer save(OnmsSnmpInterface iface) {
        this.updateParent(iface);
        return (Integer)super.save(iface);
    }

    @Override
    public void update(OnmsSnmpInterface iface) {
        this.updateParent(iface);
        super.update(iface);
    }

    @Override
    protected void generateId(OnmsSnmpInterface iface) {
        iface.setId(Integer.valueOf(this.m_id.incrementAndGet()));
    }

    @Override
    protected Integer getId(OnmsSnmpInterface iface) {
        return iface.getId();
    }

    private void updateParent(OnmsSnmpInterface iface) {
        OnmsNode node = null;
        if (iface.getNodeId() != null) {
            node = (OnmsNode)this.getNodeDao().get((Serializable)iface.getNodeId());
        } else if (iface.getNode() != null) {
            node = this.getNodeDao().findByForeignId(iface.getNode().getForeignSource(), iface.getNode().getForeignId());
        }
        if (node != null && node != iface.getNode()) {
            LOG.debug("merging node {} into node {}", (Object)iface.getNode(), (Object)node);
            node.mergeNode(iface.getNode(), (EventForwarder)new AbstractMockDao.NullEventForwarder(), false);
            iface.setNode(node);
        }
        if (!iface.getNode().getSnmpInterfaces().contains(iface)) {
            LOG.debug("adding SNMP interface to node {}: {}", (Object)iface.getNode().getId(), (Object)iface);
            iface.getNode().addSnmpInterface(iface);
        }
    }

    public OnmsSnmpInterface findByNodeIdAndIfIndex(Integer nodeId, Integer ifIndex) {
        for (OnmsSnmpInterface iface : this.findAll()) {
            if (!nodeId.equals(iface.getNode().getId()) || !ifIndex.equals(iface.getIfIndex())) continue;
            return iface;
        }
        return null;
    }

    public OnmsSnmpInterface findByForeignKeyAndIfIndex(String foreignSource, String foreignId, Integer ifIndex) {
        for (OnmsSnmpInterface iface : this.findAll()) {
            OnmsNode node = iface.getNode();
            if (!foreignSource.equals(node.getForeignSource()) || !foreignId.equals(node.getForeignId()) || !ifIndex.equals(iface.getIfIndex())) continue;
            return iface;
        }
        return null;
    }

    public OnmsSnmpInterface findByNodeIdAndDescription(Integer nodeId, String description) {
        for (OnmsSnmpInterface iface : this.findAll()) {
            OnmsNode node = iface.getNode();
            if (!description.equals(node.getSysDescription())) continue;
            return iface;
        }
        return null;
    }

    public void markHavingIngressFlows(Integer nodeId, Collection<Integer> ingressSnmpIfIndexes) {
    }

    public void markHavingEgressFlows(Integer nodeId, Collection<Integer> egressSnmpIfIndexes) {
    }

    public List<OnmsSnmpInterface> findAllHavingFlows(Integer nodeId) {
        return Collections.emptyList();
    }

    public List<OnmsSnmpInterface> findAllHavingIngressFlows(Integer nodeId) {
        return Collections.emptyList();
    }

    public List<OnmsSnmpInterface> findAllHavingEgressFlows(Integer nodeId) {
        return Collections.emptyList();
    }
}

