/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.dao.mock;

import java.net.InetAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.filter.api.FilterDao;
import org.opennms.netmgt.filter.api.FilterParseException;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.Assert;

public class MockFilterDao
implements FilterDao,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(MockFilterDao.class);
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_ipInterfaceDao);
    }

    public SortedMap<Integer, String> getNodeMap(String rule) throws FilterParseException {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public Map<InetAddress, Set<String>> getIPAddressServiceMap(String rule) throws FilterParseException {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public void flushActiveIpAddressListCache() {
    }

    public List<InetAddress> getActiveIPAddressList(String rule) throws FilterParseException {
        LOG.debug("rule = {}", (Object)rule);
        ArrayList<InetAddress> addrs = new ArrayList<InetAddress>();
        if (rule.equals("IPADDR != '0.0.0.0'")) {
            Assert.notNull((Object)this.m_ipInterfaceDao);
            CriteriaBuilder builder = new CriteriaBuilder(OnmsIpInterface.class);
            builder.ne("ipAddress", (Object)"0.0.0.0");
            builder.ne("isManaged", (Object)"D");
            builder.distinct();
            Criteria criteria = builder.toCriteria();
            for (OnmsIpInterface iface : this.m_ipInterfaceDao.findMatching(criteria)) {
                addrs.add(iface.getIpAddress());
            }
            return addrs;
        }
        if (rule.equals("foreignSource == 'Minions' AND IPADDR != '0.0.0.0'")) {
            Assert.notNull((Object)this.m_ipInterfaceDao);
            CriteriaBuilder builder = new CriteriaBuilder(OnmsIpInterface.class);
            builder.ne("ipAddress", (Object)"0.0.0.0");
            builder.ne("isManaged", (Object)"D");
            builder.eq("node.location.locationName", (Object)"Minions");
            builder.distinct();
            Criteria criteria = builder.toCriteria();
            for (OnmsIpInterface iface : this.m_ipInterfaceDao.findMatching(criteria)) {
                addrs.add(iface.getIpAddress());
            }
            return addrs;
        }
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public List<InetAddress> getIPAddressList(String rule) throws FilterParseException {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public boolean isValid(String addr, String rule) throws FilterParseException {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public boolean isRuleMatching(String rule) throws FilterParseException {
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public void validateRule(String rule) throws FilterParseException {
        if ("IPADDR != '0.0.0.0'".equals(rule) || "foreignSource == 'Minions' AND IPADDR != '0.0.0.0'".equals(rule)) {
            return;
        }
        throw new UnsupportedOperationException("Not yet implemented!");
    }

    public IpInterfaceDao getIpInterfaceDao() {
        return this.m_ipInterfaceDao;
    }

    public void setIpInterfaceDao(IpInterfaceDao dao) {
        this.m_ipInterfaceDao = dao;
    }
}

